/*
 * Decompiled with CFR 0.152.
 */
package soccorob.si.ip;

import Jama.Matrix;

public class KFBall {
    private Matrix A;
    private Matrix B;
    private Matrix K;
    private Matrix x;
    private Matrix H;
    private Matrix Q;
    private Matrix R;
    private Matrix P;
    private Matrix xMinus;
    private Matrix oldx;
    private Matrix BEffect;
    private Matrix xPredict;
    private Matrix error;
    private Matrix gain;
    private Matrix z = new Matrix(2, 1);
    private Matrix pred_x = new Matrix(4, 2);
    private Matrix pred_P = new Matrix(2, 2);
    private double angle1;
    private double angle2;
    private double diff;
    private double alpha = 0.99;
    public static final double deltat = 0.06;

    public KFBall() {
        this.A = new Matrix(4, 4);
        this.A.set(0, 0, 1.0);
        this.A.set(1, 1, 1.0);
        this.A.set(2, 2, this.alpha);
        this.A.set(3, 3, this.alpha);
        this.A.set(0, 2, 1.0);
        this.A.set(1, 3, 1.0);
        this.H = new Matrix(2, 4);
        this.H.set(0, 0, 1.0);
        this.H.set(1, 1, 1.0);
        this.Q = new Matrix(4, 4);
        this.Q.set(0, 0, 1.0);
        this.Q.set(1, 1, 1.0);
        this.Q.set(2, 2, 10.0);
        this.Q.set(3, 3, 10.0);
        this.R = new Matrix(2, 2);
        this.R.set(0, 0, 10.0);
        this.R.set(1, 1, 10.0);
        this.P = Matrix.identity(4, 4).times(10000.0);
        this.x = new Matrix(4, 1);
    }

    public Matrix cycle(double _x, double _y) {
        this.z.set(0, 0, _x);
        this.z.set(1, 0, _y);
        this.pred_x = this.A.times(this.x);
        this.pred_P = this.A.times(this.P.times(this.A.transpose())).plus(this.Q);
        Matrix Tmp1 = this.pred_P.times(this.H.transpose());
        Matrix Tmp2 = this.H.times(Tmp1);
        Tmp2 = Tmp2.plus(this.R);
        Tmp2 = Tmp2.inverse();
        this.K = Tmp1.times(Tmp2);
        Matrix e = this.z.minus(this.H.times(this.pred_x));
        this.x = this.pred_x.plus(this.K.times(e));
        this.P = Matrix.identity(4, 4).minus(this.K.times(this.H));
        this.P = this.P.times(this.pred_P);
        return this.x;
    }

    public static void main(String[] argv) {
        KFBall kfb = new KFBall();
        int i = 0;
        while (i < 10) {
            double a = 0.1 * (double)i;
            double r = 1000 - i;
            double _x = r * Math.cos(a);
            double _y = r * Math.sin(a);
            double _dx = -Math.cos(a) - r * Math.sin(a) * 0.1;
            double _dy = -Math.sin(a) + r * Math.cos(a) * 0.1;
            double _xr = _x;
            double _yr = _y;
            Matrix x = kfb.cycle(_xr, _yr);
            System.out.println("true: " + _x + ", " + _y + ", " + _dx + ", " + _dy);
            x.transpose().print(4, 2);
            System.out.println("pre-err  : " + Math.sqrt((_x - _xr) * (_x - _xr) + (_y - _yr) * (_y - _yr)));
            System.out.println("post-errr: " + Math.sqrt((_x - x.get(0, 0)) * (_x - x.get(0, 0)) + (_y - x.get(1, 0)) * (_y - x.get(1, 0))));
            ++i;
        }
    }
}

