/*
 * Decompiled with CFR 0.152.
 */
package soccorob.si.ip;

import Jama.Matrix;

public class KF {
    private Matrix A;
    private Matrix B;
    private Matrix K;
    private Matrix x;
    private Matrix xMinus;
    private Matrix oldx;
    private Matrix BEffect;
    private Matrix xPredict;
    private Matrix error;
    private Matrix gain;
    private double angle1;
    private double angle2;
    private double diff;
    public static final double deltat = 0.06;
    private static final int POSX = 0;
    private static final int POSY = 1;
    private static final int ANGLE = 2;
    private static final int SPEED = 3;
    private static final int SPIN = 4;
    public static final double ballTrustEst = 0.3;
    public static final double ballDeceleration = 0.9;
    static final Matrix xBall = new Matrix(1, 5);
    static final Matrix ABall = new Matrix(5, 5);
    static final Matrix BBall = new Matrix(5, 5);
    static final Matrix KBall = new Matrix(5, 5);
    public static final double robotTrustEst = 0.3;
    public static final double robotDeceleration = 0.9;
    static final Matrix xRobot = new Matrix(1, 5);
    static final Matrix ARobot = new Matrix(5, 5);
    static final Matrix BRobot = new Matrix(5, 5);
    static final Matrix KRobot = new Matrix(5, 5);

    public KF(Matrix A, Matrix B, Matrix K, Matrix startX) {
        xBall.set(0, 0, 0.0);
        xBall.set(0, 1, 0.0);
        xBall.set(0, 2, 0.0);
        xBall.set(0, 3, 0.0);
        xBall.set(0, 4, 0.0);
        ABall.set(0, 0, 0.0);
        ABall.set(0, 1, 0.0);
        ABall.set(0, 2, 0.0);
        ABall.set(0, 3, 0.0);
        ABall.set(0, 4, 0.0);
        ABall.set(1, 0, 0.0);
        ABall.set(1, 1, 0.0);
        ABall.set(1, 2, 0.0);
        ABall.set(1, 3, 0.0);
        ABall.set(1, 4, 0.0);
        ABall.set(2, 0, 0.0);
        ABall.set(2, 1, 0.0);
        ABall.set(2, 2, 0.0);
        ABall.set(2, 3, 0.0);
        ABall.set(2, 4, 0.0);
        ABall.set(3, 0, 0.0);
        ABall.set(3, 1, 0.0);
        ABall.set(3, 2, 0.0);
        ABall.set(3, 3, 0.0);
        ABall.set(3, 4, 0.0);
        ABall.set(4, 0, 0.0);
        ABall.set(4, 1, 0.0);
        ABall.set(4, 2, 0.0);
        ABall.set(4, 3, 0.0);
        ABall.set(4, 4, 0.0);
        BBall.set(0, 0, 0.0);
        BBall.set(0, 1, 0.0);
        BBall.set(0, 2, 0.0);
        BBall.set(0, 3, 0.0);
        BBall.set(0, 4, 0.0);
        BBall.set(1, 0, 0.0);
        BBall.set(1, 1, 0.0);
        BBall.set(1, 2, 0.0);
        BBall.set(1, 3, 0.0);
        BBall.set(1, 4, 0.0);
        BBall.set(2, 0, 0.0);
        BBall.set(2, 1, 0.0);
        BBall.set(2, 2, 0.0);
        BBall.set(2, 3, 0.0);
        BBall.set(2, 4, 0.0);
        BBall.set(3, 0, 0.0);
        BBall.set(3, 1, 0.0);
        BBall.set(3, 2, 0.0);
        BBall.set(3, 3, 0.0);
        BBall.set(3, 4, 0.0);
        BBall.set(4, 0, 0.0);
        BBall.set(4, 1, 0.0);
        BBall.set(4, 2, 0.0);
        BBall.set(4, 3, 0.0);
        BBall.set(4, 4, 0.0);
        KBall.set(0, 0, 0.7);
        KBall.set(0, 1, 0.0);
        KBall.set(0, 2, 0.0);
        KBall.set(0, 3, 0.0);
        KBall.set(0, 4, 0.0);
        KBall.set(1, 0, 0.0);
        KBall.set(1, 1, 0.7);
        KBall.set(1, 2, 0.0);
        KBall.set(1, 3, 0.0);
        KBall.set(1, 4, 0.0);
        KBall.set(2, 0, 0.0);
        KBall.set(2, 1, 0.0);
        KBall.set(2, 2, 0.7);
        KBall.set(2, 3, 0.0);
        KBall.set(2, 4, 0.0);
        KBall.set(3, 0, 0.0);
        KBall.set(3, 1, 0.0);
        KBall.set(3, 2, 0.0);
        KBall.set(3, 3, 0.7);
        KBall.set(3, 4, 0.0);
        KBall.set(4, 0, 0.0);
        KBall.set(4, 1, 0.0);
        KBall.set(4, 2, 0.0);
        KBall.set(4, 3, 0.0);
        KBall.set(4, 4, 0.7);
        xRobot.set(0, 0, 0.0);
        xRobot.set(0, 1, 0.0);
        xRobot.set(0, 2, 0.0);
        xRobot.set(0, 3, 0.0);
        xRobot.set(0, 4, 0.0);
        ARobot.set(0, 0, 0.0);
        ARobot.set(0, 1, 0.0);
        ARobot.set(0, 2, 0.0);
        ARobot.set(0, 3, 0.0);
        ARobot.set(0, 4, 0.0);
        ARobot.set(1, 0, 0.0);
        ARobot.set(1, 1, 0.0);
        ARobot.set(1, 2, 0.0);
        ARobot.set(1, 3, 0.0);
        ARobot.set(1, 4, 0.0);
        ARobot.set(2, 0, 0.0);
        ARobot.set(2, 1, 0.0);
        ARobot.set(2, 2, 0.0);
        ARobot.set(2, 3, 0.0);
        ARobot.set(2, 4, 0.0);
        ARobot.set(3, 0, 0.0);
        ARobot.set(3, 1, 0.0);
        ARobot.set(3, 2, 0.0);
        ARobot.set(3, 3, 0.0);
        ARobot.set(3, 4, 0.0);
        ARobot.set(4, 0, 0.0);
        ARobot.set(4, 1, 0.0);
        ARobot.set(4, 2, 0.0);
        ARobot.set(4, 3, 0.0);
        ARobot.set(4, 4, 0.0);
        BRobot.set(0, 0, 0.0);
        BRobot.set(0, 1, 0.0);
        BRobot.set(0, 2, 0.0);
        BRobot.set(0, 3, 0.0);
        BRobot.set(0, 4, 0.0);
        BRobot.set(1, 0, 0.0);
        BRobot.set(1, 1, 0.0);
        BRobot.set(1, 2, 0.0);
        BRobot.set(1, 3, 0.0);
        BRobot.set(1, 4, 0.0);
        BRobot.set(2, 0, 0.0);
        BRobot.set(2, 1, 0.0);
        BRobot.set(2, 2, 0.0);
        BRobot.set(2, 3, 0.0);
        BRobot.set(2, 4, 0.0);
        BRobot.set(3, 0, 0.0);
        BRobot.set(3, 1, 0.0);
        BRobot.set(3, 2, 0.0);
        BRobot.set(3, 3, 0.0);
        BRobot.set(3, 4, 0.0);
        BRobot.set(4, 0, 0.0);
        BRobot.set(4, 1, 0.0);
        BRobot.set(4, 2, 0.0);
        BRobot.set(4, 3, 0.0);
        BRobot.set(4, 4, 0.0);
        KRobot.set(0, 0, 0.7);
        KRobot.set(0, 1, 0.0);
        KRobot.set(0, 2, 0.0);
        KRobot.set(0, 3, 0.0);
        KRobot.set(0, 4, 0.0);
        KRobot.set(1, 0, 0.0);
        KRobot.set(1, 1, 0.7);
        KRobot.set(1, 2, 0.0);
        KRobot.set(1, 3, 0.0);
        KRobot.set(1, 4, 0.0);
        KRobot.set(2, 0, 0.0);
        KRobot.set(2, 1, 0.0);
        KRobot.set(2, 2, 0.7);
        KRobot.set(2, 3, 0.0);
        KRobot.set(2, 4, 0.0);
        KRobot.set(3, 0, 0.0);
        KRobot.set(3, 1, 0.0);
        KRobot.set(3, 2, 0.0);
        KRobot.set(3, 3, 0.7);
        KRobot.set(3, 4, 0.0);
        KRobot.set(4, 0, 0.0);
        KRobot.set(4, 1, 0.0);
        KRobot.set(4, 2, 0.0);
        KRobot.set(4, 3, 0.0);
        KRobot.set(4, 4, 0.7);
        this.A = A;
        this.B = B;
        this.K = K;
        this.oldx = startX;
        int rows = this.oldx.getRowDimension();
        int cols = this.oldx.getColumnDimension();
        this.xMinus = new Matrix(rows, cols);
        this.BEffect = new Matrix(rows, cols);
        this.xPredict = new Matrix(rows, cols);
        this.error = new Matrix(rows, cols);
        this.gain = new Matrix(rows, cols);
        this.x = new Matrix(rows, cols);
    }

    public Matrix cycle(Matrix u, Matrix z) {
        this.xPredict.set(0, 0, this.oldx.get(0, 0) + 0.06 * this.oldx.get(0, 3) * Math.cos(Math.toRadians(this.oldx.get(0, 2))));
        this.xPredict.set(0, 1, this.oldx.get(0, 1) + 0.06 * this.oldx.get(0, 3) * Math.sin(Math.toRadians(this.oldx.get(0, 2))));
        this.xPredict.set(0, 2, this.oldx.get(0, 2) + 0.06 * this.oldx.get(0, 4));
        this.xPredict.set(0, 3, this.oldx.get(0, 3) * 0.9);
        this.xPredict.set(0, 4, this.oldx.get(0, 4));
        this.BEffect = u.times(this.B);
        this.xMinus = this.xPredict.plus(this.BEffect);
        this.xMinus.set(0, 2, (this.xMinus.get(0, 2) + 720.0) % 360.0);
        this.error = z.minus(this.xMinus);
        this.angle1 = z.get(0, 2);
        this.angle2 = this.xMinus.get(0, 2);
        this.diff = this.angle1 - this.angle2;
        if (this.diff > 180.0) {
            this.diff -= 360.0;
        }
        if (this.diff < -180.0) {
            this.diff += 360.0;
        }
        this.error.set(0, 2, this.diff);
        this.gain = this.error.times(this.K);
        this.x = this.xMinus.plus(this.gain);
        this.x.set(0, 2, (this.x.get(0, 2) + 720.0) % 360.0);
        this.oldx = this.x;
        return this.x;
    }

    public static KF getBallFilter() {
        return new KF(ABall, BBall, KBall, xBall);
    }

    public static KF getRobotFilter() {
        return new KF(ARobot, BRobot, KRobot, xRobot);
    }
}

