/*
 * Decompiled with CFR 0.152.
 */
package soccorob.rt.util;

import soccorob.rt.util.ThreadNode;

public abstract class SortedThreadList {
    private ThreadNode front = null;

    public abstract boolean isGreater(ThreadNode var1, ThreadNode var2);

    public boolean isEmpty() {
        return this.front == null;
    }

    public void insert(ThreadNode newNode) {
        newNode.next = null;
        if (this.isEmpty()) {
            this.front = newNode;
        } else if (this.isGreater(newNode, this.front)) {
            newNode.next = this.front;
            this.front = newNode;
        } else {
            ThreadNode pos = this.front;
            while (true) {
                if (pos.next == null) {
                    pos.next = newNode;
                    break;
                }
                if (this.isGreater(newNode, pos.next)) {
                    newNode.next = pos.next;
                    pos.next = newNode;
                    break;
                }
                pos = pos.next;
            }
        }
    }

    public ThreadNode getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.front;
    }

    public ThreadNode remove(ThreadNode removeNode) {
        if (this.front == removeNode) {
            return this.removeFirst();
        }
        ThreadNode pos = this.front;
        while (pos != null) {
            if (pos.next == removeNode) {
                ThreadNode temp = pos.next;
                pos.next = pos.next.next;
                return pos;
            }
            pos = pos.next;
        }
        return null;
    }

    public ThreadNode removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        ThreadNode temp = this.front;
        this.front = this.front.next;
        return temp;
    }

    public String toString() {
        ThreadNode pos = this.front;
        String buf = "The processes are:";
        while (pos != null) {
            buf = String.valueOf(buf) + "\nID = " + pos.thread.getID() + " Name = " + " " + pos.thread.getName() + " " + pos.toString();
            pos = pos.next;
        }
        return buf;
    }
}

