/*
 * Decompiled with CFR 0.152.
 */
package soccorob.rt.etst;

import soccorob.rt.time.HighResTiming;

public class ExecTimeStatistics {
    private HighResTiming timing = new HighResTiming();
    private int[] data;
    private int pointer;
    private int sampleNumber;
    private int fromSample;
    private String name;

    public ExecTimeStatistics(int sampleNumber, int fromSample, String name) {
        this.data = new int[sampleNumber];
        this.pointer = 0;
        this.sampleNumber = sampleNumber;
        this.fromSample = fromSample;
        this.name = name;
    }

    public void start() {
        this.timing.start();
    }

    public void stop() {
        if (this.pointer < this.sampleNumber) {
            this.data[this.pointer++] = this.timing.getElapsed();
        }
    }

    public double getAverage() {
        int sum = 0;
        int i = this.fromSample - 1;
        while (i < this.pointer) {
            sum += this.data[i];
            ++i;
        }
        return (double)sum / (double)(this.pointer - this.fromSample + 1);
    }

    public double getStandardDeviation() {
        double avg = this.getAverage();
        double squareSum = 0.0;
        int i = this.fromSample - 1;
        while (i < this.pointer) {
            squareSum += ((double)this.data[i] - avg) * ((double)this.data[i] - avg);
            ++i;
        }
        return Math.sqrt(squareSum / (double)(this.pointer - this.fromSample + 1));
    }

    public int getMax() {
        int max = 0;
        int i = this.fromSample - 1;
        while (i < this.pointer) {
            if (this.data[i] > max) {
                max = this.data[i];
            }
            ++i;
        }
        return max;
    }

    public double getTDistConfInt(int confidence) {
        double s = this.getStandardDeviation();
        double t = 0.0;
        if (confidence == 95) {
            t = 1.645;
        } else if (confidence == 99) {
            t = 2.326;
        } else {
            System.out.println("Error in ExecTimeStatistics: Confidence interval not supported.");
        }
        return this.getAverage() + t * s / Math.sqrt(this.pointer - this.fromSample + 1);
    }

    public int getNumSamples() {
        return this.pointer - this.fromSample + 1;
    }

    public void printValues() {
        int i = this.fromSample - 1;
        while (i < this.pointer) {
            System.out.println(this.data[i]);
            ++i;
        }
    }

    public String toString() {
        String buf = "Execution time statistics for " + this.name + ":\n" + "Average = " + this.getAverage() + " microseconds\n" + "Standard Deviation = " + this.getStandardDeviation() + "\n" + "WCE Estimation, 95% Conf. Int, t-distribution  = " + this.getTDistConfInt(95) + "\n" + "WCE Estimation, 99% Conf. Int, t-distribution  = " + this.getTDistConfInt(99) + "\n" + "Max = " + this.getMax() + " microseconds\n" + "Number of samples = " + this.getNumSamples();
        return buf;
    }
}

