/*
 * Decompiled with CFR 0.152.
 */
package soccorob.rt;

import soccorob.rt.PeriodicParameters;
import soccorob.rt.PriorityParameters;
import soccorob.rt.RLThread;
import soccorob.rt.Scheduler;
import soccorob.rt.time.AbsoluteTime;
import soccorob.rt.time.HighResolutionClock;
import soccorob.rt.util.EarliestReleaseSortedList;
import soccorob.rt.util.PeriodicitySortedList;
import soccorob.rt.util.PrioritySortedList;
import soccorob.rt.util.RMThreadNode;

public class RateMonotonicSchedulerRef
extends Scheduler {
    private PrioritySortedList readyList;
    private EarliestReleaseSortedList suspendedList;

    public RateMonotonicSchedulerRef() {
        super(false);
        System.out.println("Rate monotonic scheduler initiated");
        RLThread[] threadList = (RLThread[])this.getThreads();
        PeriodicitySortedList sortThreadList = new PeriodicitySortedList();
        int i = 0;
        while (i < threadList.length) {
            sortThreadList.insert(new RMThreadNode(threadList[i]));
            ++i;
        }
        this.readyList = new PrioritySortedList();
        this.suspendedList = new EarliestReleaseSortedList();
        i = 0;
        while (i < threadList.length) {
            RMThreadNode threadNode = (RMThreadNode)sortThreadList.removeFirst();
            threadNode.thread.setSchedulingParameters(new PriorityParameters(threadList.length - i));
            threadNode.nextRelease.setTime(((PeriodicParameters)threadNode.thread.getReleaseParameters()).getStart());
            threadNode.nextRelease.add(threadNode.thread.getReleaseParameters().getDeadline(), threadNode.deadline);
            this.readyList.insert(threadNode);
            ++i;
        }
    }

    @Override
    public String getPolicyName() {
        return "FPS: Rate monotonic";
    }

    @Override
    public boolean isFeasible() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void start() {
        absTime = new AbsoluteTime();
        HighResolutionClock.resetClock();
        block0: while (true) {
            if (!this.readyList.isEmpty()) {
                readyThreadNode = (RMThreadNode)this.readyList.getFirst();
                readyThread = readyThreadNode.thread;
                this.fireThread(readyThread);
            }
            currNode = (RMThreadNode)this.readyList.getFirst();
            while (currNode != null) {
                currThread = currNode.thread;
                nextNode = (RMThreadNode)currNode.next;
                HighResolutionClock.getTime(absTime);
                if (absTime.isGreater(currNode.deadline)) {
                    HighResolutionClock.getTime(absTime);
                    currThread.getDeadlineMissHandler().handleAsyncEvent();
                }
                if (currThread.isFinished()) {
                    this.readyList.remove(currNode);
                    currNode.nextRelease.add(((PeriodicParameters)currThread.getReleaseParameters()).getPeriod(), currNode.nextRelease);
                    currNode.nextRelease.add(currThread.getReleaseParameters().getDeadline(), currNode.deadline);
                    this.suspendedList.insert(currNode);
                }
                currNode = nextNode;
            }
            HighResolutionClock.getTime(absTime);
            while (true) {
                if (this.suspendedList.isEmpty()) continue block0;
                suspendedThreadNode = (RMThreadNode)this.suspendedList.getFirst();
                suspendedThread = suspendedThreadNode.thread;
                if (!suspendedThreadNode.nextRelease.isGreater(absTime)) ** break;
                continue block0;
                this.suspendedList.removeFirst();
                suspendedThread.setReady();
                this.readyList.insert(suspendedThreadNode);
            }
            break;
        }
    }
}

