/*
 * Decompiled with CFR 0.152.
 */
package soccorob.comm;

import soccorob.ai.wm.WorldModel;
import soccorob.comm.ActuatorInterface;
import soccorob.comm.RoboLabAgent;
import soccorob.rt.AsyncEventHandler;
import soccorob.rt.RLThread;
import soccorob.rt.RunnableBlock;

public class SimActuator
extends RLThread
implements ActuatorInterface {
    private int NO_PLAYERS = WorldModel.players;
    private RoboLabAgent[] agents;
    private int[] leftEngine;
    private int[] rightEngine;
    private boolean[] receivedCommand;
    private DeadlineMissHandler deadlineMissHandler = new DeadlineMissHandler();

    public SimActuator(boolean opponent, String serverHost, String teamName) {
        if (this.agents == null) {
            this.agents = new RoboLabAgent[this.NO_PLAYERS];
            this.leftEngine = new int[this.NO_PLAYERS];
            this.rightEngine = new int[this.NO_PLAYERS];
            this.receivedCommand = new boolean[this.NO_PLAYERS];
            int i = 0;
            while (i < this.NO_PLAYERS) {
                this.agents[i] = new RoboLabAgent(opponent, serverHost, teamName, i + 1, -20, 20 * i - 20);
                this.leftEngine[i] = 0;
                this.rightEngine[i] = 0;
                this.receivedCommand[i] = false;
                ++i;
            }
            this.runnableBlocks = new RunnableBlock[1];
            this.runnableBlocks[0] = new Part1();
        }
    }

    @Override
    public void power(int nr, int left, int right) {
        this.leftEngine[nr - 1] = left;
        this.rightEngine[nr - 1] = right;
        this.receivedCommand[nr - 1] = true;
    }

    @Override
    public void say(int toWhom, String what) {
    }

    @Override
    public void beep(int nr, int frequency, int duration) {
    }

    @Override
    public int getLeftEngine(int n) {
        return this.leftEngine[n];
    }

    @Override
    public int getRightEngine(int n) {
        return this.rightEngine[n];
    }

    @Override
    public AsyncEventHandler getDeadlineMissHandler() {
        return this.deadlineMissHandler;
    }

    class DeadlineMissHandler
    extends AsyncEventHandler {
        DeadlineMissHandler() {
        }

        @Override
        public void handleAsyncEvent() {
            SimActuator.this.waitForNextPeriod();
        }
    }

    class Part1
    implements RunnableBlock {
        Part1() {
        }

        @Override
        public void run() {
            int nr = 0;
            while (nr < SimActuator.this.NO_PLAYERS) {
                if (SimActuator.this.receivedCommand[nr]) {
                    SimActuator.this.agents[nr].sendCommand(SimActuator.this.leftEngine[nr], SimActuator.this.rightEngine[nr]);
                    ((SimActuator)SimActuator.this).receivedCommand[nr] = false;
                }
                ++nr;
            }
            SimActuator.this.waitForNextPeriod();
        }
    }
}

