/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import soccorob.ai.Team;
import soccorob.ai.Vector;
import soccorob.ai.agent.Agent;
import soccorob.ai.wm.BallObject;
import soccorob.ai.wm.PlayerObject;
import soccorob.ai.wm.WorldModel;

public class VisionGui
extends JFrame {
    Agent agent;
    double x;
    double y;
    boolean isAutomatic = false;
    JPanel testPanel = new Field();

    public VisionGui(Agent agent) {
        this.agent = agent;
        this.setTitle("VisionGui for agent " + Integer.toString(agent.no));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.testPanel, "Center");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WorldModel.setGameStatus(false);
                VisionGui.this.dispose();
                System.exit(0);
            }
        });
    }

    class Field
    extends JPanel
    implements Runnable {
        int w = 2500;
        int h = 1500;
        int mmPerPixel = 5;
        int padX = 10;
        int padY = 10;
        int comW = this.w / this.mmPerPixel + 2 * this.padX;
        int comH = this.h / this.mmPerPixel + 2 * this.padY + this.benchY;
        int benchY = 40;
        Thread thread;
        boolean running;

        Field() {
            this.setPreferredSize(new Dimension(this.comW, this.comH));
            this.running = true;
            this.thread = new Thread(this);
            this.thread.start();
        }

        int getPixelX(int wx) {
            return (wx + this.w / 2) / this.mmPerPixel + this.padX;
        }

        int getPixelY(int wy) {
            return (wy + this.h / 2) / this.mmPerPixel + this.padY;
        }

        public void drawPlayer(PlayerObject player, Graphics g) {
            int dxy;
            g.setColor(Color.white);
            Vector v = player.getVel();
            int x = (int)player.getPos().x;
            int y = (int)player.getPos().y;
            if (player.getConfidence() < 0.5) {
                x = -this.w / 2 - 50;
                x += player.no * 200;
                if (player.team == Team.THEM) {
                    x = -x;
                }
                y = this.h / 2 + 100;
            }
            int dxx = (int)(Math.cos(v.getRadAngle()) * 70.0);
            int dyx = dxy = (int)(Math.sin(v.getRadAngle()) * 70.0);
            int dyy = -dxx;
            if (player.team == Team.WE) {
                g.setColor(new Color(0.6f, 0.7f, 1.0f));
            } else {
                g.setColor(new Color(1.0f, 0.7f, 0.6f));
            }
            int x1 = (int)((double)x + (double)dxx * 0.5);
            int y1 = (int)((double)y + (double)dxy * 0.5);
            g.setFont(new Font("Monospaced", 1, 8));
            g.drawString("" + player.no, this.getPixelX(x1), this.getPixelY(y1) + 4);
            x1 = x + dxx + dyx;
            y1 = y + dxy + dyy;
            int x2 = x + dxx - dyx;
            int y2 = y + dxy - dyy;
            g.drawLine(this.getPixelX(x1), this.getPixelY(y1), this.getPixelX(x2), this.getPixelY(y2));
            x1 = x + dxx + dyx;
            y1 = y + dxy + dyy;
            x2 = x - dxx + dyx;
            y2 = y - dxy + dyy;
            g.drawLine(this.getPixelX(x1), this.getPixelY(y1), this.getPixelX(x2), this.getPixelY(y2));
            x1 = x + dxx - dyx;
            y1 = y + dxy - dyy;
            x2 = x - dxx - dyx;
            y2 = y - dxy - dyy;
            g.drawLine(this.getPixelX(x1), this.getPixelY(y1), this.getPixelX(x2), this.getPixelY(y2));
            x1 = x - dxx + dyx;
            y1 = y - dxy + dyy;
            x2 = x - dxx - dyx;
            y2 = y - dxy - dyy;
            g.drawLine(this.getPixelX(x1), this.getPixelY(y1), this.getPixelX(x2), this.getPixelY(y2));
            x1 = x + dyx;
            y1 = y + dyy;
            x2 = x - dyx;
            y2 = y - dyy;
            g.drawLine(this.getPixelX(x1), this.getPixelY(y1), this.getPixelX(x2), this.getPixelY(y2));
        }

        public void drawBall(BallObject ball, Graphics g) {
            int x = (int)ball.getPos().x;
            int y = (int)ball.getPos().y;
            int r = 70 / (2 * this.mmPerPixel);
            if (ball.getConfidence() < 0.5) {
                System.out.println(ball.getConfidence());
                x = 0;
                y = this.h / 2 + 100;
            }
            g.setColor(Color.white);
            g.drawOval(this.getPixelX(x) - r, this.getPixelY(y) - r, 2 * r, 2 * r);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int ww = this.getPixelX(this.w) + this.padX;
            int wh = this.getPixelY(this.h) + this.padY;
            g.setColor(new Color(0.1f, 0.4f, 0.3f));
            g.fillRect(0, 0, ww, wh);
            g.setColor(Color.white);
            g.drawRect(this.getPixelX(-this.w / 2), this.getPixelY(-this.h / 2), this.getPixelX(this.w / 2) - this.getPixelX(-this.w / 2), this.getPixelY(this.h / 2) - this.getPixelY(-this.h / 2));
            g.drawLine(this.getPixelX(0), this.getPixelY(-this.h / 2), this.getPixelX(0), this.getPixelY(this.h / 2));
            int i = 1;
            while (i <= WorldModel.players) {
                this.drawPlayer(WorldModel.getPlayerObject(Team.WE, i), g);
                this.drawPlayer(WorldModel.getPlayerObject(Team.THEM, i), g);
                ++i;
            }
            this.drawBall(WorldModel.getBall(), g);
        }

        @Override
        public void run() {
            while (this.running) {
                this.repaint(10L, 0, 0, this.comW, this.comH);
                try {
                    Thread.sleep(30L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void stop() {
            this.running = false;
        }
    }
}

