/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent.behaviors;

import java.util.LinkedList;
import java.util.ListIterator;
import soccorob.ai.Debug;
import soccorob.ai.agent.Behavior;

public class SequenceBehavior
extends Behavior {
    private LinkedList parts;

    @Override
    public void init() {
        this.parts = new LinkedList();
    }

    @Override
    public void init(Object arg1) {
        Behavior[] args = (Behavior[])arg1;
        this.parts = new LinkedList();
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            this.appendPlan(args[i]);
            ++i;
        }
    }

    public void appendPlan(Behavior plan) {
        plan.usedAgain();
        this.parts.addLast(plan);
    }

    public void prependPlan(Behavior plan) {
        plan.usedAgain();
        this.parts.addFirst(plan);
    }

    public void clear() {
        ListIterator iter = this.parts.listIterator(0);
        while (iter.hasNext()) {
            ((Behavior)iter.next()).free();
        }
        this.parts.clear();
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    @Override
    public boolean exec() {
        if (this.isEmpty()) {
            return true;
        }
        if (((Behavior)this.parts.getFirst()).exec()) {
            Debug.Note("Finished part of plan");
            ((Behavior)this.parts.getFirst()).free();
            this.parts.removeFirst();
        }
        return this.isEmpty();
    }

    @Override
    public String toString() {
        String result = "";
        ListIterator iter = this.parts.listIterator(0);
        if (iter.hasNext()) {
            result = String.valueOf(result) + iter.next().toString();
        }
        while (iter.hasNext()) {
            result = String.valueOf(result) + ", " + iter.next().toString();
        }
        return "[" + result + "]";
    }

    @Override
    public void destructor() {
        this.clear();
    }
}

