/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import soccorob.ai.Debug;
import soccorob.ai.agent.Agent;
import soccorob.ai.agent.Planner;
import soccorob.ai.agent.planners.Planner1;
import soccorob.rt.AsyncEventHandler;
import soccorob.rt.RLThread;
import soccorob.rt.RunnableBlock;

public class PlannerControl
extends RLThread {
    private Planner realPlanner;
    private Agent agent;
    private DeadlineMissHandler deadlineMissHandler = new DeadlineMissHandler();

    public PlannerControl(Agent agent) {
        this.agent = agent;
        this.realPlanner = new Planner1(agent);
        this.runnableBlocks = new RunnableBlock[1];
        this.runnableBlocks[0] = new Part1();
    }

    public Planner getPlanner() {
        return this.realPlanner;
    }

    public void setPlanner(String plannername) {
        try {
            Class<?> plannerClass = Class.forName(plannername);
            Class<?> AgentClass = this.agent.getClass();
            Class[] args = new Class[]{AgentClass};
            Constructor<?> constr = plannerClass.getDeclaredConstructor(args);
            this.realPlanner = (Planner)constr.newInstance(this.agent);
        }
        catch (ClassNotFoundException ex) {
            Debug.Error("Could not load class " + plannername + " ; ");
        }
        catch (NoSuchMethodException ex) {
            Debug.Error("Class " + plannername + " has no AgentObject constructor");
        }
        catch (SecurityException ex) {
            Debug.Error("Access denied to class " + plannername);
        }
        catch (InstantiationException ex) {
            Debug.Error("InstantiationException for planner (could be abstract)");
        }
        catch (IllegalAccessException ex) {
            Debug.Error("IllegalAccessException instantiating planner");
        }
        catch (InvocationTargetException ex) {
            Debug.Error("InvocationTargetException instantiating planner");
        }
    }

    @Override
    public AsyncEventHandler getDeadlineMissHandler() {
        return this.deadlineMissHandler;
    }

    public void restart() {
        this.realPlanner.restart();
    }

    public String getInfo() {
        return this.realPlanner.getInfo();
    }

    class DeadlineMissHandler
    extends AsyncEventHandler {
        DeadlineMissHandler() {
        }

        @Override
        public void handleAsyncEvent() {
            PlannerControl.this.realPlanner.restart();
            PlannerControl.this.waitForNextPeriod();
        }
    }

    class Part1
    implements RunnableBlock {
        Part1() {
        }

        @Override
        public void run() {
            PlannerControl.this.realPlanner.run();
            if (PlannerControl.this.realPlanner.isFinished()) {
                PlannerControl.this.waitForNextPeriod();
            }
        }
    }
}

