/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent;

import soccorob.ai.Debug;
import soccorob.ai.agent.Agent;
import soccorob.ai.agent.BehaviorClass;
import soccorob.ai.wm.PlayerObject;

public abstract class Behavior {
    private int refcount = 0;
    protected Agent agent;
    public BehaviorClass classHandler;
    public Behavior prevObject;
    public Behavior prevInStack;

    public abstract boolean exec();

    final void setAgent(Agent agent) {
        this.agent = agent;
    }

    public final void free() {
        if (this.refcount > 0) {
            --this.refcount;
        } else {
            Debug.Error("Frivolous Behavior.free() call!");
        }
        if (this.refcount == 0) {
            this.destructor();
            this.classHandler.deallocate(this);
        }
    }

    public void destructor() {
    }

    public final void usedAgain() {
        ++this.refcount;
    }

    public void init() {
        Debug.Error("Tried to init " + this.classHandler.getClassName() + " without parameters");
    }

    public void init(Object arg1) {
        Debug.Error("Tried to init " + this.classHandler.getClassName() + " with one parameter");
    }

    public void init(Object arg1, Object arg2) {
        Debug.Error("Tried to init " + this.classHandler.getClassName() + " with two parameters");
    }

    public void init(Object arg1, Object arg2, Object arg3) {
        Debug.Error("Tried to init " + this.classHandler.getClassName() + " with three parameters");
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4) {
        Debug.Error("Tried to init " + this.classHandler.getClassName() + " with four parameters");
    }

    public abstract String toString();

    public void power(int left, int right) {
        this.agent.getActuator().power(this.agent.no, left, right);
    }

    public void power(float left, float right) {
        this.agent.getActuator().power(this.agent.no, (int)left, (int)right);
    }

    public final float getValue(String param) {
        return this.agent.spec.getValue(param);
    }

    public PlayerObject body() {
        return this.agent.body();
    }
}

