/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent;

import soccorob.ai.Team;
import soccorob.ai.agent.Behavior;
import soccorob.ai.agent.BehaviorClass;
import soccorob.ai.agent.PlannerControl;
import soccorob.ai.agent.Reactor;
import soccorob.ai.agent.RobotSpec;
import soccorob.ai.wm.PlayerObject;
import soccorob.ai.wm.WorldModel;
import soccorob.comm.ActuatorInterface;

public class Agent {
    private static BehaviorClass NullBehavior = BehaviorClass.load("soccorob.ai.agent.behaviors.NullBehavior");
    private Behavior plan = NullBehavior.New();
    private PlannerControl planner = new PlannerControl(this);
    ActuatorInterface actuator;
    private Reactor reactor = new Reactor(this);
    public int no;
    public RobotSpec spec;
    public boolean goalKeeper;
    public boolean updatePlanOn;
    private static boolean time_is_ripe_to_conquer_world = false;

    public Agent(int nr, ActuatorInterface actuator) {
        this.actuator = actuator;
        this.no = nr;
        this.goalKeeper = false;
        this.updatePlanOn = true;
    }

    public Behavior getPlan() {
        return this.plan;
    }

    public void setPlan(Behavior newplan) {
        this.plan.free();
        this.plan = newplan;
    }

    public void setPlan(String name) {
        this.plan.free();
        this.plan = this.reactor.createPlan(name);
    }

    public void setPlan(String name, Object arg1) {
        this.plan.free();
        this.plan = this.reactor.createPlan(name, arg1);
    }

    public void setPlan(String name, Object arg1, Object arg2) {
        this.plan.free();
        this.plan = this.reactor.createPlan(name, arg1, arg2);
    }

    public void setPlan(String name, Object arg1, Object arg2, Object arg3) {
        this.plan.free();
        this.plan = this.reactor.createPlan(name, arg1, arg2, arg3);
    }

    public void setPlan(String name, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.plan.free();
        this.plan = this.reactor.createPlan(name, arg1, arg2, arg3, arg4);
    }

    public void setSpec(String filename) {
        this.spec = new RobotSpec(filename);
    }

    public void setPlanner(String plannername) {
        this.planner.setPlanner(plannername);
    }

    public Reactor getReactor() {
        return this.reactor;
    }

    public PlannerControl getPlanner() {
        return this.planner;
    }

    public ActuatorInterface getActuator() {
        return this.actuator;
    }

    public PlayerObject body() {
        return WorldModel.getPlayerObject(Team.WE, this.no);
    }

    public String toString() {
        return String.valueOf(this.body().toString()) + "Planner: " + this.planner.getInfo() + "\nPlan:" + this.plan.toString();
    }

    public boolean isClosestToBall() {
        PlayerObject closest = WorldModel.getClosestTeammate(WorldModel.getBall().getPos());
        return closest.no == this.no;
    }
}

