/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai;

import soccorob.ai.Point;

public class Vector {
    private long length;
    private float angle_degrees;
    private static final Point origoPoint = new Point(0L, 0L);
    private static Point tempPoint = new Point();
    private static Vector tempVector = new Vector();

    public Vector() {
        this.length = 0L;
        this.angle_degrees = 0.0f;
    }

    public Vector(long dist, float ang) {
        this.length = dist;
        this.angle_degrees = ang;
    }

    public Vector(Vector vector) {
        this.length = vector.length;
        this.angle_degrees = vector.angle_degrees;
    }

    public void set(Vector vector) {
        this.length = vector.length;
        this.angle_degrees = vector.angle_degrees;
    }

    public void set(long dist, float ang) {
        this.setLength(dist);
        this.setAngle(ang);
    }

    public long getLength() {
        return this.length;
    }

    public float getAngle() {
        return this.angle_degrees;
    }

    public float getAngleDiff(Vector vector) {
        float angleDiff = vector.getAngle() - this.angle_degrees;
        if (angleDiff > 180.0f) {
            angleDiff -= 360.0f;
        }
        if (angleDiff <= -180.0f) {
            angleDiff += 360.0f;
        }
        return angleDiff;
    }

    public double getRadAngle() {
        return Math.toRadians(this.angle_degrees);
    }

    public void setLength(long dist) {
        if (dist >= 0L) {
            this.length = dist;
        }
    }

    public void setAngle(float angle) {
        if (angle > 180.0f) {
            this.setAngle(angle - 360.0f);
        } else if (angle <= -180.0f) {
            this.setAngle(angle + 360.0f);
        } else {
            this.angle_degrees = angle;
        }
    }

    public void rotate(float angle) {
        this.setAngle(this.angle_degrees + angle);
    }

    public void add(Vector vector) {
        tempPoint.set(0L, 0L);
        tempPoint.moveAlong(this);
        tempPoint.moveAlong(vector);
        origoPoint.vectorTo(tempPoint, this);
    }

    public void negate() {
        this.angle_degrees = 180.0f - this.angle_degrees;
    }

    public void subtract(Vector sub) {
        tempPoint.set(0L, 0L);
        tempVector.set(sub);
        tempVector.negate();
        tempPoint.moveAlong(this);
        tempPoint.moveAlong(tempVector);
        origoPoint.vectorTo(tempPoint, this);
    }

    public String toString() {
        return "(" + Long.toString(this.getLength()) + ";" + Float.toString(this.getAngle()) + ")";
    }

    public void scale(float factor) {
        this.length = (long)((float)this.length * factor);
    }

    public void getScaled(float factor, Vector result) {
        result.set(this);
        result.scale(factor);
    }
}

