/*
 * Decompiled with CFR 0.152.
 */
package soccorob;

import soccorob.ai.Eval;
import soccorob.ai.Interpreter;
import soccorob.ai.agent.Agent;
import soccorob.ai.ui.Gui;
import soccorob.ai.ui.VisionGui;
import soccorob.ai.wm.WorldModel;
import soccorob.comm.ActuatorInterface;
import soccorob.comm.SimActuator;
import soccorob.rt.DefaultScheduler;
import soccorob.rt.PeriodicParameters;
import soccorob.rt.RLThread;
import soccorob.rt.Scheduler;
import soccorob.rt.time.AbsoluteTime;
import soccorob.rt.time.RelativeTime;
import soccorob.si.ip.ImageProcessing;

public class SoccoRob {
    private static int NO_PLAYERS = WorldModel.players;
    private static Agent[] agentList = new Agent[NO_PLAYERS];
    private static int AGENT1 = 0;
    private static int AGENT2 = 1;
    private static int AGENT3 = 2;
    private static int NO_THREADS = 8;
    private static int IP = 0;
    private static int P1 = 1;
    private static int P2 = 2;
    private static int P3 = 3;
    private static int R1 = 4;
    private static int R2 = 5;
    private static int R3 = 6;
    private static int ACT = 7;
    private static int IP_ID = IP + 1;
    private static int P1_ID = P1 + 1;
    private static int P2_ID = P2 + 1;
    private static int P3_ID = P3 + 1;
    private static int R1_ID = R1 + 1;
    private static int R2_ID = R2 + 1;
    private static int R3_ID = R3 + 1;
    private static int ACT_ID = ACT + 1;
    private static RLThread[] threadList = new RLThread[NO_THREADS];

    public static Agent getAgent(int nr) {
        return agentList[nr - 1];
    }

    public static RLThread[] getThreads() {
        return threadList;
    }

    public static void main(String[] argv) {
        boolean guiFlag = false;
        boolean monitorFlag = false;
        boolean consoleFlag = false;
        String initFileName = "c:\\RoboLab\\settings\\init2.txt";
        boolean simFlag = false;
        boolean defaultScheduler = true;
        String schedulerClassName = null;
        boolean opponent = false;
        String teamName = "TeamStudent";
        String serverHost = "127.0.0.1";
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-init") || argv[i].equals("-in")) {
                initFileName = argv[i + 1];
                ++i;
            } else if (argv[i].equals("-gui") || argv[i].equals("-gu")) {
                System.out.println("Enabling GUI for robots: ");
                guiFlag = true;
            } else if (argv[i].equals("-monitor") || argv[i].equals("-mo")) {
                System.out.println("Enabling world model monitor.");
                monitorFlag = true;
            } else if (argv[i].equals("-console") || argv[i].equals("-co")) {
                System.out.println("Enabling Console...");
                consoleFlag = true;
            } else if (argv[i].equals("-simulator") || argv[i].equals("-si")) {
                System.out.println("Enabling Simulator...");
                simFlag = true;
            } else if (argv[i].equals("-scheduler") || argv[i].equals("-sc")) {
                schedulerClassName = argv[i + 1];
                ++i;
                defaultScheduler = false;
            } else if (argv[i].equals("-serverhost") || argv[i].equals("-se")) {
                serverHost = argv[i + 1];
                ++i;
            } else if (argv[i].equals("-teamname") || argv[i].equals("-te")) {
                teamName = argv[i + 1];
                ++i;
            } else if (argv[i].equals("-usage") || argv[i].equals("-us") || argv[i].equals("-?")) {
                System.out.println("Options:");
                System.out.println("      -init [initfile]        Load init file.");
                System.out.println("      -gui                    Enable gui for robots.");
                System.out.println("      -monitor                Enable world model monitor.");
                System.out.println("      -console                Enable console window.");
                System.out.println("      -simulator              Use the simulator.");
                System.out.println("      -scheduler  [class]     Load and use the specified scheduler.");
                System.out.println("      -serverhost [ip]        Host of the soccer server.");
                System.out.println("      -teamname   [teamname]  The name of this team.");
                System.exit(0);
            } else {
                System.out.println("Unknown option.");
                System.exit(0);
            }
            ++i;
        }
        if (simFlag) {
            SoccoRob.threadList[SoccoRob.ACT] = new SimActuator(opponent, serverHost, teamName);
        }
        SoccoRob.threadList[SoccoRob.IP] = new ImageProcessing(simFlag, (ActuatorInterface)((Object)threadList[ACT]), opponent, serverHost, teamName);
        i = 0;
        while (i < NO_PLAYERS) {
            SoccoRob.agentList[i] = new Agent(i + 1, (ActuatorInterface)((Object)threadList[ACT]));
            ++i;
        }
        System.out.println("\nLoading init file : " + initFileName + " ... " + Eval.evalFile(initFileName));
        SoccoRob.threadList[SoccoRob.P1] = agentList[AGENT1].getPlanner();
        SoccoRob.threadList[SoccoRob.P2] = agentList[AGENT2].getPlanner();
        SoccoRob.threadList[SoccoRob.P3] = agentList[AGENT3].getPlanner();
        SoccoRob.threadList[SoccoRob.R1] = agentList[AGENT1].getReactor();
        SoccoRob.threadList[SoccoRob.R2] = agentList[AGENT2].getReactor();
        SoccoRob.threadList[SoccoRob.R3] = agentList[AGENT3].getReactor();
        if (monitorFlag) {
            VisionGui visionGui = new VisionGui(agentList[AGENT1]);
            visionGui.show();
        }
        if (guiFlag) {
            Gui gui = new Gui(agentList[AGENT1]);
            gui.show();
            Gui gui2 = new Gui(agentList[AGENT2]);
            gui2.show();
            Gui gui3 = new Gui(agentList[AGENT3]);
            gui3.show();
        } else if (!consoleFlag) {
            System.out.println("\nStarting the game without GUI.");
            Interpreter.startGame();
            agentList[AGENT1].setPlan("default");
            agentList[AGENT2].setPlan("default");
            agentList[AGENT3].setPlan("default");
        }
        threadList[IP].setParameters("Image Processing", IP_ID, new int[0], null, new PeriodicParameters(new AbsoluteTime(0, 0, 0), new RelativeTime(0, 0, 50000), new RelativeTime(0, 0, 100000), new RelativeTime(0, 0, 50000), null, threadList[IP].getDeadlineMissHandler()));
        i = 0;
        while (i < WorldModel.players) {
            threadList[P1 + i].setParameters("Agent" + (i + 1) + " Planner", P1_ID + i, new int[]{IP_ID + i}, null, new PeriodicParameters(new AbsoluteTime(0, 0, 0), new RelativeTime(0, 0, 1000000), new RelativeTime(0, 0, 12000), new RelativeTime(0, 0, 1000000), null, threadList[P1 + i].getDeadlineMissHandler()));
            threadList[R1 + i].setParameters("Agent" + (i + 1) + "  Reactor", R1_ID + i, new int[]{IP_ID + i}, null, new PeriodicParameters(new AbsoluteTime(0, 0, 0), new RelativeTime(0, 0, 50000), new RelativeTime(0, 0, 1000), new RelativeTime(0, 0, 50000), null, threadList[R1 + i].getDeadlineMissHandler()));
            ++i;
        }
        threadList[ACT].setParameters("Actuator", ACT_ID, new int[]{R1}, null, new PeriodicParameters(new AbsoluteTime(0, 0, 0), new RelativeTime(0, 0, 50000), new RelativeTime(0, 0, 3500), new RelativeTime(0, 0, 50000), null, threadList[ACT].getDeadlineMissHandler()));
        Scheduler scheduler = null;
        if (defaultScheduler) {
            scheduler = new DefaultScheduler();
        } else {
            try {
                Class<?> schedulerClass = Class.forName(schedulerClassName);
                scheduler = (Scheduler)schedulerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                System.out.println("Can not load class " + schedulerClassName + "\n" + e.toString());
                System.exit(0);
            }
            catch (IllegalAccessException e) {
                System.out.println("Could not access class " + schedulerClassName + "\n" + e.toString());
                System.exit(0);
            }
            catch (InstantiationException e) {
                System.out.println("Could not instantiate class " + schedulerClassName + "\n" + e.toString());
                System.exit(0);
            }
        }
        ((Scheduler)scheduler).start();
    }
}

