/*
 * Decompiled with CFR 0.152.
 */
package playerP;

import genericP.Generic;
import genericP.NSobject;
import info_managerP.InfoManager;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import stokenizerP.STokenizer;

public class Player {
    String teamname;
    int uniformNum;
    String servName;
    boolean goalie;
    String side;
    float version;
    String commands;
    int port;
    InetAddress servAddress;
    DatagramSocket dgsock;
    public InfoManager infoManager;
    static int lastCycleTime1 = 0;
    static int lastCycleTime2 = 0;
    static double lastAvoidTime1 = 0.0;
    static double lastAvoidTime2 = 0.0;
    double dashPowerRate = 1.0;
    double kickPowerRate = 1.0;

    public Player(String tname, String sname, int p, float ver, boolean g) {
        this.goalie = g;
        this.version = ver;
        this.init(tname, sname, p);
        this.connect(ver);
        this.infoManager = new InfoManager(this.teamname, this.uniformNum, this.side);
    }

    public Player(String tname, int unum, String sname, int p) {
        this.uniformNum = unum;
        this.init(tname, sname, p);
        this.reconnect();
        this.infoManager = new InfoManager(this.teamname, this.uniformNum, this.side);
    }

    void init(String tname, String sname, int p) {
        this.teamname = tname;
        this.servName = sname;
        this.port = p;
        try {
            this.servAddress = InetAddress.getByName(this.servName);
            this.dgsock = new DatagramSocket();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    void connect(float ver) {
        StringBuffer strCommands;
        if (this.goalie) {
            strCommands = new StringBuffer("(init ");
            strCommands.append(this.teamname).append(" (version ").append(ver).append(") (goalie))");
        } else {
            strCommands = new StringBuffer("(init ");
            strCommands.append(this.teamname).append(" (version ").append(ver).append("))");
        }
        this.commands = strCommands.toString();
        this.sendCommand();
        this.receiveInit();
    }

    void reconnect() {
        StringBuffer strCommands = new StringBuffer("(reconnect ");
        strCommands.append(this.teamname).append(" ").append(this.uniformNum).append(")");
        this.commands = strCommands.toString();
        this.sendCommand();
        this.receiveInit();
    }

    void receiveInit() {
        byte[] buff = new byte[4096];
        DatagramPacket dgpackR = new DatagramPacket(buff, 4096, this.servAddress, this.port);
        try {
            this.dgsock.receive(dgpackR);
            this.port = dgpackR.getPort();
            this.servAddress = dgpackR.getAddress();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        String recvMassage = new String(dgpackR.getData());
        STokenizer tokenizer = new STokenizer(recvMassage);
        String token = tokenizer.nextSToken();
        if (!token.equals("init") && !token.equals("reconnect")) {
            System.out.println("Error : init failed.");
            System.exit(1);
        }
        this.side = tokenizer.nextSToken();
        this.uniformNum = Integer.valueOf(tokenizer.nextSToken());
        token = tokenizer.nextSToken();
    }

    public void sendCommand() {
        byte[] sendBuff = this.commands.getBytes();
        DatagramPacket dgpackS = new DatagramPacket(sendBuff, sendBuff.length, this.servAddress, this.port);
        try {
            this.dgsock.send(dgpackS);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        this.commands = "";
    }

    public String receiveMessage() {
        byte[] recvBuff = new byte[4096];
        DatagramPacket dgpackR = new DatagramPacket(recvBuff, 4096, this.servAddress, this.port);
        try {
            this.dgsock.receive(dgpackR);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        String recvMassage = new String(dgpackR.getData());
        return recvMassage;
    }

    public void move(double x, double y) {
        StringBuffer str = new StringBuffer("(move ");
        str.append(x).append(" ").append(y).append(")");
        this.commands = this.commands.concat(str.toString());
        this.infoManager.updateByMove(x, y);
    }

    public void dash(double power) {
        double inputPower = this.dashPowerRate * power;
        StringBuffer str = new StringBuffer("(dash ");
        str.append(Double.toString(inputPower)).append(")");
        this.commands = this.commands.concat(str.toString());
        this.infoManager.updateByDash(power);
    }

    public void turn(double moment) {
        StringBuffer str = new StringBuffer("(turn ");
        str.append(moment).append(")");
        this.commands = this.commands.concat(str.toString());
        this.infoManager.updateByTurn(moment);
    }

    public void turn2(double absDir) {
        double moment = this.infoManager.getMoment(absDir);
        StringBuffer str = new StringBuffer("(turn ");
        str.append(moment).append(")");
        this.commands = this.commands.concat(str.toString());
        this.infoManager.updateByTurn(moment);
    }

    public void kickBall(double power, double direction) {
        double inputKickPower = power * this.kickPowerRate;
        StringBuffer str = new StringBuffer("(kick ");
        str.append(Double.toString(inputKickPower));
        str.append(" ").append(Double.toString(direction)).append(")");
        this.commands = this.commands.concat(str.toString());
        this.infoManager.updateByKick(power, direction);
    }

    public void catchBall(double direction) {
        StringBuffer str = new StringBuffer("(catch ");
        str.append(direction).append(")");
        this.commands = this.commands.concat(str.toString());
    }

    public void turnNeck(double angle) {
        StringBuffer str = new StringBuffer("(turn_neck ");
        str.append(angle).append(")");
        this.commands = this.commands.concat(str.toString());
        this.infoManager.updateByTurnNeck(angle);
    }

    public void turnNeck2(double angle) {
        angle = Generic.normDir(angle - this.infoManager.getHeadAngle());
        StringBuffer str = new StringBuffer("(turn_neck ");
        str.append(angle).append(")");
        this.commands = this.commands.concat(str.toString());
        this.infoManager.updateByTurnNeck(angle);
    }

    public void say(String message) {
        StringBuffer str = new StringBuffer("(say ");
        str.append(this.teamname).append(" ").append(message).append(")");
        this.commands = this.commands.concat(str.toString());
    }

    public void changeView(String angleWidth, String quality) {
        StringBuffer str = new StringBuffer("(change_view ");
        str.append(angleWidth).append(" ").append(quality).append(")");
        this.commands = this.commands.concat(str.toString());
    }

    public void bye() {
        this.commands = this.commands.concat("(bye)");
        System.exit(0);
    }

    public void dribble(double power, double angle) {
        double bodyFaceDir = this.infoManager.getBodyFaceDir();
        double x = this.infoManager.getX();
        double y = this.infoManager.getY();
        double vx = this.infoManager.getVX();
        double vy = this.infoManager.getVY();
        double keepDist = 0.65;
        double stamina = this.infoManager.getStamina();
        if (power > stamina) {
            power = stamina;
        }
        if (lastCycleTime1 == this.infoManager.getBodyTime() - 1) {
            this.dash(power);
        } else {
            lastCycleTime1 = this.infoManager.getBodyTime();
            double predX = x + vx + (vx * 0.4 + power * 0.006 * Math.cos(Generic.digToRad(bodyFaceDir)));
            double predY = y + vy + (vy * 0.4 + power * 0.006 * Math.sin(Generic.digToRad(bodyFaceDir)));
            double destX = predX + keepDist * Math.cos(Generic.digToRad(Generic.normDir(angle + bodyFaceDir)));
            double destY = predY + keepDist * Math.sin(Generic.digToRad(Generic.normDir(angle + bodyFaceDir)));
            double mx = destX - this.infoManager.getBallX();
            double my = destY - this.infoManager.getBallY();
            double ax = (mx - 1.94 * this.infoManager.getBallVX()) / 1.94;
            double ay = (my - 1.94 * this.infoManager.getBallVY()) / 1.94;
            NSobject kickPowerNS = new NSobject();
            NSobject kickDirNS = new NSobject();
            this.infoManager.getKickArgByAccel(ax, ay, kickPowerNS, kickDirNS);
            this.kickBall(kickPowerNS.getNS(), kickDirNS.getNS());
        }
    }

    public void powerShot(double X, double Y, double speed) {
        int currentTime = this.infoManager.getBodyTime();
        NSobject powerNS = new NSobject();
        NSobject dirNS = new NSobject();
        if (lastCycleTime2 == currentTime - 1) {
            this.infoManager.getKickArgByDest(X, Y, speed, powerNS, dirNS);
            this.kickBall(powerNS.getNS(), dirNS.getNS());
        } else {
            this.infoManager.getKickArgForPowerShot(X, Y, powerNS, dirNS, false);
            this.kickBall(powerNS.getNS(), dirNS.getNS());
            lastCycleTime2 = currentTime;
        }
    }

    public void shot(double X, double Y, double speed) {
        NSobject powerNS = new NSobject();
        NSobject dirNS = new NSobject();
        this.infoManager.getKickArgByDest(X, Y, speed, powerNS, dirNS);
        this.kickBall(powerNS.getNS(), dirNS.getNS());
    }

    public void goToThePos(double X, double Y, double power) {
        boolean avoidFlag = false;
        double dirMargin = 5.0;
        if (this.infoManager.onThePos(X, Y)) {
            return;
        }
        if (lastAvoidTime1 == (double)(this.infoManager.getBodyTime() - 1)) {
            this.dash(power);
            return;
        }
        NSobject dirNS = new NSobject(this.infoManager.getDirOfThePos(X, Y));
        avoidFlag = this.infoManager.adjustDirToAvoidPlayer(this.infoManager.getDistOfThePos(X, Y), dirNS);
        avoidFlag = this.infoManager.adjustDirToAvoidBall(this.infoManager.getDistOfThePos(X, Y), dirNS);
        if (avoidFlag) {
            lastAvoidTime1 = this.infoManager.getBodyTime();
        }
        if (Math.abs(dirNS.getNS()) > dirMargin) {
            this.turn(this.infoManager.getMoment(dirNS.getNS()));
        } else {
            this.dash(power);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void chaseBall(double power) {
        avoidFlag = false;
        t = 0;
        kickPowerNS = new NSobject();
        kickDirNS = new NSobject();
        if (Player.lastAvoidTime2 != (double)(this.infoManager.getBodyTime() - 1)) ** GOTO lbl10
        this.dash(power);
        return;
        while (!(this.infoManager.getMovableDist(t, power, this.infoManager.getBallDir()) > this.infoManager.getPredBallDist(t))) {
            ++t;
lbl10:
            // 2 sources

            if (t < 100) continue;
        }
        X = this.infoManager.getPredBallX(t);
        Y = this.infoManager.getPredBallY(t);
        predBallDir = this.infoManager.getDirOfThePos(X, Y);
        dirNS = new NSobject(predBallDir);
        avoidFlag = this.infoManager.adjustDirToAvoidPlayer(X, Y, this.infoManager.getPredBallDist(t), dirNS);
        dirMargin = this.infoManager.getPredBallDist(t) / 4.0 + 20.0;
        if (avoidFlag) {
            if (Math.abs(dirNS.getNS()) <= dirMargin) {
                this.dash(power);
            } else {
                Player.lastAvoidTime2 = this.infoManager.getBodyTime();
                this.turn(this.infoManager.getMoment(dirNS.getNS()));
            }
        } else if (Math.abs(predBallDir) <= dirMargin) {
            this.dash(power);
        } else {
            this.turn(this.infoManager.getMoment(predBallDir));
        }
    }

    public void turnBall(double angle) {
        NSobject powerNS = new NSobject();
        NSobject dirNS = new NSobject();
        double keepDist = 0.65;
        this.infoManager.getKickArgByKeepDir(angle, keepDist, powerNS, dirNS);
        this.kickBall(powerNS.getNS(), dirNS.getNS());
    }

    public void trapBall() {
        NSobject powerNS = new NSobject();
        NSobject dirNS = new NSobject();
        this.infoManager.getKickArgByMoveDist(0.0, 0.0, powerNS, dirNS);
        this.kickBall(powerNS.getNS(), dirNS.getNS());
    }

    public void lookAtBall() {
        this.turnNeck2(this.infoManager.getPredBallDir(1));
    }

    public void lookForward() {
        this.turnNeck(-1.0 * this.infoManager.getHeadAngle());
    }

    public int getUniformNum() {
        return this.uniformNum;
    }

    public String getTeamname() {
        return this.teamname;
    }

    String getSide() {
        return this.side;
    }

    public void updateSeeInfo(String si) {
        this.infoManager.parseSeeInfo(si);
        this.infoManager.updateSeeInfo();
    }

    public void updateBodyInfo(String bi) {
        this.infoManager.parseBodyInfo(bi);
        this.infoManager.updateBodyInfo();
    }

    public void updateHearInfo(String hi) {
        this.infoManager.parseHearInfo(hi);
        this.infoManager.updateHearInfo();
    }

    public void updateEtc() {
        this.infoManager.updateEtc();
    }

    public void goaliegoToThePos(double dist_x, double dist_y) {
        double dirXY = this.infoManager.getDirOfThePos2(dist_x, dist_y);
        if (Math.abs(dist_x - this.infoManager.getX()) > 1.0) {
            if (dist_x < this.infoManager.getX()) {
                dirXY = dirXY > 0.0 ? (dirXY -= 180.0) : (dirXY += 180.0);
                if (Math.abs(dirXY - this.infoManager.getBodyFaceDir()) < 10.0) {
                    this.dash(-50.0);
                    this.lookAtBall();
                } else {
                    this.turn2(Generic.normDir(dirXY - this.infoManager.getBodyFaceDir()));
                    this.lookAtBall();
                }
            } else if (Math.abs(dirXY - this.infoManager.getBodyFaceDir()) < 10.0) {
                this.dash(100.0);
                this.lookAtBall();
            } else {
                this.turn2(Generic.normDir(dirXY - this.infoManager.getBodyFaceDir()));
                this.lookAtBall();
            }
        } else if (Math.abs(dist_x - this.infoManager.getX()) < 1.0) {
            if (dist_y > this.infoManager.getY()) {
                if (Math.abs(this.infoManager.getBodyFaceDir() - 90.0) > 10.0) {
                    this.turn2(Generic.normDir(90.0 - this.infoManager.getBodyFaceDir()));
                    this.lookAtBall();
                } else {
                    this.dash(100.0);
                }
            } else if (Math.abs(this.infoManager.getBodyFaceDir() + 90.0) > 10.0) {
                this.turn2(Generic.normDir(-90.0 - this.infoManager.getBodyFaceDir()));
                this.lookAtBall();
            } else {
                this.dash(100.0);
            }
        }
    }

    public void setDashPowerRate(double val) {
        if (val > 1.0 || val <= 0.0) {
            return;
        }
        this.dashPowerRate = val;
    }

    public void setKickPowerRate(double val) {
        if (val > 1.0 || val <= 0.0) {
            return;
        }
        this.kickPowerRate = val;
    }
}

