/*
 * Decompiled with CFR 0.152.
 */
package parserP;

import parserP.PlaymodeTable;
import stokenizerP.STokenizer;

public class HearInfoParser
implements PlaymodeTable {
    final int FROM_UNKNOWN = 0;
    final int FROM_REFEREE = 1;
    final int FROM_TEAMMATE = 2;
    final int FROM_COACH = 3;
    String hearInfo;
    String side;
    String teamname;
    String message;
    int time;
    int playmode;
    int from;
    int ourPoint = 0;
    int opponentsPoint = 0;

    public HearInfoParser() {
    }

    public HearInfoParser(String hi, String s, String tname) {
        this.setInfo(hi);
        this.setSide(s);
        this.setTeamname(tname);
        this.parseInfo();
    }

    public void setInfo(String hi) {
        this.hearInfo = hi;
    }

    public void setSide(String si) {
        this.side = si;
    }

    public void setTeamname(String tname) {
        this.teamname = tname;
    }

    public void parseInfo() {
        STokenizer tokenizer = new STokenizer(this.hearInfo);
        String token = tokenizer.nextSToken();
        token = tokenizer.nextSToken();
        this.time = Integer.valueOf(token);
        token = tokenizer.nextSToken();
        if (token.equals("referee")) {
            this.from = 1;
            token = tokenizer.nextSToken();
            if (token.startsWith("before_kick_off")) {
                this.playmode = 0;
            } else if (token.startsWith("kick_off_")) {
                this.playmode = token.endsWith(this.side) ? 1 : 2;
            } else if (token.startsWith("kick_in_")) {
                this.playmode = token.endsWith(this.side) ? 3 : 4;
            } else if (token.startsWith("corner_kick_")) {
                this.playmode = token.endsWith(this.side) ? 5 : 6;
            } else if (token.startsWith("goal_kick_")) {
                this.playmode = token.endsWith(this.side) ? 7 : 8;
            } else if (token.startsWith("free_kick_")) {
                this.playmode = token.endsWith(this.side) ? 9 : 10;
            } else if (token.startsWith("offside_")) {
                this.playmode = token.endsWith(this.side) ? 11 : 12;
            } else if (token.startsWith("play_on")) {
                this.playmode = 13;
            } else if (token.startsWith("half_time")) {
                this.playmode = 14;
            } else if (token.startsWith("time_up")) {
                this.playmode = 15;
            } else if (token.startsWith("time_extended")) {
                this.playmode = 16;
            } else if (token.startsWith("foul_")) {
                this.playmode = token.endsWith(this.side) ? 17 : 18;
            } else if (token.startsWith("goal_")) {
                if (token.substring(5, 6).equals(this.side)) {
                    this.playmode = 19;
                    this.ourPoint = Integer.valueOf(token.substring(7, 8));
                } else {
                    this.playmode = 20;
                    this.opponentsPoint = Integer.valueOf(token.substring(7, 8));
                }
            }
        } else if (!token.equals("self")) {
            if (token.startsWith("online_coach_")) {
                if (token.startsWith(this.side, 13)) {
                    this.from = 3;
                    this.message = tokenizer.nextSToken();
                }
            } else {
                token = tokenizer.nextSToken();
                if (token.equals(this.teamname)) {
                    this.from = 2;
                    this.message = tokenizer.nextSToken();
                }
            }
        }
    }

    public int getTime() {
        return this.time;
    }

    public int getPlaymode() {
        return this.playmode;
    }

    public boolean fromCoach() {
        return this.from == 3;
    }

    public boolean fromReferee() {
        return this.from == 1;
    }

    public boolean fromTeammate() {
        return this.from == 2;
    }

    public String getMessage() {
        return this.message;
    }

    public int getOurPoint() {
        return this.ourPoint;
    }

    public int getOpponentsPoint() {
        return this.opponentsPoint;
    }
}

