/*
 * Decompiled with CFR 0.152.
 */
package objectP;

import genericP.Generic;
import java.awt.geom.Point2D;

public class ObjectInfo {
    final int UNKNOWN = -1;
    final double min_conf = 0.5;
    double conf_decay = 0.9;
    int controlTime;
    int seenTime;
    double dist;
    double dir;
    double distChange;
    double dirChange;
    boolean change;
    Point2D pos;
    Point2D vel;
    double relVV;
    double relVH;
    double relVX;
    double relVY;
    Point2D acc;
    Point2D velCorrect;
    double randp;
    double decay;
    double certainty;

    public ObjectInfo(double distance, double direction) {
        this.dist = distance;
        this.dir = direction;
        this.change = false;
        this.pos = new Point2D.Double();
        this.vel = new Point2D.Double();
        this.acc = new Point2D.Double();
        this.velCorrect = new Point2D.Double();
        this.certainty = 1.0;
    }

    public ObjectInfo(double distance, double direction, double distanceChange, double directionChange) {
        this.dist = distance;
        this.dir = direction;
        this.distChange = distanceChange;
        this.dirChange = directionChange;
        this.change = true;
        this.pos = new Point2D.Double();
        this.vel = new Point2D.Double();
        this.acc = new Point2D.Double();
        this.velCorrect = new Point2D.Double();
        this.acc.setLocation(0.0, 0.0);
        this.certainty = 1.0;
    }

    public void calcPos(double playerX, double playerY, double faceDir) {
        double x = this.dist * Math.cos(Generic.digToRad(faceDir + this.dir)) + playerX;
        double y = this.dist * Math.sin(Generic.digToRad(faceDir + this.dir)) + playerY;
        this.pos.setLocation(x, y);
    }

    public double getRelX(double faceDir) {
        return this.dist * Math.cos(Generic.digToRad(faceDir + this.dir));
    }

    public double getRelY(double faceDir) {
        return this.dist * Math.sin(Generic.digToRad(faceDir + this.dir));
    }

    public void calcRelVVH() {
        double sinDir = Math.sin(Generic.digToRad(this.dir));
        double cosDir = Math.cos(Generic.digToRad(this.dir));
        this.relVV = this.distChange * cosDir + Math.PI / 180 * this.dirChange * this.dist * sinDir;
        this.relVH = this.distChange * sinDir + Math.PI / 180 * this.dirChange * this.dist * cosDir;
    }

    public void calcRelVXY(double faceDir) {
        double sinDir = Math.sin(Generic.digToRad(faceDir));
        double cosDir = Math.cos(Generic.digToRad(faceDir));
        this.relVX = this.relVV * cosDir - this.relVH * sinDir;
        this.relVY = this.relVV * sinDir + this.relVH * cosDir;
    }

    public void calcV(double playerVX, double playerVY) {
        this.vel.setLocation(this.relVX + playerVX, this.relVY + playerVY);
    }

    public void setTime(int t) {
        this.seenTime = t;
    }

    public void setControlTime(int t) {
        this.controlTime = t;
    }

    public void setPos(double X, double Y) {
        this.pos.setLocation(X, Y);
    }

    public void setX(double X) {
        this.pos.setLocation(X, this.pos.getY());
    }

    public void setY(double Y) {
        this.pos.setLocation(this.pos.getX(), Y);
    }

    public void setVX(double VX) {
        this.vel.setLocation(VX, this.vel.getY());
    }

    public void setVY(double VY) {
        this.vel.setLocation(this.vel.getX(), VY);
    }

    public void setV(double VX, double VY) {
        this.vel.setLocation(VX, VY);
    }

    public void setAX(double AX) {
        this.acc.setLocation(AX, this.acc.getY());
    }

    public void setAY(double AY) {
        this.acc.setLocation(this.acc.getX(), AY);
    }

    public void setA(double AX, double AY) {
        this.acc.setLocation(AX, AY);
    }

    public void setDecay(double d) {
        this.decay = d;
    }

    public void setCertainty(double c) {
        this.certainty = c;
        if (this.certainty < 0.0) {
            this.certainty = 0.0;
        }
    }

    public void setRand(double r) {
        this.randp = r;
    }

    public double getCertainty() {
        return this.certainty;
    }

    public int getTime() {
        return this.seenTime;
    }

    public double getX() {
        return this.pos.getX();
    }

    public double getY() {
        return this.pos.getY();
    }

    public Point2D getPoint() {
        return this.pos;
    }

    public double getDist() {
        return this.dist;
    }

    public double getDir() {
        return this.dir;
    }

    public double getVX() {
        return this.vel.getX();
    }

    public double getVY() {
        return this.vel.getY();
    }

    public double getV() {
        return this.vel.distance(0.0, 0.0);
    }

    public double getAX() {
        return this.acc.getX();
    }

    public double getAY() {
        return this.acc.getY();
    }

    public double getPredX(int t) {
        double predX = this.pos.getX();
        double predVelX = this.vel.getX();
        int i = 0;
        while (i < t) {
            predX += (predVelX *= this.decay);
            ++i;
        }
        return predX;
    }

    public double getPredY(int t) {
        double predY = this.pos.getY();
        double predVelY = this.vel.getY();
        int i = 0;
        while (i < t) {
            predY += (predVelY *= this.decay);
            ++i;
        }
        return predY;
    }

    public double getPredVX(int t) {
        double predVX = this.vel.getX();
        int i = 0;
        while (i < t) {
            predVX *= this.decay;
            ++i;
        }
        return predVX;
    }

    public double getPredVY(int t) {
        double predVY = this.vel.getY();
        int i = 0;
        while (i < t) {
            predVY *= this.decay;
            ++i;
        }
        return predVY;
    }

    public double getDistFrom(ObjectInfo obj) {
        return Math.sqrt(Math.pow(this.getX() - obj.getX(), 2.0) + Math.pow(this.getY() - obj.getY(), 2.0));
    }

    public boolean hasChangeInfo() {
        return this.change;
    }

    public void calcNextState() {
        double ux = this.vel.getX() + this.acc.getX();
        double uy = this.vel.getY() + this.acc.getY();
        this.pos.setLocation(this.pos.getX() + ux, this.pos.getY() + uy);
        this.vel.setLocation(ux * this.decay, uy * this.decay);
        this.acc.setLocation(0.0, 0.0);
        this.certainty -= 0.1;
        if (this.certainty < 0.0) {
            this.certainty = 0.0;
        }
        ++this.seenTime;
        ++this.controlTime;
    }

    public boolean isInSight(double X, double Y, double headFaceDir, String angleWidth) {
        double dir2;
        double absDir = 57.29577951308232 * Math.atan2(this.pos.getY() - Y, this.pos.getX() - X);
        double width = !angleWidth.equals("wide") ? 180.0 : (angleWidth.equals("normal") ? 90.0 : 45.0);
        double dir1 = Generic.normDir(headFaceDir + width / 2.0);
        return dir1 >= (dir2 = Generic.normDir(headFaceDir - width / 2.0)) ? dir1 >= absDir && absDir >= dir2 : dir1 >= absDir || absDir >= dir2;
    }

    public double getRelV() {
        return Math.sqrt(this.relVX * this.relVX + this.relVY * this.relVY);
    }

    public int getSeenTime() {
        return this.seenTime;
    }

    public void RemoveNoise() {
        double x1 = this.vel.getX() + this.velCorrect.getX();
        double x2 = this.vel.getX() - this.velCorrect.getX();
        double y1 = this.vel.getY() + this.velCorrect.getY();
        double y2 = this.vel.getY() - this.velCorrect.getY();
        Point2D.Double v1 = new Point2D.Double(x1, y1);
        Point2D.Double v2 = new Point2D.Double(x1, y2);
        Point2D.Double v3 = new Point2D.Double(x2, y1);
        Point2D.Double v4 = new Point2D.Double(x2, y2);
        Point2D.Double max = new Point2D.Double(Math.max(x1 + v1.distance(0.0, 0.0) * this.randp, x1 + v2.distance(0.0, 0.0) * this.randp), Math.min(y1 + v1.distance(0.0, 0.0) * this.randp, y1 + v3.distance(0.0, 0.0) * this.randp));
        Point2D.Double min = new Point2D.Double(Math.max(x2 - v3.distance(0.0, 0.0) * this.randp, x2 - v4.distance(0.0, 0.0) * this.randp), Math.min(y2 - v2.distance(0.0, 0.0) * this.randp, y2 - v4.distance(0.0, 0.0) * this.randp));
        this.vel.setLocation((((Point2D)max).getX() + ((Point2D)min).getX()) / 2.0, (((Point2D)max).getY() + ((Point2D)min).getY()) / 2.0);
        this.velCorrect.setLocation((((Point2D)max).getX() - ((Point2D)min).getX()) / 2.0, (((Point2D)max).getY() - ((Point2D)min).getY()) / 2.0);
    }

    public boolean getCertainty2() {
        return !(this.certainty < 0.5);
    }

    public double getCertainty1() {
        return this.certainty;
    }

    public int getControlTime() {
        return this.controlTime;
    }
}

