/*
 * Decompiled with CFR 0.152.
 */
package objectP;

import java.awt.geom.Point2D;
import objectP.ObjectInfo;

public class BallInfo
extends ObjectInfo {
    public BallInfo() {
        super(0.0, 0.0);
        this.setDecay(0.94);
        this.setCertainty(0.0);
        this.setRand(0.05);
        this.conf_decay = 0.8;
    }

    public BallInfo(double distance, double direction) {
        super(distance, direction);
        this.setDecay(0.94);
        this.setRand(0.05);
        this.conf_decay = 0.8;
    }

    public BallInfo(double distance, double direction, double distanceChange, double directionChange) {
        super(distance, direction, distanceChange, directionChange);
        this.setDecay(0.94);
        this.setRand(0.05);
        this.conf_decay = 0.8;
    }

    public String toStringBallInfo() {
        StringBuffer strBuff = new StringBuffer("(ball ");
        strBuff.append(this.getTime()).append(" ").append(this.getX()).append(" ").append(this.getY()).append(" ").append(this.getVX()).append(" ").append(this.getVY()).append(" ").append(this.getAX()).append(" ").append(this.getAY()).append(")");
        return strBuff.toString();
    }

    public void setBallInfo(int Time, double Dist, double Dir) {
        this.controlTime = Time;
        this.seenTime = Time;
        this.dist = Dist;
        this.dir = Dir;
        this.setCertainty(1.0);
        this.setRand(0.05);
        this.setDecay(0.94);
        this.conf_decay = 0.8;
    }

    public void setBallInfo(int Time, double Dist, double Dir, double DistChng, double DirChng) {
        this.controlTime = Time;
        this.seenTime = Time;
        this.dist = Dist;
        this.dir = Dir;
        this.distChange = DistChng;
        this.dirChange = DirChng;
        this.setCertainty(1.0);
        this.setRand(0.05);
        this.setDecay(0.94);
        this.conf_decay = 0.8;
    }

    @Override
    public double getPredX(int t) {
        double predX = this.pos.getX();
        double predVX = this.vel.getX();
        int i = 0;
        while (i < t) {
            predX += predVX;
            predVX *= this.decay;
            ++i;
        }
        return predX;
    }

    @Override
    public double getPredY(int t) {
        double predY = this.pos.getY();
        double predVY = this.vel.getY();
        int i = 0;
        while (i < t) {
            predY += predVY;
            predVY *= this.decay;
            ++i;
        }
        return predY;
    }

    public Point2D getPredPos(int t) {
        Point2D.Double temp = new Point2D.Double(this.getPredX(t), this.getPredY(t));
        return temp;
    }

    public void advanceBallInfo(int filedTime) {
        double uy;
        double ux;
        if (filedTime == this.controlTime) {
            return;
        }
        if (this.getCertainty2()) {
            ux = this.vel.getX() + this.acc.getX();
            uy = this.vel.getY() + this.acc.getY();
            this.pos.setLocation(this.pos.getX() + ux, this.pos.getY() + uy);
            this.vel.setLocation(ux * this.decay, uy * this.decay);
            this.acc.setLocation(0.0, 0.0);
            this.certainty *= this.conf_decay;
            ++this.controlTime;
        }
        while (filedTime - this.controlTime != 0) {
            if (this.getCertainty2()) {
                ux = this.vel.getX();
                uy = this.vel.getY();
                this.pos.setLocation(this.pos.getX() + ux, this.pos.getY() + uy);
                this.vel.setLocation(ux * this.decay, uy * this.decay);
                this.certainty *= this.conf_decay;
            }
            ++this.controlTime;
        }
    }

    private void ClearBallInfo() {
        this.setPos(0.0, 0.0);
        this.setV(0.0, 0.0);
        this.setA(0.0, 0.0);
        this.setCertainty(0.0);
        this.dir = 0.0;
        this.dist = 0.0;
        this.distChange = 0.0;
        this.dirChange = 0.0;
    }

    @Override
    public boolean getCertainty2() {
        if (this.certainty < 0.5) {
            this.ClearBallInfo();
            return false;
        }
        return true;
    }

    public void adjustBallDir(double turnDir) {
        this.dir -= turnDir;
    }
}

