/*
 * Decompiled with CFR 0.152.
 */
package info_managerP;

import genericP.Generic;
import genericP.Point;
import objectP.PlayerInfo;

public class PlayerTable {
    int time;
    int shadowsTime;
    PlayerInfo[] teammatesWithUNum = new PlayerInfo[11];
    PlayerInfo[] opponentsWithUNum = new PlayerInfo[11];
    PlayerInfo[] teammates = new PlayerInfo[11];
    PlayerInfo[] opponents = new PlayerInfo[11];
    PlayerInfo[] unknownPlayers = new PlayerInfo[21];
    int teammateCount;
    int opponentCount;
    int unknownPlayerCount;
    PlayerInfo[] teammateShadowsWithUNum = new PlayerInfo[11];
    PlayerInfo[] opponentShadowsWithUNum = new PlayerInfo[11];
    PlayerInfo[] teammateShadows = new PlayerInfo[11];
    PlayerInfo[] opponentShadows = new PlayerInfo[11];
    int teammateShadowCount;
    int opponentShadowCount;

    public PlayerTable() {
        this.formatAll();
        this.teammateCount = 0;
        this.opponentCount = 0;
        this.unknownPlayerCount = 0;
    }

    public void setTeammateWithUNum(PlayerInfo player, int uNum) {
        this.teammatesWithUNum[uNum - 1] = player;
    }

    public void setOpponentWithUNum(PlayerInfo player, int uNum) {
        this.opponentsWithUNum[uNum - 1] = player;
    }

    public void addTeammate(PlayerInfo player) {
        this.teammates[this.teammateCount] = player;
        ++this.teammateCount;
    }

    public void addOpponent(PlayerInfo player) {
        this.opponents[this.opponentCount] = player;
        ++this.opponentCount;
    }

    public void addUnknownPlayer(PlayerInfo player) {
        this.unknownPlayers[this.unknownPlayerCount] = player;
        ++this.unknownPlayerCount;
    }

    public void makeShadows() {
        int i = 0;
        while (i < 11) {
            this.teammateShadowsWithUNum[i] = this.teammatesWithUNum[i];
            this.opponentShadowsWithUNum[i] = this.opponentsWithUNum[i];
            this.teammateShadows[i] = this.teammates[i];
            this.opponentShadows[i] = this.opponents[i];
            ++i;
        }
        this.teammateShadowCount = this.teammateCount;
        this.opponentShadowCount = this.opponentCount;
        this.teammateCount = 0;
        this.opponentCount = 0;
        this.unknownPlayerCount = 0;
        i = 0;
        while (i < 11) {
            this.teammatesWithUNum[i].setCertainty(0.0);
            this.opponentsWithUNum[i].setCertainty(0.0);
            this.teammates[i].setCertainty(0.0);
            this.opponents[i].setCertainty(0.0);
            ++i;
        }
        this.shadowsTime = this.time;
    }

    public boolean hasTeammateInfo(int unum) {
        return this.teammatesWithUNum[unum - 1].getCertainty() == 1.0;
    }

    public double getTeammateX(int unum) {
        return this.teammatesWithUNum[unum - 1].getX();
    }

    public double getTeammateCertainty(int unum) {
        return this.teammatesWithUNum[unum - 1].getCertainty();
    }

    public void classifyUnknownPlayers(int blinkTime, double X, double Y, double headFaceDir, String angleWidth) {
        boolean[] teammatesWithUNumCandFlag = new boolean[11];
        boolean[] opponentsWithUNumCandFlag = new boolean[11];
        boolean[] teammatesCandFlag = new boolean[11];
        boolean[] opponentsCandFlag = new boolean[11];
        boolean[] teammateShadowsWithUNumCandFlag = new boolean[11];
        boolean[] opponentShadowsWithUNumCandFlag = new boolean[11];
        boolean[] teammateShadowsCandFlag = new boolean[11];
        boolean[] opponentShadowsCandFlag = new boolean[11];
        double margin = (double)blinkTime * 1.1;
        this.initCandFlag(teammatesWithUNumCandFlag, this.teammatesWithUNum, 11);
        this.initCandFlag(opponentsWithUNumCandFlag, this.opponentsWithUNum, 11);
        this.initCandFlag(teammateShadowsWithUNumCandFlag, this.teammateShadowsWithUNum, 11);
        this.initCandFlag(opponentShadowsWithUNumCandFlag, this.opponentShadowsWithUNum, 11);
        this.initCandFlag(teammatesCandFlag, this.teammates, this.teammateCount);
        this.initCandFlag(opponentsCandFlag, this.opponents, this.opponentCount);
        this.initCandFlag(teammateShadowsCandFlag, this.teammateShadows, this.teammateShadowCount);
        this.initCandFlag(opponentShadowsCandFlag, this.opponentShadows, this.opponentShadowCount);
        int i = 0;
        while (i < 11) {
            if (teammatesWithUNumCandFlag[i] && teammateShadowsWithUNumCandFlag[i]) {
                teammatesWithUNumCandFlag[i] = false;
                teammateShadowsWithUNumCandFlag[i] = false;
            }
            if (opponentsWithUNumCandFlag[i] && opponentShadowsWithUNumCandFlag[i]) {
                opponentsWithUNumCandFlag[i] = false;
                opponentShadowsWithUNumCandFlag[i] = false;
            }
            ++i;
        }
        i = 0;
        while (i < 11) {
            if (this.teammateCount < 11 && teammateShadowsWithUNumCandFlag[i] && !this.teammateShadowsWithUNum[i].isInSight(X, Y, headFaceDir, angleWidth)) {
                this.teammates[this.teammateCount] = this.teammateShadowsWithUNum[i];
                this.teammates[this.teammateCount].setCertainty(this.teammates[this.teammateCount].getCertainty() - 0.1);
                ++this.teammateCount;
            }
            ++i;
        }
        i = 0;
        while (i < 11) {
            if (this.opponentCount < 11 && opponentShadowsWithUNumCandFlag[i] && !this.opponentShadowsWithUNum[i].isInSight(X, Y, headFaceDir, angleWidth)) {
                this.opponents[this.opponentCount] = this.opponentShadowsWithUNum[i];
                this.opponents[this.opponentCount].setCertainty(this.opponents[this.opponentCount].getCertainty() - 0.1);
                ++this.opponentCount;
            }
            ++i;
        }
        i = 0;
        while (i < this.teammateShadowCount) {
            if (this.teammateCount < 11 && teammateShadowsCandFlag[i] && !this.teammateShadows[i].isInSight(X, Y, headFaceDir, angleWidth)) {
                this.teammates[this.teammateCount] = this.teammateShadows[i];
                this.teammates[this.teammateCount].setCertainty(this.teammates[this.teammateCount].getCertainty() - 0.1);
                ++this.teammateCount;
            }
            ++i;
        }
        i = 0;
        while (i < this.opponentShadowCount) {
            if (this.opponentCount < 11 && opponentShadowsCandFlag[i] && !this.opponentShadows[i].isInSight(X, Y, headFaceDir, angleWidth)) {
                this.opponents[this.opponentCount] = this.opponentShadows[i];
                this.opponents[this.opponentCount].setCertainty(this.opponents[this.opponentCount].getCertainty() - 0.1);
                ++this.opponentCount;
            }
            ++i;
        }
    }

    public void initCandFlag(boolean[] flags, PlayerInfo[] players, int n) {
        int i = 0;
        while (i < n) {
            flags[i] = players[i].getCertainty() > 0.1;
            ++i;
        }
    }

    public void comparePlayerWithShadow(double margin, boolean[] playerFlags, PlayerInfo[] players, int playerNum, boolean[] shadowFlags, PlayerInfo[] shadows, int shadowNum) {
        int i = 0;
        while (i < shadowNum) {
            if (shadowFlags[i]) {
                int index = -1;
                double minDist = 1000.0;
                int j = 0;
                while (j < playerNum) {
                    double dist;
                    if (playerFlags[j] && (dist = Generic.DIST(shadows[i].getX(), shadows[i].getY(), players[j].getX(), players[j].getY())) < margin && dist < minDist) {
                        minDist = dist;
                        index = j;
                    }
                    ++j;
                }
                if (index >= 0) {
                    shadowFlags[i] = false;
                    playerFlags[i] = false;
                }
            }
            ++i;
        }
    }

    public double getOffsideLine(double ballX) {
        double depth;
        double offsideLine = 0.0;
        double depth1 = 0.0;
        double depth2 = 0.0;
        int i = 0;
        while (i < 11) {
            if (this.opponentsWithUNum[i].getCertainty() > 0.1) {
                depth = this.opponentsWithUNum[i].getX();
                if (depth1 < depth) {
                    depth2 = depth1;
                    depth1 = depth;
                } else if (depth2 < depth) {
                    depth2 = depth;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.opponentCount) {
            depth = this.opponents[i].getX();
            if (depth1 < depth) {
                depth2 = depth1;
                depth1 = depth;
            } else if (depth2 < depth) {
                depth2 = depth;
            }
            ++i;
        }
        offsideLine = depth2 < ballX ? ballX : depth2;
        return offsideLine;
    }

    public void getPosOfOpponentsForward(Point oppXY) {
        double tmp;
        double depth = 52.5;
        int i = 0;
        while (i < 11) {
            if (this.opponentsWithUNum[i].getCertainty() > 0.1 && depth > (tmp = this.opponentsWithUNum[i].getX())) {
                depth = tmp;
                oppXY.setPointX(depth);
                oppXY.setPointY(this.opponentsWithUNum[i].getY());
            }
            ++i;
        }
        i = 0;
        while (i < this.opponentCount) {
            tmp = this.opponents[i].getX();
            if (depth > tmp) {
                depth = tmp;
                oppXY.setPointX(depth);
                oppXY.setPointY(this.opponents[i].getY());
            }
            ++i;
        }
    }

    public int getOrderFrom(double posX, double posY, double myX, double myY) {
        int order = 0;
        double dist = Math.sqrt((posX - myX) * (posX - myX) + (posY - myY) * (posY - myY));
        int i = 1;
        while (i < 11) {
            if (this.teammatesWithUNum[i].getCertainty() > 0.1 && Math.sqrt(Math.pow(posX - this.teammatesWithUNum[i].getX(), 2.0) + Math.pow(posY - this.teammatesWithUNum[i].getY(), 2.0)) < dist) {
                ++order;
            }
            ++i;
        }
        i = 0;
        while (i < this.teammateCount) {
            if (Math.sqrt(Math.pow(posX - this.teammates[i].getX(), 2.0) + Math.pow(posY - this.teammates[i].getY(), 2.0)) < dist) {
                ++order;
            }
            ++i;
        }
        return ++order;
    }

    public double evalLine(double sx, double sy, double ex, double ey) {
        double a = (ey - sy) / (ex - sx);
        double b = sy - a * sx;
        double value = 0.0;
        PlayerInfo[] opps = new PlayerInfo[22];
        int i = 0;
        while (i < this.opponentCount) {
            opps[i] = this.opponents[i];
            ++i;
        }
        int oppCount = this.opponentCount;
        i = 0;
        while (i < 11) {
            if (this.opponentsWithUNum[i].getCertainty() > 0.1) {
                opps[oppCount] = this.opponentsWithUNum[i];
                ++oppCount;
            }
            ++i;
        }
        if (Math.abs(a) > 0.05) {
            double ia = Math.abs(ex - sx) < 0.001 ? 0.0 : -1.0 / a;
            double sb = sy - ia * sx;
            double eb = ey - ia * ex;
            if (sx <= ex && ia < 0.0 || sx > ex && ia > 0.0) {
                i = 0;
                while (i < oppCount) {
                    double ox = opps[i].getX();
                    double oy = opps[i].getY();
                    if (oy - ia * ox - sb >= 0.0 && oy - ia * ox - eb <= 0.0) {
                        value += opps[i].getCertainty() * (1.0 / (Generic.getDistPointLine(ox, oy, a, -1.0, b) / 5.0 + 0.7));
                    }
                    value += opps[i].getCertainty() * (1.0 / (Math.sqrt((ox - ex) * (ox - ex) + (oy - ey) * (oy - ey)) / 5.0 + 1.0));
                    ++i;
                }
            } else {
                i = 0;
                while (i < oppCount) {
                    double ox = opps[i].getX();
                    double oy = opps[i].getY();
                    if (oy - ia * ox - sb <= 0.0 && oy - ia * ox - eb >= 0.0) {
                        value += opps[i].getCertainty() * (1.0 / (Generic.getDistPointLine(ox, oy, a, -1.0, b) / 5.0 + 0.7));
                    }
                    value += opps[i].getCertainty() * (1.0 / (Math.sqrt((ox - ex) * (ox - ex) + (oy - ey) * (oy - ey)) / 5.0 + 1.0));
                    ++i;
                }
            }
        } else {
            i = 0;
            while (i < oppCount) {
                double ox = opps[i].getX();
                double oy = opps[i].getY();
                if (sx <= ox && ox <= ex || ex <= ox && ox <= sx) {
                    value += opps[i].getCertainty() * (1.0 / (Generic.getDistPointLine(ox, oy, a, -1.0, b) / 5.0 + 0.7));
                }
                value += opps[i].getCertainty() * (1.0 / (Math.sqrt((ox - ex) * (ox - ex) + (oy - ey) * (oy - ey)) / 5.0 + 1.0));
                ++i;
            }
        }
        return value;
    }

    public double evalPlayer(PlayerInfo player, double X, double Y) {
        return this.evalLine(X, Y, player.getX(), player.getY());
    }

    public double getPosOfReceiver(double dir, double dirDiff, double dist, double X, double Y, Point recXY) {
        double value;
        double tdist;
        double tdir;
        double ty;
        double tx;
        double minValue = 1000.0;
        int i = 0;
        while (i < 11) {
            if (this.teammatesWithUNum[i].getCertainty() > 0.1) {
                tx = this.teammatesWithUNum[i].getX();
                ty = this.teammatesWithUNum[i].getY();
                tdir = 57.29577951308232 * Math.atan2(ty - Y, tx - X);
                tdist = Generic.DIST(X, Y, tx, ty);
                if (tdist <= dist && Math.abs(Generic.normDir(tdir - dir)) <= dirDiff && (value = this.evalLine(X, Y, tx, ty)) < minValue) {
                    recXY.setPointX(tx);
                    recXY.setPointY(ty);
                    minValue = value;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.teammateCount) {
            tx = this.teammates[i].getX();
            ty = this.teammates[i].getY();
            tdir = 57.29577951308232 * Math.atan2(ty - Y, tx - X);
            tdist = Generic.DIST(X, Y, tx, ty);
            if (tdist <= dist && Math.abs(Generic.normDir(tdir - dir)) <= dirDiff && (value = this.evalLine(X, Y, tx, ty)) < minValue) {
                recXY.setPointX(tx);
                recXY.setPointY(ty);
                minValue = value;
            }
            ++i;
        }
        return minValue;
    }

    public double getPosOfNearestOpponent(double dir, double dirDiff, double dist, double X, double Y, Point oppXY) {
        double odist;
        double odir;
        double oy;
        double ox;
        double minDist = 1000.0;
        int i = 0;
        while (i < 11) {
            if (this.opponentsWithUNum[i].getCertainty() > 0.1) {
                ox = this.opponentsWithUNum[i].getX();
                oy = this.opponentsWithUNum[i].getY();
                odir = 57.29577951308232 * Math.atan2(oy - Y, ox - X);
                odist = Generic.DIST(X, Y, ox, oy);
                if (odist <= dist && Math.abs(Generic.normDir(odir - dir)) <= dirDiff && odist < minDist) {
                    minDist = odist;
                    oppXY.setPointX(ox);
                    oppXY.setPointY(oy);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.opponentCount) {
            ox = this.opponents[i].getX();
            oy = this.opponents[i].getY();
            odir = 57.29577951308232 * Math.atan2(oy - Y, ox - X);
            odist = Generic.DIST(X, Y, ox, oy);
            if (odist <= dist && Math.abs(Generic.normDir(odir - dir)) <= dirDiff && odist < minDist) {
                minDist = odist;
                oppXY.setPointX(ox);
                oppXY.setPointY(oy);
            }
            ++i;
        }
        return minDist;
    }

    public void printInfo() {
        int i = 0;
        while (i < 11) {
            if (this.teammatesWithUNum[i].getCertainty() > 0.1) {
                System.out.println("Teammate : " + (i + 1));
                System.out.println("(X,Y) = (" + this.teammatesWithUNum[i].getX() + "," + this.teammatesWithUNum[i].getY() + ")");
                System.out.println("Certainty : " + this.teammatesWithUNum[i].getCertainty());
            }
            ++i;
        }
        i = 0;
        while (i < this.teammateCount) {
            if (this.teammates[i].getCertainty() > 0.1) {
                System.out.println("Teammate : Unknown");
                System.out.println("(X,Y) = (" + this.teammates[i].getX() + "," + this.teammates[i].getY() + ")");
                System.out.println("Certainty : " + this.teammates[i].getCertainty());
            }
            ++i;
        }
        i = 0;
        while (i < 11) {
            if (this.opponentsWithUNum[i].getCertainty() > 0.1) {
                System.out.println("Opponent : " + (i + 1));
                System.out.println("(X,Y) = (" + this.opponentsWithUNum[i].getX() + "," + this.opponentsWithUNum[i].getY() + ")");
                System.out.println("Certainty : " + this.opponentsWithUNum[i].getCertainty());
            }
            ++i;
        }
        i = 0;
        while (i < this.opponentCount) {
            if (this.opponents[i].getCertainty() > 0.1) {
                System.out.println("Opponent : Unknown");
                System.out.println("(X,Y) = (" + this.opponents[i].getX() + "," + this.opponents[i].getY() + ")");
                System.out.println("Certainty : " + this.opponents[i].getCertainty());
            }
            ++i;
        }
    }

    public boolean parseSide(double ballY) {
        int count = 0;
        int opponents = 0;
        int i = 0;
        while (i < 11) {
            if (this.opponentsWithUNum[i].getCertainty() > 0.1) {
                ++opponents;
                if (this.opponentsWithUNum[i].getY() * ballY >= 0.0) {
                    ++count;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.opponentCount) {
            ++opponents;
            if (this.opponentsWithUNum[i].getY() * ballY >= 0.0) {
                ++count;
            }
            ++i;
        }
        return count * 2 > opponents;
    }

    public int forwardFW(double dir, double dirDiff, double dist, double X, double Y) {
        double tdir;
        double ty;
        double tx;
        int count = 0;
        int i = 0;
        while (i < 11) {
            if (this.teammatesWithUNum[i].getCertainty() > 0.1) {
                tx = this.teammatesWithUNum[i].getX();
                ty = this.teammatesWithUNum[i].getY();
                tdir = 57.29577951308232 * Math.atan2(ty - Y, tx - X);
                if (tx > X + dist && Math.abs(Generic.normDir(tdir - dir)) <= dirDiff) {
                    ++count;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.teammateCount) {
            tx = this.teammates[i].getX();
            ty = this.teammates[i].getY();
            tdir = 57.29577951308232 * Math.atan2(ty - Y, tx - X);
            if (tx > X + dist && Math.abs(Generic.normDir(tdir - dir)) <= dirDiff) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public double getSideChangeReceiver(double dir, double dirDiff, double dist, double X, double Y, Point recXY) {
        double value;
        double tdist;
        double tdir;
        double ty;
        double tx;
        double minValue = 1000.0;
        int i = 0;
        while (i < 11) {
            if (this.teammatesWithUNum[i].getCertainty() > 0.1) {
                tx = this.teammatesWithUNum[i].getX();
                ty = this.teammatesWithUNum[i].getY();
                if (Y >= 0.0 && ty < Y || Y < 0.0 && ty > Y) {
                    tdir = 57.29577951308232 * Math.atan2(ty - Y, tx - X);
                    tdist = Generic.DIST(X, Y, tx, ty);
                    if (tdist <= dist && Math.abs(Generic.normDir(tdir - dir)) <= dirDiff && (value = this.evalLine(X, Y, tx, ty)) < minValue) {
                        recXY.setPointX(tx);
                        recXY.setPointY(ty);
                        minValue = value;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.teammateCount) {
            tx = this.teammates[i].getX();
            ty = this.teammates[i].getY();
            if (Y >= 0.0 && ty < Y || Y < 0.0 && ty > Y) {
                tdir = 57.29577951308232 * Math.atan2(ty - Y, tx - X);
                tdist = Generic.DIST(X, Y, tx, ty);
                if (tdist <= dist && Math.abs(Generic.normDir(tdir - dir)) <= dirDiff && (value = this.evalLine(X, Y, tx, ty)) < minValue) {
                    recXY.setPointX(tx);
                    recXY.setPointY(ty);
                    minValue = value;
                }
            }
            ++i;
        }
        return minValue;
    }

    public PlayerInfo getTeammateInfo(int unum) {
        return this.teammatesWithUNum[unum - 1];
    }

    public PlayerInfo getOpponetsPlayer(int select) {
        return this.opponentsWithUNum[select];
    }

    public PlayerInfo getTeammate(int select) {
        return this.teammatesWithUNum[select];
    }

    public boolean checkMarkedOpponent(double dir, double dirDiff, double dist, double X, double Y) {
        double odist;
        double odir;
        double oy;
        double ox;
        boolean freeFlag = false;
        int i = 0;
        while (!freeFlag && i < 11) {
            if (this.opponentsWithUNum[i].getCertainty() > 0.1) {
                ox = this.opponentsWithUNum[i].getPredX(1);
                oy = this.opponentsWithUNum[i].getPredY(1);
                odir = 57.29577951308232 * Math.atan2(oy - Y, ox - X);
                odist = Generic.DIST(X, Y, ox, oy);
                if (odist <= 2.5 || odist <= dist && Math.abs(Generic.normDir(odir - dir)) <= dirDiff) {
                    freeFlag = true;
                }
            }
            ++i;
        }
        i = 0;
        while (!freeFlag && i < this.opponentCount) {
            ox = this.opponents[i].getPredX(1);
            oy = this.opponents[i].getPredY(1);
            odir = 57.29577951308232 * Math.atan2(oy - Y, ox - X);
            odist = Generic.DIST(X, Y, ox, oy);
            if (odist <= 2.5 || odist <= dist && Math.abs(Generic.normDir(odir - dir)) <= dirDiff) {
                freeFlag = true;
            }
            ++i;
        }
        return freeFlag;
    }

    public void formatAll() {
        int i = 0;
        while (i < 11) {
            this.teammatesWithUNum[i] = new PlayerInfo();
            this.opponentsWithUNum[i] = new PlayerInfo();
            this.teammates[i] = new PlayerInfo();
            this.opponents[i] = new PlayerInfo();
            this.teammateShadowsWithUNum[i] = new PlayerInfo();
            this.opponentShadowsWithUNum[i] = new PlayerInfo();
            this.teammateShadows[i] = new PlayerInfo();
            this.opponentShadows[i] = new PlayerInfo();
            this.unknownPlayers[i] = new PlayerInfo();
            ++i;
        }
        i = 11;
        while (i < 21) {
            this.unknownPlayers[i] = new PlayerInfo();
            ++i;
        }
    }

    public double getPosOfReceiver(double dir, double dirDiff, double dist, double X, double Y, Point recXY, int point) {
        double value;
        double tdist;
        double tdir;
        double ty;
        double tx;
        double minValue = 1000.0;
        int i = 0;
        while (i < 11) {
            if (this.teammatesWithUNum[i].getCertainty() > 0.1) {
                tx = this.teammatesWithUNum[i].getX();
                ty = this.teammatesWithUNum[i].getY();
                tdir = 57.29577951308232 * Math.atan2(ty - Y, tx - X);
                tdist = Generic.DIST(X, Y, tx, ty);
                if (tdist <= dist && Math.abs(Generic.normDir(tdir - dir)) <= dirDiff && tx > X + (double)point && (value = this.evalLine(X, Y, tx, ty)) < minValue) {
                    recXY.setPointX(tx);
                    recXY.setPointY(ty);
                    minValue = value;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.teammateCount) {
            tx = this.teammates[i].getX();
            ty = this.teammates[i].getY();
            tdir = 57.29577951308232 * Math.atan2(ty - Y, tx - X);
            tdist = Generic.DIST(X, Y, tx, ty);
            if (tdist <= dist && Math.abs(Generic.normDir(tdir - dir)) <= dirDiff && (value = this.evalLine(X, Y, tx, ty)) < minValue) {
                recXY.setPointX(tx);
                recXY.setPointY(ty);
                minValue = value;
            }
            ++i;
        }
        return minValue;
    }

    public void updatePlayerTable() {
        int i = 0;
        while (i < 11) {
            this.teammatesWithUNum[i].calcNextState();
            this.opponentsWithUNum[i].calcNextState();
            ++i;
        }
        i = 0;
        while (i < this.teammateCount) {
            this.teammates[i].calcNextState();
            ++i;
        }
        i = 0;
        while (i < this.opponentCount) {
            this.opponentsWithUNum[i].calcNextState();
            ++i;
        }
    }
}

