/*
 * Decompiled with CFR 0.152.
 */
package info_managerP;

import genericP.Generic;
import genericP.NSobject;
import genericP.Point;
import info_managerP.PlayerTable;
import info_managerP.StrategyTable;
import java.awt.geom.Point2D;
import objectP.BallInfo;
import objectP.FlagInfo;
import objectP.LineInfo;
import objectP.ObjectInfo;
import objectP.PlayerInfo;
import parserP.BodyInfoParser;
import parserP.HearInfoParser;
import parserP.SeeInfoParser;
import stokenizerP.STokenizer;

public class InfoManager {
    String teamname;
    String side;
    int uniformNum;
    int seeTime;
    int prevSeeTime;
    int bodyTime;
    int hearTime;
    int lastUpdateEtcTime;
    int playmode;
    String angleWidth;
    String quality;
    double stamina;
    double effort;
    double recovery;
    double x;
    double y;
    double bodyFaceDir;
    double headFaceDir;
    double headAngle;
    double speed;
    double vx;
    double vy;
    double ax;
    double ay;
    double pvx;
    double pvy;
    final int puSize = 5;
    double ux;
    double uy;
    double[] pux = new double[5];
    double[] puy = new double[5];
    double pHeadFaceDir;
    double pBallVX;
    double pBallVY;
    int ourPoint;
    int opponentsPoint;
    int kickCount;
    int dashCount;
    int turnCount;
    int sayCount;
    int turnNeckCount;
    private double nextBodyAbsDir;
    private double nextHeadRelDir;
    private double nextHeadAbsDir;
    private final int UNKNOWN = -999;
    SeeInfoParser seeInfoParser = new SeeInfoParser();
    BodyInfoParser bodyInfoParser = new BodyInfoParser();
    HearInfoParser hearInfoParser = new HearInfoParser();
    PlayerTable playerTable = new PlayerTable();
    StrategyTable strategyTable = new StrategyTable(this.playerTable);
    BallInfo ball = new BallInfo();
    BallInfo ballShadow = new BallInfo();
    boolean knowsBallInfo;
    int searchFlag;
    String selfString;
    String oppForwardString;
    String strategy;
    String strategyType;
    double strategyCertainty;
    boolean strategyFlag;
    int planner;
    int planTime = 0;
    double ctStX;
    double ctStY;
    double ctSdX;
    double ctSdY;
    boolean stdPosChanged = false;
    boolean evalSRFlag = false;
    double ctkX;
    double ctkY;
    double ctmyX;
    double ctmyY;
    boolean freekickPosChanged = false;

    public InfoManager(String tname, int uNum, String s) {
        this.teamname = tname;
        this.side = s;
        this.seeInfoParser.setSide(this.side);
        this.hearInfoParser.setSide(this.side);
        this.hearInfoParser.setTeamname(this.teamname);
        this.uniformNum = uNum;
        this.seeTime = 0;
        this.bodyTime = 0;
        this.stamina = 3500.0;
        this.effort = 1.0;
        this.recovery = 1.0;
        this.x = 0.0;
        this.y = 0.0;
        this.bodyFaceDir = 0.0;
        this.headFaceDir = 0.0;
        this.headAngle = 0.0;
        this.pvy = 0.0;
        this.pvx = 0.0;
        this.vy = 0.0;
        this.vx = 0.0;
        this.speed = 0.0;
        this.uy = 0.0;
        this.ux = 0.0;
        this.ay = 0.0;
        this.ax = 0.0;
        this.pBallVY = 0.0;
        this.pBallVX = 0.0;
        this.kickCount = 0;
        this.dashCount = 0;
        this.turnCount = 0;
        this.sayCount = 0;
        this.turnNeckCount = 0;
        this.knowsBallInfo = false;
        this.searchFlag = 0;
        this.strategy = "private";
        this.strategyType = "show";
        this.strategyCertainty = 0.0;
        this.strategyFlag = false;
        this.planner = 0;
        this.nextBodyAbsDir = -999.0;
        this.nextHeadRelDir = -999.0;
        this.nextHeadAbsDir = -999.0;
    }

    void calcFaceDir() {
        double tmpDir = 0.0;
        if (this.seeInfoParser.getLineNum() == 0) {
            return;
        }
        LineInfo line = this.seeInfoParser.getLineInfo(0);
        String location = line.getLocation();
        double lineDir = line.getDir();
        boolean inField = this.isInField();
        if (location.equals("t")) {
            tmpDir = inField ? -lineDir - (lineDir < 0.0 ? 180.0 : 0.0) : -lineDir - (lineDir > 0.0 ? -180.0 : 0.0);
        } else if (location.equals("b")) {
            tmpDir = inField ? -lineDir - (lineDir > 0.0 ? -180.0 : 0.0) : -lineDir - (lineDir < 0.0 ? 180.0 : 0.0);
        } else if (location.equals("l")) {
            tmpDir = inField ? -lineDir - (lineDir < 0.0 ? -90.0 : 90.0) : -lineDir - (lineDir > 0.0 ? -90.0 : 90.0);
        } else if (location.equals("r")) {
            tmpDir = inField ? -lineDir - (lineDir > 0.0 ? -90.0 : 90.0) : -lineDir - (lineDir < 0.0 ? -90.0 : 90.0);
        }
        if (this.side.equals("r")) {
            tmpDir += tmpDir > 0.0 ? -180.0 : 180.0;
        }
        this.headFaceDir = tmpDir;
        this.bodyFaceDir = Generic.normDir(this.headFaceDir - this.headAngle);
    }

    void calcPos() {
        FlagInfo[] flags = this.seeInfoParser.getFlags();
        int flagNumber = this.seeInfoParser.getFlagNum();
        if (flagNumber == 0) {
            return;
        }
        if (flagNumber > 2) {
            double secdir;
            double xa = 0.0;
            double ya = 0.0;
            double xb = 0.0;
            double yb = 0.0;
            xa = flags[0].getX();
            ya = flags[0].getY();
            xb = flags[1].getX();
            yb = flags[1].getY();
            double pridir = flags[0].getDir();
            double angle = pridir > (secdir = flags[1].getDir()) ? pridir - secdir : secdir - pridir;
            angle = angle * Math.PI / 180.0;
            double theta = Math.asin(flags[0].getDist() * Math.sin(angle) / Point2D.distance(xa, ya, xb, yb));
            double alpha = Math.PI - angle - theta;
            if (flags[0].getDir() > flags[1].getDir()) {
                alpha *= -1.0;
            }
            this.x = xa + ((xb - xa) * Math.cos(alpha) - (yb - ya) * Math.sin(alpha)) * flags[0].getDist() / Point2D.distance(xa, ya, xb, yb);
            this.y = ya + ((yb - ya) * Math.cos(alpha) + (xb - xa) * Math.sin(alpha)) * flags[0].getDist() / Point2D.distance(xa, ya, xb, yb);
        } else {
            double xa = 0.0;
            double ya = 0.0;
            xa = flags[0].getX();
            ya = flags[0].getY();
            double angle = Generic.normDir(this.headFaceDir + flags[0].getDir());
            this.x = xa - flags[0].getDist() * Math.cos(angle * Math.PI / 180.0);
            this.y = ya - flags[0].getDist() * Math.sin(angle * Math.PI / 180.0);
        }
        if (this.uniformNum == 1) {
            if (this.x < -52.5) {
                this.x = -52.5;
            }
            if (this.x > -20.0) {
                this.x = -52.5;
            }
        }
    }

    void calcV() {
        this.vx = this.speed * Math.cos(Generic.digToRad(this.bodyFaceDir));
        this.vy = this.speed * Math.sin(Generic.digToRad(this.bodyFaceDir));
    }

    public void printBodyInfo() {
        System.out.println("************* BodyInfo *************");
        System.out.println("Time : " + this.bodyTime);
        System.out.println("AngleWidth : " + this.angleWidth);
        System.out.println("Quality : " + this.quality);
        System.out.println("Stamina : " + this.stamina);
        System.out.println("Effort : " + this.effort);
        System.out.println("Speed : " + this.speed);
        System.out.println("HeadAngle : " + this.headAngle);
    }

    public double getXMoveDist(double velX, double power, double direction) {
        return velX + power * Math.cos(Generic.digToRad(direction));
    }

    public double getYMoveDist(double velY, double power, double direction) {
        return velY + power * Math.sin(Generic.digToRad(direction));
    }

    public double getDashPowerBySpeed(double targetSpeed) {
        double actualPower = (targetSpeed / 0.4 - this.speed) / 0.006;
        return actualPower / this.effort;
    }

    public double getDashPowerByMoveDist(double distance) {
        double actualPower = (distance - this.speed) / 0.006;
        return actualPower / this.effort;
    }

    public double getMoment(double actualAngle) {
        return actualAngle * (1.0 + 5.0 * this.speed);
    }

    public void getKickArgByAccel(double AX, double AY, NSobject power, NSobject dir) {
        double adir = 57.29577951308232 * Math.atan2(AY, AX);
        dir.setNS(Generic.normDir(adir - this.bodyFaceDir));
        double a = Math.sqrt(AX * AX + AY * AY);
        power.setNS(a / (0.016 * (1.0 - 0.25 * Math.abs(Generic.normDir(this.getAbsDir(this.ball) - this.bodyFaceDir)) / 180.0 - 0.25 * (this.getBallDist() - 0.3 - 0.085) / 0.7)));
        if (power.getNS() > 100.0) {
            power.setNS(100.0);
        }
    }

    public void getKickArgByMoveDist(double X, double Y, NSobject power, NSobject dir) {
        double ax = X - this.ball.getVX();
        double ay = Y - this.ball.getVY();
        this.getKickArgByAccel(ax, ay, power, dir);
    }

    public void getKickArgByDest(double X, double Y, double speed, NSobject power, NSobject dir) {
        dir.setNS(57.29577951308232 * Math.atan2(Y - this.ball.getY(), X - this.ball.getX()));
        double ballVX = speed * Math.cos(Generic.digToRad(dir.getNS()));
        double ballVY = speed * Math.sin(Generic.digToRad(dir.getNS()));
        double ax = ballVX / 0.94 - this.ball.getVX();
        double ay = ballVY / 0.94 - this.ball.getVY();
        this.getKickArgByAccel(ax, ay, power, dir);
    }

    public void getKickArgForPowerShot(double X, double Y, NSobject power, NSobject dir, boolean save) {
        double tmpY;
        double tmpX;
        double centRelY;
        double centRelX;
        double centDist2;
        double margin = 0.15;
        double destRelX = X - this.x;
        double destRelY = Y - this.y;
        double ballRelX = this.ball.getX() - this.x;
        double ballRelY = this.ball.getY() - this.y;
        double r = 1.085 - margin;
        Point tmpXY1 = new Point();
        Point tmpXY2 = new Point();
        double destDist = Math.sqrt(destRelX * destRelX + destRelY * destRelY);
        double centDir1 = Generic.normDir(57.29577951308232 * Math.atan2(destRelY, destRelX) + (90.0 - 57.29577951308232 * Math.asin(0.5 / destDist)));
        double centDir2 = Generic.normDir(57.29577951308232 * Math.atan2(destRelY, destRelX) - (90.0 - 57.29577951308232 * Math.asin(0.5 / destDist)));
        double centRelX1 = 0.5 * Math.cos(centDir1);
        double centRelY1 = 0.5 * Math.sin(centDir1);
        double centRelX2 = 0.5 * Math.cos(centDir2);
        double centRelY2 = 0.5 * Math.sin(centDir2);
        double centDist1 = Math.sqrt(Math.pow(centRelX1 - ballRelX, 2.0) + Math.pow(centRelY1 - ballRelY, 2.0));
        if (centDist1 <= (centDist2 = Math.sqrt(Math.pow(centRelX2 - ballRelX, 2.0) + Math.pow(centRelY2 - ballRelY, 2.0)))) {
            centRelX = centRelX1;
            centRelY = centRelY1;
        } else {
            centRelX = centRelX2;
            centRelY = centRelY2;
        }
        if (save) {
            double keepDir = 57.29577951308232 * Math.atan2(centRelY, centRelX) - this.bodyFaceDir;
            double keepDist = Math.sqrt(centRelX * centRelX + centRelY * centRelY);
            this.getKickArgByKeepDir(keepDir, keepDist, power, dir);
            return;
        }
        Generic.getCrossPoint(r, destRelX, destRelY, centRelX, centRelY, tmpXY1, tmpXY2);
        double tmpDist1 = Math.sqrt(Math.pow(destRelX - tmpXY1.getPointX(), 2.0) + Math.pow(destRelY - tmpXY1.getPointY(), 2.0));
        double tmpDist2 = Math.sqrt(Math.pow(destRelX - tmpXY2.getPointX(), 2.0) + Math.pow(destRelY - tmpXY2.getPointY(), 2.0));
        if (tmpDist1 <= tmpDist2) {
            tmpX = tmpXY1.getPointX();
            tmpY = tmpXY1.getPointY();
        } else {
            tmpX = tmpXY2.getPointX();
            tmpY = tmpXY2.getPointY();
        }
        double keepDir = Generic.normDir(57.29577951308232 * Math.atan2(tmpY, tmpX) - this.bodyFaceDir);
        double keepDist = Math.sqrt(tmpX * tmpX + tmpY * tmpY);
        this.getKickArgByKeepDir(keepDir, keepDist, power, dir);
    }

    public void getKickArgByKeepDir(double keepDir, double keepDist, NSobject power, NSobject dir) {
        double my;
        double mx;
        double margin = 0.28500000000000003;
        double ballDir = Generic.normDir(this.getAbsDir(this.ball) - this.bodyFaceDir);
        double ballDist = this.getBallDist();
        double destRelX = this.vx + keepDist * Math.cos(Generic.digToRad(Generic.normDir(keepDir + this.bodyFaceDir)));
        double destRelY = this.vy + keepDist * Math.sin(Generic.digToRad(Generic.normDir(keepDir + this.bodyFaceDir)));
        double ballRelX = this.ball.getX() - this.x;
        double ballRelY = this.ball.getY() - this.y;
        boolean direct = true;
        double destDist = Math.sqrt(Math.pow(destRelX - ballRelX, 2.0) + Math.pow(destRelY - ballRelY, 2.0));
        double destDir = 57.29577951308232 * Math.atan2(destRelY - ballRelY, destRelX - ballRelX);
        NSobject destDirNS = new NSobject(destDir);
        NSobject destDistNS = new NSobject(destDist);
        this.adjustDestToAvoidBody(destDirNS, destDistNS);
        if (Math.abs(Generic.normDir(keepDir - ballDir)) < 2.0 && Math.abs(keepDist - ballDist) < 0.1) {
            mx = 0.0;
            my = 0.0;
        } else {
            mx = destDistNS.getNS() * Math.cos(Generic.digToRad(destDirNS.getNS()));
            my = destDistNS.getNS() * Math.sin(Generic.digToRad(destDirNS.getNS()));
        }
        this.getKickArgByMoveDist(mx, my, power, dir);
    }

    public boolean adjustDestToAvoidBody(NSobject destDir, NSobject destDist) {
        double lowerDir;
        double upperDir;
        boolean direct = true;
        double margin = 0.235;
        double ballDir = Generic.normDir(this.getAbsDir(this.ball) - this.bodyFaceDir);
        double ballDist = this.getBallDist();
        if (ballDir >= 0.0) {
            upperDir = Generic.normDir(-(180.0 - ballDir) + 57.29577951308232 * Math.asin((0.3 + margin) / ballDist));
            lowerDir = Generic.normDir(-(180.0 - ballDir) - 57.29577951308232 * Math.asin((0.3 + margin) / ballDist));
        } else {
            upperDir = Generic.normDir(180.0 + ballDir - 57.29577951308232 * Math.asin((0.3 + margin) / ballDist));
            lowerDir = Generic.normDir(180.0 + ballDir + 57.29577951308232 * Math.asin((0.3 + margin) / ballDist));
        }
        if (ballDir >= 0.0) {
            if (upperDir >= lowerDir) {
                if (lowerDir < Generic.normDir(destDir.getNS() - this.bodyFaceDir) && Generic.normDir(destDir.getNS() - this.bodyFaceDir) < upperDir) {
                    direct = false;
                }
            } else if (lowerDir < Generic.normDir(destDir.getNS() - this.bodyFaceDir) || Generic.normDir(destDir.getNS() - this.bodyFaceDir) < upperDir) {
                direct = false;
            }
        } else if (upperDir <= lowerDir) {
            if (lowerDir > Generic.normDir(destDir.getNS() - this.bodyFaceDir) && Generic.normDir(destDir.getNS() - this.bodyFaceDir) > upperDir) {
                direct = false;
            }
        } else if (lowerDir > Generic.normDir(destDir.getNS() - this.bodyFaceDir) || Generic.normDir(destDir.getNS() - this.bodyFaceDir) > upperDir) {
            direct = false;
        }
        double destRelX = destDist.getNS() * Math.cos(Generic.digToRad(destDir.getNS()));
        double destRelY = destDist.getNS() * Math.sin(Generic.digToRad(destDir.getNS()));
        double ballRelX = this.ball.getX() - this.x;
        double ballRelY = this.ball.getY() - this.y;
        double r = 0.3 - margin;
        Point tmpXY1 = new Point();
        Point tmpXY2 = new Point();
        Generic.getCrossPoint(r, destRelX, destRelY, ballRelX, ballRelY, tmpXY1, tmpXY2);
        double tmpDist1 = Math.sqrt(tmpXY1.getPointX() * tmpXY1.getPointX() + tmpXY1.getPointY() * tmpXY1.getPointY());
        double tmpDist2 = Math.sqrt(tmpXY2.getPointX() * tmpXY2.getPointX() + tmpXY2.getPointY() * tmpXY2.getPointY());
        if (tmpDist1 > destDist.getNS() && tmpDist2 > destDist.getNS()) {
            direct = true;
        }
        if (!direct) {
            if (Math.abs(upperDir) <= Math.abs(lowerDir)) {
                destDir.setNS(Generic.normDir(upperDir + this.bodyFaceDir));
            } else {
                destDir.setNS(Generic.normDir(lowerDir + this.bodyFaceDir));
            }
            destDist.setNS(1.5 * Math.sqrt(ballDist * ballDist - Math.pow(0.3 + margin, 2.0)));
        }
        return direct;
    }

    public boolean isInField() {
        return this.seeInfoParser.getLineNum() % 2 == 1;
    }

    public double getAbsDir(ObjectInfo obj) {
        return 57.29577951308232 * Math.atan2(obj.getY() - this.y, obj.getX() - this.x);
    }

    public double getDist(ObjectInfo obj) {
        return Math.sqrt(Math.pow(obj.getX() - this.x, 2.0) + Math.pow(obj.getY() - this.y, 2.0));
    }

    public void parseSeeInfo(String info) {
        this.seeInfoParser.setInfo(info);
        this.seeInfoParser.parseInfo();
    }

    public void parseBodyInfo(String info) {
        this.bodyInfoParser.setInfo(info);
        this.bodyInfoParser.parseInfo();
    }

    public void parseHearInfo(String info) {
        this.hearInfoParser.setInfo(info);
        this.hearInfoParser.parseInfo();
    }

    public void updateBodyInfo() {
        this.bodyTime = this.bodyInfoParser.getTime();
        this.angleWidth = this.bodyInfoParser.getAngleWidth();
        this.quality = this.bodyInfoParser.getQuality();
        this.stamina = this.bodyInfoParser.getStamina();
        this.effort = this.bodyInfoParser.getEffort();
        this.speed = this.bodyInfoParser.getSpeed();
        this.headAngle = this.bodyInfoParser.getHeadAngle();
        this.kickCount = this.bodyInfoParser.getKickCount();
        this.dashCount = this.bodyInfoParser.getDashCount();
        this.turnCount = this.bodyInfoParser.getTurnCount();
        this.sayCount = this.bodyInfoParser.getSayCount();
        this.turnNeckCount = this.bodyInfoParser.getTurnNeckCount();
        this.calcV();
        if (this.bodyTime > this.seeTime) {
            this.x += this.vx / 0.4;
            this.y += this.vy / 0.4;
        }
        if (this.nextBodyAbsDir != -999.0) {
            this.bodyFaceDir = Generic.normDir(this.bodyFaceDir + this.nextBodyAbsDir);
            this.ball.adjustBallDir(this.nextBodyAbsDir);
            this.nextBodyAbsDir = -999.0;
        }
        if (this.nextHeadRelDir != -999.0) {
            this.ball.adjustBallDir(this.nextHeadRelDir);
            this.headFaceDir = Generic.normDir(this.headFaceDir + this.nextHeadRelDir);
            this.nextHeadRelDir = -999.0;
        }
        if (this.nextHeadAbsDir != -999.0) {
            this.headFaceDir = Generic.normDir(this.headFaceDir + this.nextHeadAbsDir);
            this.nextHeadAbsDir = -999.0;
        }
    }

    public void updateSeeInfo() {
        this.prevSeeTime = this.seeTime;
        this.seeTime = this.seeInfoParser.getTime();
        if (this.seeTime > this.bodyTime) {
            if (this.nextHeadRelDir != -999.0) {
                this.headAngle += this.nextHeadRelDir;
            }
            this.nextHeadAbsDir = -999.0;
            this.nextHeadRelDir = -999.0;
            this.nextBodyAbsDir = -999.0;
        }
        this.calcFaceDir();
        this.calcPos();
        if (this.seeInfoParser.hasBallInfo()) {
            this.knowsBallInfo = true;
            this.ballShadow = this.ball;
            this.ball = this.seeInfoParser.getBallInfo();
            this.ball.calcPos(this.x, this.y, this.headFaceDir);
            if (this.ball.hasChangeInfo()) {
                this.ball.calcRelVVH();
                this.ball.calcRelVXY(this.headFaceDir);
                if (this.lastUpdateEtcTime == this.seeTime) {
                    this.ball.calcV(this.pvx, this.pvy);
                } else {
                    this.ball.calcV(this.vx, this.vy);
                }
                if (this.getBallDist() < 1.085) {
                    this.ball.setVX(this.ballShadow.getVX());
                    this.ball.setVY(this.ballShadow.getVY());
                    this.ball.setAX(this.ballShadow.getAX());
                    this.ball.setAY(this.ballShadow.getAY());
                }
            } else {
                this.ball.setVX(this.ballShadow.getVX());
                this.ball.setVY(this.ballShadow.getVY());
            }
        } else {
            this.knowsBallInfo = false;
        }
        this.updatePlayerTable();
        this.pHeadFaceDir = this.headFaceDir;
    }

    public void updatePlayerTable() {
        int playerNum = this.seeInfoParser.getPlayerNum();
        this.playerTable.makeShadows();
        int i = 0;
        while (i < playerNum) {
            PlayerInfo player = this.seeInfoParser.getPlayerInfo(i);
            player.calcPos(this.x, this.y, this.headFaceDir);
            String tname = player.getTeamname();
            int uNum = player.getUniformNum();
            if (tname.equals("")) {
                this.playerTable.addUnknownPlayer(player);
            } else if (tname.equals(this.teamname)) {
                if (uNum != 0) {
                    this.playerTable.setTeammateWithUNum(player, uNum);
                } else {
                    this.playerTable.addTeammate(player);
                }
            } else if (uNum != 0) {
                this.playerTable.setOpponentWithUNum(player, uNum);
            } else {
                this.playerTable.addOpponent(player);
            }
            ++i;
        }
        this.playerTable.classifyUnknownPlayers(this.seeTime - this.prevSeeTime, this.x, this.y, this.headFaceDir, this.angleWidth);
    }

    public void updateHearInfo() {
        block12: {
            block10: {
                block13: {
                    block11: {
                        int playmodeOld = this.playmode;
                        this.hearTime = this.hearInfoParser.getTime();
                        if (!this.hearInfoParser.fromReferee()) break block10;
                        this.playmode = this.hearInfoParser.getPlaymode();
                        if (this.playmode != playmodeOld && this.playmode != 13) {
                            this.strategyTable.refresh();
                        }
                        if (this.playmode != 19) break block11;
                        this.ourPoint = this.hearInfoParser.getOurPoint();
                        break block12;
                    }
                    if (this.playmode != 20) break block13;
                    this.opponentsPoint = this.hearInfoParser.getOpponentsPoint();
                    break block12;
                }
                if (this.playmode != 1 && this.playmode != 2) break block12;
                this.ball.setX(0.0);
                this.ball.setY(0.0);
                break block12;
            }
            if (this.hearInfoParser.fromTeammate()) {
                String message = this.hearInfoParser.getMessage();
                STokenizer tokenizer = new STokenizer(message);
                while (tokenizer.hasMoreSTokens()) {
                    String token = tokenizer.nextSToken();
                    STokenizer subTokenizer = new STokenizer(token);
                    if ((token = subTokenizer.nextSToken()).equals("ball")) {
                        int t = Integer.valueOf(subTokenizer.nextSToken());
                        if (t - this.ball.getTime() <= 0) continue;
                        this.ball.setTime(t);
                        this.ball.setX(Double.valueOf(subTokenizer.nextSToken()));
                        this.ball.setY(Double.valueOf(subTokenizer.nextSToken()));
                        this.ball.setVX(Double.valueOf(subTokenizer.nextSToken()));
                        this.ball.setVY(Double.valueOf(subTokenizer.nextSToken()));
                        this.ball.setAX(Double.valueOf(subTokenizer.nextSToken()));
                        this.ball.setAY(Double.valueOf(subTokenizer.nextSToken()));
                        this.ball.setCertainty(1.0);
                        int timeDiff = this.hearTime - this.ball.getTime();
                        int i = 0;
                        while (i < timeDiff) {
                            this.ball.calcNextState();
                            ++i;
                        }
                        continue;
                    }
                    if (!token.equals("strategy")) continue;
                    this.strategyFlag = false;
                    String sName = subTokenizer.nextSToken();
                    int unum = Integer.valueOf(subTokenizer.nextSToken());
                    String sType = subTokenizer.nextSToken();
                    this.strategyTable.setPlayerStrategy(unum, sName, sType);
                    if (!sType.equals("plan")) continue;
                    this.strategyFlag = true;
                    this.planner = unum;
                    this.planTime = this.hearTime;
                }
            } else if (this.hearInfoParser.fromCoach()) {
                String message = this.hearInfoParser.getMessage();
                STokenizer tokenizer = new STokenizer(message);
                while (tokenizer.hasMoreSTokens()) {
                    String token = tokenizer.nextSToken();
                    STokenizer subTokenizer = new STokenizer(token);
                    if ((token = subTokenizer.nextSToken()).equals("Pos")) {
                        int unum = Integer.valueOf(subTokenizer.nextSToken());
                        if (unum != this.uniformNum) continue;
                        this.ctStX = Double.valueOf(subTokenizer.nextSToken());
                        this.ctStY = Double.valueOf(subTokenizer.nextSToken());
                        this.ctSdX = Double.valueOf(subTokenizer.nextSToken());
                        this.ctSdY = Double.valueOf(subTokenizer.nextSToken());
                        this.stdPosChanged = true;
                        System.out.println("uNum : " + this.uniformNum + " StartPos Change : " + this.ctStX + "," + this.ctStY + " StdPos Change : " + this.ctSdX + "," + this.ctSdY);
                        continue;
                    }
                    if (token.equals("SR")) {
                        int unum = Integer.valueOf(subTokenizer.nextSToken());
                        if (unum != this.uniformNum) continue;
                        String sName = subTokenizer.nextSToken();
                        String eval = subTokenizer.nextSToken();
                        this.evalSRFlag = true;
                        continue;
                    }
                    if (!token.equals("GK")) continue;
                    this.ctmyX = Double.valueOf(subTokenizer.nextSToken());
                    this.ctmyY = Double.valueOf(subTokenizer.nextSToken());
                    this.ctkX = Double.valueOf(subTokenizer.nextSToken());
                    this.ctkY = Double.valueOf(subTokenizer.nextSToken());
                    this.freekickPosChanged = true;
                }
            }
        }
    }

    public void updateByMove(double X, double Y) {
        this.x = X;
        this.y = Y;
        this.vx = 0.0;
        this.vy = 0.0;
    }

    public void updateByKick(double power, double dir) {
        if (this.getBallDist() <= 1.085) {
            double adir = Generic.normDir(this.bodyFaceDir + dir);
            double a = power * 0.016 * (1.0 - 0.25 * Math.abs(Generic.normDir(this.getAbsDir(this.ball) - this.bodyFaceDir)) / 180.0 - 0.25 * (this.getBallDist() - 0.3 - 0.085) / 0.7);
            this.ball.setAX(a * Math.cos(Generic.digToRad(adir)));
            this.ball.setAY(a * Math.sin(Generic.digToRad(adir)));
        }
    }

    public void updateByDash(double power) {
        if (power > this.stamina) {
            power = this.stamina;
        }
        this.stamina -= power;
        this.ax = (power *= 0.006) * Math.cos(Generic.digToRad(this.bodyFaceDir));
        this.ay = power * Math.sin(Generic.digToRad(this.bodyFaceDir));
    }

    public void updateByTurn(double moment) {
        double actualAngle;
        this.nextBodyAbsDir = actualAngle = moment / (1.0 + 5.0 * this.speed);
        this.nextHeadAbsDir = actualAngle;
    }

    public void updateByTurnNeck(double angle) {
        this.nextHeadRelDir = angle;
        if (this.nextHeadRelDir >= 90.0) {
            this.nextHeadRelDir = 90.0;
        } else if (this.nextHeadRelDir <= -90.0) {
            this.nextHeadRelDir = -90.0;
        }
    }

    public void updateEtc() {
        int i = 5 - 1;
        while (i > 0) {
            this.pux[i] = this.pux[i - 1];
            this.puy[i] = this.puy[i - 1];
            --i;
        }
        this.pux[0] = this.ux;
        this.puy[0] = this.uy;
        this.ux = this.vx + this.ax;
        this.uy = this.vy + this.ay;
        this.pvx = this.vx;
        this.pvy = this.vy;
        this.ax = 0.0;
        this.ay = 0.0;
        this.vx = this.ux * 0.4;
        this.vy = this.uy * 0.4;
        this.pBallVX = this.ball.getVX();
        this.pBallVY = this.ball.getVY();
        this.strategyTable.updateStrategyTable();
        this.strategyNextState();
        this.lastUpdateEtcTime = this.bodyTime;
        this.playerTable.updatePlayerTable();
        if (this.ball.getTime() < this.lastUpdateEtcTime) {
            this.ball.calcNextState();
            if (this.getBallDist() < 0.3) {
                this.ball.setVX(this.ball.getVX() * 0.1);
                this.ball.setVY(this.ball.getVY() * 0.1);
                double ballDir = this.getAbsDir(this.ball);
                this.ball.setX(this.x + 0.385 * Math.cos(Generic.digToRad(ballDir)));
                this.ball.setY(this.y + 0.385 * Math.sin(Generic.digToRad(ballDir)));
            }
        }
    }

    public int getBodyTime() {
        return this.bodyTime;
    }

    public int getPlaymode() {
        return this.playmode;
    }

    public double getBodyFaceDir() {
        if (this.nextBodyAbsDir != -999.0) {
            return Generic.normDir(this.bodyFaceDir + this.nextBodyAbsDir);
        }
        return this.bodyFaceDir;
    }

    public double getHeadAngle() {
        if (this.nextHeadRelDir != -999.0) {
            return Generic.normDir(this.headAngle + this.nextHeadRelDir);
        }
        return this.headAngle;
    }

    public double getHeadFaceDir() {
        if (this.nextHeadAbsDir != -999.0) {
            return Generic.normDir(this.headFaceDir + this.nextHeadAbsDir);
        }
        return this.headFaceDir;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getVX() {
        return this.vx;
    }

    public double getVY() {
        return this.vy;
    }

    public double getStamina() {
        return this.stamina;
    }

    public double getEffort() {
        return this.effort;
    }

    public boolean isKickable() {
        double margin = 0.1;
        return this.getBallDist() <= 1.085 - margin;
    }

    public boolean isKickable2() {
        double margin = 0.3;
        return this.getBallDist() <= 1.085 - margin;
    }

    public boolean isCatchable() {
        return Generic.DIST(this.x, this.y, this.ball.getX(), this.ball.getY()) <= 2.0;
    }

    public boolean hasBallInfo() {
        if (this.ball.getCertainty() > 0.5) {
            this.searchFlag = 0;
            return true;
        }
        return false;
    }

    public double getBallCertainty() {
        return this.ball.getCertainty();
    }

    public double getBallX() {
        return this.ball.getX();
    }

    public double getBallY() {
        return this.ball.getY();
    }

    public double getBallVX() {
        return this.ball.getVX();
    }

    public double getBallVY() {
        return this.ball.getVY();
    }

    public double getBallDir() {
        return Generic.normDir(this.getAbsDir(this.ball) - this.bodyFaceDir);
    }

    public double getAbsBallDir() {
        return this.getAbsDir(this.ball);
    }

    public double getBallDist() {
        return Generic.DIST(this.x, this.y, this.ball.getX(), this.ball.getY());
    }

    public String getBallString() {
        return this.ball.toStringBallInfo();
    }

    public double getAbsGoalDir() {
        double absGoalDir = 57.29577951308232 * Math.atan2(0.0 - this.y, 52.5 - this.x);
        return absGoalDir;
    }

    public double getGoalDist() {
        double goalX = 52.5;
        double goalY = 0.0;
        return Math.sqrt((goalX - this.x) * (goalX - this.x) + (goalY - this.y) * (goalY - this.y));
    }

    public boolean needToChaseBall(int n) {
        return this.playerTable.getOrderFrom(this.ball.getPredX(20), this.ball.getPredY(20), this.x, this.y) <= n;
    }

    public boolean needToMark(double oppX, double oppY, int n) {
        return this.playerTable.getOrderFrom(oppX, oppY, this.x, this.y) <= n;
    }

    public boolean onThePos(double X, double Y) {
        double margin = 1.0;
        return Math.sqrt(Math.pow(X - this.x, 2.0) + Math.pow(Y - this.y, 2.0)) < margin;
    }

    public boolean inPenaltyArea() {
        return this.x <= -36.0 && Math.abs(this.y) <= 20.2;
    }

    public boolean isBallInPenaltyArea(int t) {
        return this.ball.getPredX(t) <= -36.0 && Math.abs(this.ball.getPredY(t)) <= 16.2;
    }

    public double getDirOfThePos(double X, double Y) {
        double absDir = 57.29577951308232 * Math.atan2(Y - this.y, X - this.x);
        return Generic.normDir(absDir - this.bodyFaceDir);
    }

    public double getDistOfThePos(double X, double Y) {
        return Math.sqrt(Math.pow(X - this.x, 2.0) + Math.pow(Y - this.y, 2.0));
    }

    public double getPredBallDist(int t) {
        return Math.sqrt(Math.pow(this.ball.getPredX(t) - this.x, 2.0) + Math.pow(this.ball.getPredY(t) - this.y, 2.0));
    }

    public double getPredBallDir(int t) {
        return Generic.normDir(57.29577951308232 * Math.atan2(this.ball.getPredY(t) - this.y, this.ball.getPredX(t) - this.x) - this.getBodyFaceDir());
    }

    public double getMovableDist(int t, double power) {
        double dist = 0.0;
        double V = 0.0;
        int i = 0;
        while (i < t) {
            dist = dist + V + power * 0.006;
            V *= 0.4;
            ++i;
        }
        return dist;
    }

    public double getPredBallX(int t) {
        return this.ball.getPredX(t);
    }

    public double getPredBallY(int t) {
        return this.ball.getPredY(t);
    }

    public double getPredBallVX(int t) {
        return this.ball.getPredVX(t);
    }

    public boolean adjustDirToAvoidPlayer(double dist, NSobject dir) {
        double margin = 50.0;
        int playerNum = this.seeInfoParser.getPlayerNum();
        int i = 0;
        while (i < playerNum) {
            PlayerInfo player = this.seeInfoParser.getPlayerInfo(i);
            player.calcPos(this.x, this.y, this.headFaceDir);
            double playerDir = Generic.normDir(this.getAbsDir(player) - this.bodyFaceDir);
            double playerDist = Generic.DIST(this.x, this.y, player.getX(), player.getY());
            if (playerDist < dist && playerDist < 5.0 && Math.abs(Generic.normDir(playerDir - dir.getNS())) < margin / playerDist) {
                if (Generic.normDir(playerDir - dir.getNS()) >= 0.0) {
                    dir.setNS(playerDir - margin / playerDist);
                } else {
                    dir.setNS(playerDir + margin / playerDist);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean adjustDirToAvoidBall(double dist, NSobject dir) {
        double margin = 35.0;
        double ballDir = Generic.normDir(this.getAbsDir(this.ball) - this.bodyFaceDir);
        double ballDist = this.getBallDist();
        if (ballDist < dist && ballDist < 3.0 && Math.abs(Generic.normDir(ballDir - dir.getNS())) < margin / ballDist) {
            if (Generic.normDir(ballDir - dir.getNS()) >= 0.0) {
                dir.setNS(ballDir - margin / ballDist);
            } else {
                dir.setNS(ballDir + margin / ballDist);
            }
            return true;
        }
        return false;
    }

    public double evalLine(double X, double Y) {
        return this.playerTable.evalLine(this.x, this.y, X, Y);
    }

    public double getOffsideLine() {
        return this.playerTable.getOffsideLine(this.ball.getX());
    }

    public double getPosOfReceiver(double dir, double dirDiff, double dist, Point recXY) {
        return this.playerTable.getPosOfReceiver(dir, dirDiff, dist, this.x, this.y, recXY);
    }

    public double getPosOfReceiver(double dir, double dirDiff, double dist, Point recXY, int p) {
        return this.playerTable.getPosOfReceiver(dir, dirDiff, dist, this.x, this.y, recXY, p);
    }

    public double getPosOfNearestOpponent(double dir, double dirDiff, double dist, Point oppXY) {
        return this.playerTable.getPosOfNearestOpponent(dir, dirDiff, dist, this.x, this.y, oppXY);
    }

    public int getOurPoint() {
        return this.ourPoint;
    }

    public int getOpponentsPoint() {
        return this.opponentsPoint;
    }

    public double getDirOfOpenSpace(double dir, double dirDiff, double dist, double interval, NSobject openDir) {
        double tmpValue;
        double minValue = 1000.0;
        int n = (int)(dirDiff / interval) + 1;
        double tmpDir = dir;
        int i = 0;
        while (i < n) {
            if (!(Math.abs(this.y + dist * Math.sin(Generic.digToRad(tmpDir))) > 34.0)) {
                tmpValue = this.evalLine(this.x + dist * Math.cos(Generic.digToRad(tmpDir)), this.y + dist * Math.sin(Generic.digToRad(tmpDir)));
                if (tmpValue < minValue) {
                    minValue = tmpValue;
                    openDir.setNS(tmpDir);
                }
                tmpDir = Generic.normDir(tmpDir + interval);
            }
            ++i;
        }
        tmpDir = dir;
        i = 0;
        while (i < n) {
            if (!(Math.abs(this.y + dist * Math.sin(Generic.digToRad(tmpDir))) > 34.0) && (tmpValue = this.evalLine(this.x + dist * Math.cos(Generic.digToRad(tmpDir)), this.y + dist * Math.sin(Generic.digToRad(tmpDir)))) < minValue) {
                minValue = tmpValue;
                openDir.setNS(tmpDir);
            }
            ++i;
            tmpDir = Generic.normDir(tmpDir - interval);
        }
        tmpDir = dir;
        tmpValue = this.evalLine(this.x + dist * Math.cos(Generic.digToRad(tmpDir)), this.y + dist * Math.sin(Generic.digToRad(tmpDir)));
        if (tmpValue < minValue) {
            minValue = tmpValue;
            openDir.setNS(tmpDir);
        }
        return minValue;
    }

    public String getSelfString() {
        StringBuffer selfString = new StringBuffer("(player ");
        selfString.append(this.bodyTime).append(" ").append(this.teamname).append(" ").append(this.uniformNum).append(" ").append(this.x).append(" ").append(this.y).append(")");
        return selfString.toString();
    }

    public double getTeammateX(int unum) {
        return this.playerTable.getTeammateX(unum);
    }

    public void getPosOfOpponentsForward(Point oppXY) {
        this.playerTable.getPosOfOpponentsForward(oppXY);
    }

    public String getOpponentsForwardString() {
        Point oppXY = new Point();
        this.playerTable.getPosOfOpponentsForward(oppXY);
        StringBuffer oppForwardString = new StringBuffer("(player ");
        oppForwardString.append(this.bodyTime).append(" ").append("opponent").append(" ").append(oppXY.getPointX()).append(" ").append(oppXY.getPointY()).append(")");
        return oppForwardString.toString();
    }

    public double getDirOfClearSpace(double dir, double dirDiff, double dist, double interval, NSobject openDir) {
        double tmpValue;
        double minValue = 1000.0;
        int n = (int)(dirDiff / interval) + 1;
        double tmpDir = dir;
        if (this.y >= 0.0) {
            int i = 0;
            while (i < n) {
                if (!(Math.abs(this.y + dist * Math.sin(Generic.digToRad(tmpDir))) > 34.0) && (tmpValue = this.evalLine(this.x + dist * Math.cos(Generic.digToRad(tmpDir)), this.y + dist * Math.sin(Generic.digToRad(tmpDir)))) < minValue) {
                    minValue = tmpValue;
                    openDir.setNS(tmpDir);
                }
                ++i;
                tmpDir = Generic.normDir(tmpDir + interval);
            }
        } else {
            int i = 0;
            while (i < n) {
                if (!(Math.abs(this.y + dist * Math.sin(Generic.digToRad(tmpDir))) > 34.0) && (tmpValue = this.evalLine(this.x + dist * Math.cos(Generic.digToRad(tmpDir)), this.y + dist * Math.sin(Generic.digToRad(tmpDir)))) < minValue) {
                    minValue = tmpValue;
                    openDir.setNS(tmpDir);
                }
                ++i;
                tmpDir = Generic.normDir(tmpDir - interval);
            }
        }
        tmpDir = dir;
        tmpValue = this.evalLine(this.x + dist * Math.cos(Generic.digToRad(tmpDir)), this.y + dist * Math.sin(Generic.digToRad(tmpDir)));
        if (tmpValue < minValue) {
            minValue = tmpValue;
            openDir.setNS(tmpDir);
        }
        return minValue;
    }

    public double getDirOfChangeSpace(double dir, double dirDiff, double dist, double interval, NSobject openDir) {
        double tmpValue;
        double minValue = 1000.0;
        int n = (int)(dirDiff / interval) + 1;
        double tmpDir = dir;
        if (this.y < 0.0) {
            int i = 0;
            while (i < n) {
                if (!(Math.abs(this.y + dist * Math.sin(Generic.digToRad(tmpDir))) > 34.0) && (tmpValue = this.evalLine(this.x + dist * Math.cos(Generic.digToRad(tmpDir)), this.y + dist * Math.sin(Generic.digToRad(tmpDir)))) < minValue) {
                    minValue = tmpValue;
                    openDir.setNS(tmpDir);
                }
                ++i;
                tmpDir = Generic.normDir(tmpDir + interval);
            }
        } else {
            int i = 0;
            while (i < n) {
                if (!(Math.abs(this.y + dist * Math.sin(Generic.digToRad(tmpDir))) > 34.0) && (tmpValue = this.evalLine(this.x + dist * Math.cos(Generic.digToRad(tmpDir)), this.y + dist * Math.sin(Generic.digToRad(tmpDir)))) < minValue) {
                    minValue = tmpValue;
                    openDir.setNS(tmpDir);
                }
                ++i;
                tmpDir = Generic.normDir(tmpDir - interval);
            }
        }
        tmpDir = dir;
        tmpValue = this.evalLine(this.x + dist * Math.cos(Generic.digToRad(tmpDir)), this.y + dist * Math.sin(Generic.digToRad(tmpDir)));
        if (tmpValue < minValue) {
            minValue = tmpValue;
            openDir.setNS(tmpDir);
        }
        return minValue;
    }

    public double getSideChangeReceiver(double dir, double dirDiff, double dist, Point recXY) {
        return this.playerTable.getSideChangeReceiver(dir, dirDiff, dist, this.x, this.y, recXY);
    }

    public boolean parseSideChange() {
        return this.playerTable.parseSide(this.ball.getY());
    }

    public int forwardFW(double dir, double dirDiff, double dist) {
        return this.playerTable.forwardFW(dir, dirDiff, dist, this.x, this.y);
    }

    public double getAbsTopPostDir() {
        double absTopPostDir = 57.29577951308232 * Math.atan2(7.01 - this.y, 52.5 - this.x);
        return absTopPostDir;
    }

    public double getShootAngle() {
        double absTopPostDir = 57.29577951308232 * Math.atan2(7.01 - this.y, 52.5 - this.x);
        double absDdownPostDir = 57.29577951308232 * Math.atan2(-7.01 - this.y, 52.5 - this.x);
        return (absTopPostDir - absDdownPostDir) / 2.0;
    }

    public boolean hasPlayerInfo(int unum) {
        return this.playerTable.getTeammateCertainty(unum) > 0.5;
    }

    public boolean isBallTrap() {
        return this.ball.getRelV() < 0.2 && this.getAbsDir(this.ball) < 100.0;
    }

    public double getAbsPredDir(int t, ObjectInfo obj) {
        return 57.29577951308232 * Math.atan2(obj.getPredY(t) - this.y, obj.getPredX(t) - this.x);
    }

    public double getBallRelV() {
        return this.ball.getRelV();
    }

    public double getPredX(int t) {
        double predX = this.x;
        double predVX = this.vx;
        int i = 0;
        while (i < t) {
            predX += predVX;
            predVX *= 0.4;
            ++i;
        }
        return predX;
    }

    public double getPredY(int t) {
        double predY = this.y;
        double predVY = this.vy;
        int i = 0;
        while (i < t) {
            predY += predVY;
            predVY *= 0.4;
            ++i;
        }
        return predY;
    }

    public boolean getFreeFlag(double dist) {
        double width = this.angleWidth.equals("normal") ? 45.0 : (this.angleWidth.equals("wide") ? 90.0 : 22.0);
        return this.playerTable.checkMarkedOpponent(this.headFaceDir, width, dist, this.x, this.y);
    }

    public boolean hasCoachPos() {
        return this.stdPosChanged;
    }

    public void setCoachPosFlag(boolean flag) {
        this.stdPosChanged = flag;
    }

    public double getCoachStdPosX() {
        return this.ctSdX;
    }

    public double getCoachStdPosY() {
        return this.ctSdY;
    }

    public double getCoachStartPosX() {
        return this.ctStX;
    }

    public double getCoachStartPosY() {
        return this.ctStY;
    }

    public boolean hasCoachGKFreekickPos() {
        return this.freekickPosChanged;
    }

    public void setCoachPosGKFreeKickFlag(boolean flag) {
        this.freekickPosChanged = flag;
    }

    public double getCoachGKFreekickPosX() {
        return this.ctkX;
    }

    public double getCoachGKFreekickPosY() {
        return this.ctkY;
    }

    public double getCoachGKFreekickMyPosX() {
        return this.ctmyX;
    }

    public double getCoachGKFreekickMyPosY() {
        return this.ctmyY;
    }

    public double getMovableDist(int t, double power, double dir) {
        double dist = 0.0;
        double u = 0.0;
        double V = this.speed * Math.cos(Generic.digToRad(dir));
        int i = 0;
        while (i < t) {
            u = V + power * 0.006;
            if (u > 1.0) {
                u = 1.0;
            }
            dist += u;
            V = 0.4 * u;
            ++i;
        }
        return dist;
    }

    public double getDirOfThePos2(double X, double Y) {
        double absDir = 57.29577951308232 * Math.atan2(Y - this.y, X - this.x);
        return absDir;
    }

    public boolean getOpponentEnableShot() {
        double boalXX = this.ball.getX();
        double boalYY = this.ball.getY();
        int i = 0;
        while (i < 11) {
            if (Generic.DIST(this.playerTable.getOpponetsPlayer(i).getX(), this.playerTable.getOpponetsPlayer(i).getY(), boalXX, boalYY) < 2.17) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean getNearSide() {
        double boalXX = this.ball.getX();
        double boalYY = this.ball.getY();
        int i = 0;
        while (i < 11) {
            if (Generic.DIST(this.playerTable.getOpponetsPlayer(i).getX(), this.playerTable.getOpponetsPlayer(i).getY(), boalXX, boalYY) < Generic.DIST(this.x, this.y, boalXX, boalYY)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getMyUnum() {
        return this.uniformNum;
    }

    public String getMyAngleWidth() {
        return this.angleWidth;
    }

    public String getTurnStartDir() {
        if (this.side.equals("l")) {
            return "Right";
        }
        return "Left";
    }

    public String getMySide() {
        return this.side;
    }

    public double getPredBallDir2(int t) {
        return Generic.normDir(57.29577951308232 * Math.atan2(this.ball.getPredY(t) - this.y, this.ball.getPredX(t) - this.x));
    }

    public boolean getOpponentShot() {
        return this.ball.getV() > 1.2;
    }

    public int getSeeTime() {
        return this.seeTime;
    }

    public boolean judgeCriticalCase() {
        boolean judge = false;
        double boalXX = this.ball.getX();
        double boalYY = this.ball.getY();
        double enableShotX = 999.0;
        double enableShotY = 999.0;
        if (this.getOpponentEnableShot()) {
            int i = 0;
            while (i < 11) {
                if (Generic.DIST(this.playerTable.getOpponetsPlayer(i).getX(), this.playerTable.getOpponetsPlayer(i).getY(), boalXX, boalYY) < 2.17) {
                    enableShotX = this.playerTable.getOpponetsPlayer(i).getX();
                    enableShotY = this.playerTable.getOpponetsPlayer(i).getY();
                }
                ++i;
            }
            if (enableShotX != 999.0 || enableShotY != 999.0) {
                judge = true;
                i = 0;
                while (i < 11) {
                    if (this.playerTable.getTeammate(i).getX() < enableShotX && Math.abs(this.playerTable.getTeammate(i).getY() - enableShotY) < 5.0) {
                        judge = false;
                    }
                    ++i;
                }
            }
        }
        return judge;
    }

    public double getNearestOpponetDist() {
        double min = 1000.0;
        int i = 0;
        while (i < 11) {
            if (Generic.DIST(this.playerTable.getOpponetsPlayer(i).getX(), this.playerTable.getOpponetsPlayer(i).getY(), this.x, this.y) < min) {
                min = Generic.DIST(this.playerTable.getOpponetsPlayer(i).getX(), this.playerTable.getOpponetsPlayer(i).getY(), this.x, this.y);
            }
            ++i;
        }
        return min;
    }

    public double getPredBallDirForGoalie(int t) {
        return Generic.normDir(57.29577951308232 * Math.atan2(this.ball.getPredY(t) - this.y + this.vy * 0.4, this.ball.getPredX(t) - this.x + this.vx * 0.4) - this.getBodyFaceDir());
    }

    public boolean adjustDirToAvoidPlayer(double X, double Y, double dist, NSobject dir) {
        double margin = 50.0;
        int playerNum = this.seeInfoParser.getPlayerNum();
        int i = 0;
        while (i < playerNum) {
            PlayerInfo player = this.seeInfoParser.getPlayerInfo(i);
            player.calcPos(this.x, this.y, this.headFaceDir);
            double playerDir = Generic.normDir(this.getAbsDir(player) - this.bodyFaceDir);
            double playerDist = Generic.DIST(this.x, this.y, player.getX(), player.getY());
            double playerToBall = Generic.DIST(X, Y, player.getX(), player.getY());
            if (playerDist < dist && playerDist < 5.0 && playerToBall < dist && Math.abs(Generic.normDir(playerDir - dir.getNS())) < margin / playerDist) {
                if (Generic.normDir(playerDir - dir.getNS()) >= 0.0) {
                    dir.setNS(playerDir - margin / playerDist);
                } else {
                    dir.setNS(playerDir + margin / playerDist);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasSelfStrategy() {
        return this.strategyCertainty > 0.5;
    }

    public double getReceivePartner(String S, String tp, double dir, double dirDiff, double dist, Point recXY) {
        return this.strategyTable.getReceivePartner(S, tp, dir, dirDiff, dist, this.x, this.y, recXY);
    }

    public double getReceivePlanner(String S, double goalDir, double dirDiff, double dist, double interval, NSobject openDir) {
        PlayerInfo planner;
        double value = 1000.0;
        int uNum = this.strategyTable.getStrategyPartner(S);
        if (uNum != 0 && (planner = this.playerTable.getTeammateInfo(uNum)).getCertainty() > 0.1) {
            double tx = planner.getX();
            double ty = planner.getY();
            double tdir = 57.29577951308232 * Math.atan2(ty - this.y, tx - this.x);
            double tdist = Generic.DIST(this.x, this.y, tx, ty);
            if (tdist <= dist) {
                double pathAngle = (tdir - goalDir) / 2.0;
                value = this.getDirOfOpenSpace(goalDir + pathAngle, dirDiff, dist, interval, openDir);
            }
        }
        return value;
    }

    public void updateStrategyTable() {
        this.strategyTable.updateStrategyTable();
        this.strategyCertainty -= 0.05;
        if (this.strategyCertainty < 0.0) {
            this.strategyCertainty = 0.0;
            this.strategy = "private";
            this.strategyType = "show";
        }
    }

    public void parseStrategy(String S) {
    }

    public void parseHearStrategy() {
        System.out.println(" parse Hear Strategy ok? ");
    }

    public void setSelfStrategy(String S, String tp) {
        this.strategy = S;
        this.strategyType = tp;
        this.strategyCertainty = 1.0;
    }

    public int getStrategyPartner(String S) {
        return this.strategyTable.getStrategyPartner(S);
    }

    public String getSelfStrategy() {
        return this.strategy;
    }

    public String getSelfSType() {
        return this.strategyType;
    }

    public double getStrategyCertainty() {
        return this.strategyCertainty;
    }

    public boolean getStrategyFlag() {
        return this.strategyFlag;
    }

    public String getStrategyPlan() {
        return this.strategyTable.getPlayerStrategy(this.planner);
    }

    public int getSPlanner() {
        return this.planner;
    }

    public void strategyNextState() {
        this.strategyCertainty -= 0.05;
        if (this.strategyCertainty < 0.0) {
            this.strategyCertainty = 0.0;
            this.strategy = "private";
            this.strategyType = "show";
        }
    }

    public String getStrategyString() {
        StringBuffer strBuff = new StringBuffer("(strategy ");
        strBuff.append(this.strategy).append(" ").append(this.uniformNum).append(" ").append(this.strategyType).append(" ").append(this.x).append(" ").append(this.y).append(")");
        return strBuff.toString();
    }

    public double searchBall() {
        if (this.searchFlag == 0) {
            if (this.getBallCertainty() > 0.1) {
                double angle = this.getBallDir();
                if (angle > 0.0) {
                    this.searchFlag = 1;
                    return 75.0;
                }
                this.searchFlag = -1;
                return -75.0;
            }
            this.searchFlag = 1;
            return 75.0;
        }
        if (this.searchFlag == 1) {
            return 75.0;
        }
        return -75.0;
    }
}

