/*
 * Decompiled with CFR 0.152.
 */
import Analyzer.BallLocationAnalyzer;
import Analyzer.DribbleAnalyzer;
import Analyzer.FormationAnalyzer;
import Analyzer.GoalAnalyzer;
import Analyzer.InterceptAnalyzer;
import Analyzer.KickAnalyzerDontUseFlag;
import Analyzer.MessageSender;
import Analyzer.OneTwoPassAnalyzer;
import Analyzer.OppAttackPatternAnalyzer;
import Analyzer.OurGoalKickAnalyzer;
import Analyzer.PassAnalyzer;
import Analyzer.PlayModeAnalyzer;
import Analyzer.PlayerLocationAnalyzer;
import Analyzer.PosPercentageAnalyzer;
import Analyzer.ShootAnalyzer;
import Analyzer.StaminaAnalyzer;
import Analyzer.StrategyRelayEvaluater;
import GUI.KeiseiGraph;
import Interface.CoachInterface;
import java.awt.Frame;
import java.io.EOFException;
import java.io.IOException;

public class CoachMain
extends CoachInterface {
    KickAnalyzerDontUseFlag ka;
    PlayModeAnalyzer pma;
    PassAnalyzer pa;
    OneTwoPassAnalyzer otpa;
    InterceptAnalyzer ia;
    DribbleAnalyzer da;
    PlayerLocationAnalyzer pla;
    ShootAnalyzer sa;
    GoalAnalyzer ga;
    PosPercentageAnalyzer ppa;
    BallLocationAnalyzer bla;
    OppAttackPatternAnalyzer oapa;
    StaminaAnalyzer staa;
    StrategyRelayEvaluater sre;
    FormationAnalyzer fa;
    KeiseiGraph kg;
    OurGoalKickAnalyzer ogka;
    MessageSender ms;
    Frame f;
    int formation = 0;

    public CoachMain(String host, int port, String myTeamName, int version) {
        super(host, port, myTeamName, version);
    }

    public CoachMain(String host, int port, String myTeamName, int version, int formation) {
        super(host, port, myTeamName, version);
        this.formation = formation;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void run() {
        this.retAck = true;
        while (true) {
            try {
                boolean nextIndex = false;
                String message = this.getMessageFromSoccerServer();
                int ret = this.cmp.parse(message);
                if (ret == 1) {
                    this.bsi.setChanged();
                    this.bsi.notifyObservers(this);
                    System.out.println("Ball is at " + this.bsi.ball.x + " , " + this.bsi.ball.y);
                } else if (ret == 2) {
                    this.pma.analyze();
                }
                if (this.sendMessages.size() != 0 && this.bsi.play_mode != 3 && this.bsi.play_mode != 16 && this.retAck) {
                    this.send_info("(say (" + (String)this.sendMessages.firstElement() + "))");
                    nextIndex = false;
                    this.sendMessages.removeElementAt(0);
                }
            }
            catch (EOFException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                CoachMain.sleep(5L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        String host = "localhost";
        int port = 6002;
        String myTeamName = "Kakitsubata";
        int version = 6;
        int formation = 0;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-h")) {
                if (args[i + 1] != null) {
                    host = args[i + 1].trim();
                } else {
                    System.exit(1);
                }
            } else if (args[i].equals("-t")) {
                if (args[i + 1] != null) {
                    myTeamName = args[i + 1].trim();
                } else {
                    CoachMain.usage();
                    System.exit(1);
                }
            } else if (args[i].equals("-p")) {
                if (args[i + 1] != null) {
                    port = new Integer(args[i + 1].trim());
                } else {
                    CoachMain.usage();
                    System.exit(1);
                }
            } else if (args[i].equals("-v")) {
                if (args[i + 1] != null) {
                    version = new Integer(args[i + 1].trim());
                } else {
                    CoachMain.usage();
                    System.exit(1);
                }
            } else if (args[i].equals("-f")) {
                if (args[i + 1] != null) {
                    formation = new Integer(args[i + 1].trim());
                } else {
                    CoachMain.usage();
                    System.exit(1);
                }
            } else {
                CoachMain.usage();
                System.exit(1);
            }
            i += 2;
        }
        CoachMain cm = new CoachMain(host, port, myTeamName, version, formation);
        cm.init();
        cm.start();
    }

    public static void usage() {
        System.out.println("usage:java CoachMain [option]");
        System.out.println("options");
        System.out.println("-h HOST      (default localhost)");
        System.out.println("-t TEAM_NAME (default Kakitsubata)");
        System.out.println("-p PORT      (default 6002)");
        System.out.println("-v VERSION   (default 6)");
        System.out.println("-f FORMATION (default 0)");
    }
}

