/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Information.BaseSeeInformation;
import Information.PlayerInformation;
import Utility.DPoint;
import Utility.Utility;
import java.util.Observable;

public class PlayerLocationAnalyzer
extends Analyzer {
    BaseSeeInformation bsi;
    double[][] playerDistance = new double[2][11];
    double[][] playerSpeed = new double[2][11];
    AllPlayerPoint pp = new AllPlayerPoint();
    static final int MAX_ARRAY = 6500;
    AllPlayerPoint[] playerPoints = new AllPlayerPoint[6500];
    boolean init = false;
    int time;

    public PlayerLocationAnalyzer(BaseSeeInformation bsi) {
        this.bsi = bsi;
        bsi.addObserver(this);
    }

    public DPoint getPlayerPoint(int time, int side, int unum) {
        if (this.playerPoints[time] == null) {
            return null;
        }
        AllPlayerPoint app = this.playerPoints[time];
        return app.dp[side][unum - 1];
    }

    @Override
    public void update(Observable o, Object arg) {
        this.analyze();
        this.setChanged();
        this.notifyObservers();
    }

    public void analyze() {
        if (!this.init) {
            this.init();
        }
        if (this.bsi.play_mode == 3) {
            this.calcDistance();
        }
        this.copy();
        if (this.time != this.bsi.time) {
            this.copy2();
        }
        this.time = this.bsi.time;
    }

    protected void calcDistance() {
        int i = 0;
        while (i <= 1) {
            int j = 0;
            while (j <= 10) {
                double xx = this.bsi.team[i].player[j].x - this.pp.dp[i][j].x;
                double yy = this.bsi.team[i].player[j].y - this.pp.dp[i][j].y;
                double dist = Math.sqrt(xx * xx + yy * yy);
                double[] dArray = this.playerDistance[i];
                int n = j;
                dArray[n] = dArray[n] + dist;
                this.playerSpeed[i][j] = dist;
                ++j;
            }
            ++i;
        }
    }

    protected void init() {
        this.copy();
        this.time = this.bsi.time;
        this.init = true;
    }

    protected void copy() {
        int i = 0;
        while (i <= 1) {
            int j = 0;
            while (j <= 10) {
                this.pp.dp[i][j].x = this.bsi.team[i].player[j].x;
                this.pp.dp[i][j].y = this.bsi.team[i].player[j].y;
                ++j;
            }
            ++i;
        }
    }

    protected void copy2() {
        AllPlayerPoint ap = new AllPlayerPoint();
        int i = 0;
        while (i <= 1) {
            int j = 0;
            while (j <= 10) {
                if (this.bsi.team[i].player[j].enable != 0) {
                    ap.dp[i][j].x = this.bsi.team[i].player[j].x;
                    ap.dp[i][j].y = this.bsi.team[i].player[j].y;
                }
                ++j;
            }
            ++i;
        }
        this.playerPoints[this.bsi.time] = ap;
    }

    public double getToBallDistance(int side, int unum) {
        return Utility.getDistance(this.bsi.team[side].player[unum - 1].x, this.bsi.team[side].player[unum - 1].y, this.bsi.ball.x, this.bsi.ball.y);
    }

    public double getSpeed(int side, int unum) {
        return this.playerSpeed[side][unum - 1];
    }

    public double getDegAngleToBall(int side, int unum) {
        PlayerInformation player = this.bsi.team[side].player[unum - 1];
        double angle = 57.29577951308232 * Math.atan2(this.bsi.ball.y - player.y, this.bsi.ball.x - player.x);
        return angle;
    }

    protected class AllPlayerPoint {
        public DPoint[][] dp = new DPoint[2][11];

        AllPlayerPoint() {
            int i = 0;
            while (i <= 1) {
                int j = 0;
                while (j <= 10) {
                    this.dp[i][j] = new DPoint();
                    ++j;
                }
                ++i;
            }
        }
    }
}

