/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.Kick;
import Analyzer.KickAnalyzer;
import Analyzer.Pass;
import Analyzer.PlayModeAnalyzer;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;

public class PassAnalyzer
extends Analyzer {
    Vector passVector;
    Vector kickVector;
    boolean continuousPlay = false;
    public static final double MIN_PASS_DISTANCE = 1.0;
    public static boolean VERBOSE = true;

    public PassAnalyzer(KickAnalyzer ka, PlayModeAnalyzer pma) {
        ka.addObserver(this);
        pma.addObserver(this);
        this.kickVector = ka.getKickVector();
        this.passVector = new Vector();
    }

    public Vector getPassVector() {
        return this.passVector;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof PlayModeAnalyzer) {
            PlayModeAnalyzer pma = (PlayModeAnalyzer)o;
            if (pma.getInformation() == 1) {
                this.continuousPlay = false;
            }
        } else if (arg instanceof KickAnalyzer) {
            if (this.continuousPlay) {
                this.analyze();
            } else {
                this.continuousPlay = true;
            }
        }
    }

    public void analyze() {
        double yy;
        double xx;
        double dist;
        int kickSize = this.kickVector.size();
        if (kickSize == 1) {
            return;
        }
        Kick beforeKick = (Kick)this.kickVector.elementAt(kickSize - 2);
        Kick thisKick = (Kick)this.kickVector.elementAt(kickSize - 1);
        if (thisKick.side == beforeKick.side && thisKick.member != beforeKick.member && (dist = (xx = beforeKick.posX - thisKick.posX) * xx + (yy = beforeKick.posY - thisKick.posY) * yy) >= 1.0) {
            Pass pass = new Pass(beforeKick.member, thisKick.member, beforeKick.posX, beforeKick.posY, thisKick.posX, thisKick.posY, beforeKick.time, thisKick.time, thisKick.side);
            this.passVector.addElement(pass);
            this.setChanged();
            this.notifyObservers(pass);
            if (VERBOSE) {
                System.out.println("pass is success kicker:" + beforeKick.member + "  receiver:" + thisKick.member);
            }
        }
    }

    public int getPlayerPass(int unum, int side) {
        int pass = 0;
        Enumeration enu = this.passVector.elements();
        while (enu.hasMoreElements()) {
            Pass p = (Pass)enu.nextElement();
            if (p.getPasserUnum() != unum || p.getSide() != side) continue;
            ++pass;
        }
        return pass;
    }

    public int getTotalPass(short side) {
        int pass = 0;
        Enumeration enu = this.passVector.elements();
        while (enu.hasMoreElements()) {
            Pass p = (Pass)enu.nextElement();
            if (p.getSide() != side) continue;
            ++pass;
        }
        return pass;
    }

    public int getPlayerPass(int unum, int to, int side) {
        int pass = 0;
        Enumeration enu = this.passVector.elements();
        while (enu.hasMoreElements()) {
            Pass p = (Pass)enu.nextElement();
            if (p.getPasserUnum() != unum || p.getReceiverUnum() != to || p.getSide() != side) continue;
            ++pass;
        }
        return pass;
    }

    public int getPlayerPassReceive(int unum, int from, int side) {
        int receive = 0;
        Enumeration enu = this.passVector.elements();
        while (enu.hasMoreElements()) {
            Pass p = (Pass)enu.nextElement();
            if (p.getReceiverUnum() != unum || p.getPasserUnum() != from || p.getSide() != side) continue;
            ++receive;
        }
        return receive;
    }

    public int getTotalPlayerPassReceive(int unum, int side) {
        int receive = 0;
        Enumeration enu = this.passVector.elements();
        while (enu.hasMoreElements()) {
            Pass p = (Pass)enu.nextElement();
            if (p.getReceiverUnum() != unum || p.getSide() != side) continue;
            ++receive;
        }
        return receive;
    }
}

