/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.DribbleAnalyzer;
import Analyzer.InterceptAnalyzer;
import Analyzer.OneTwoPass;
import Analyzer.Pass;
import Analyzer.PassAnalyzer;
import Analyzer.PlayModeAnalyzer;
import Analyzer.PlayerLocationAnalyzer;
import Utility.DPoint;
import Utility.Triangle;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;

public class OneTwoPassAnalyzer
extends Analyzer {
    Vector oneTwoPassVector;
    Vector passVector;
    PlayerLocationAnalyzer pla;
    boolean continuousPlay = false;
    Pass firstPass;
    Pass secondPass;

    public OneTwoPassAnalyzer(PassAnalyzer pa, InterceptAnalyzer ia, DribbleAnalyzer da, PlayModeAnalyzer pma, PlayerLocationAnalyzer pla) {
        pa.addObserver(this);
        ia.addObserver(this);
        da.addObserver(this);
        pma.addObserver(this);
        this.passVector = pa.getPassVector();
        this.pla = pla;
        this.oneTwoPassVector = new Vector();
    }

    public Vector getOneTwoPassVector() {
        return this.oneTwoPassVector;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof PlayModeAnalyzer) {
            PlayModeAnalyzer pma = (PlayModeAnalyzer)o;
            if (pma.getInformation() == 1) {
                this.continuousPlay = false;
            }
        } else if (o instanceof InterceptAnalyzer) {
            this.continuousPlay = false;
        } else if (o instanceof DribbleAnalyzer && this.continuousPlay) {
            DribbleAnalyzer da = (DribbleAnalyzer)o;
            if (da.getCurrentDribbleDistance() >= 1.0) {
                this.continuousPlay = false;
            }
        } else if (o instanceof PassAnalyzer) {
            if (this.firstPass == null) {
                this.firstPass = (Pass)arg;
            } else {
                this.secondPass = (Pass)arg;
                this.analyze();
                this.firstPass = this.secondPass;
            }
        }
    }

    public void analyze() {
        if (this.firstPass.getPasserUnum() != this.secondPass.getReceiverUnum()) {
            return;
        }
        boolean PLAYER_IN_KABEPASS_AREA = false;
        Triangle tri = new Triangle(this.firstPass.passX, this.firstPass.passY, this.firstPass.recvX, this.firstPass.recvY, this.secondPass.recvX, this.secondPass.recvY);
        int oppSide = this.firstPass.getSide() == 0 ? 1 : 0;
        int i = this.firstPass.passTime;
        while (i < this.secondPass.recvTime) {
            int j = 1;
            while (j <= 11) {
                double y;
                double x;
                DPoint dp = this.pla.getPlayerPoint(i, oppSide, j);
                if (dp != null && dp.x != -10000.0 && (PLAYER_IN_KABEPASS_AREA = tri.isInner(x = dp.x, y = dp.y))) break;
                ++j;
            }
            ++i;
        }
        if (PLAYER_IN_KABEPASS_AREA) {
            System.out.println("1-2pass");
            OneTwoPass otPass = new OneTwoPass(this.firstPass, this.secondPass);
            this.oneTwoPassVector.add(otPass);
            this.setChanged();
            this.notifyObservers(this);
        }
    }

    public int getTotal(int side) {
        int result = 0;
        Enumeration enu = this.oneTwoPassVector.elements();
        while (enu.hasMoreElements()) {
            Pass p = ((OneTwoPass)enu.nextElement()).pass1;
            if (side != p.getSide()) continue;
            ++result;
        }
        return result;
    }
}

