/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Information.BaseSeeInformation;
import Utility.DPoint;
import java.util.Observable;

public class BallLocationAnalyzer
extends Analyzer {
    public static final boolean VERBOSE = false;
    BaseSeeInformation bsi;
    DPoint dp = new DPoint();
    boolean init = false;
    int time;
    int[] ballLocation = new int[2];

    public BallLocationAnalyzer(BaseSeeInformation bsi) {
        this.bsi = bsi;
        this.ballLocation[1] = 0;
        this.ballLocation[0] = 0;
        bsi.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.analyze();
    }

    public double getBallPosPercentage(int side) {
        if (this.ballLocation[0] + this.ballLocation[1] == 0) {
            return -1.0;
        }
        return (double)this.ballLocation[side] / (double)(this.ballLocation[0] + this.ballLocation[1]);
    }

    public void analyze() {
        if (!this.init) {
            this.init();
        }
        this.copy();
        if (this.bsi.play_mode == 3) {
            this.calcBallLocationPercentage();
        }
        this.time = this.bsi.time;
    }

    protected void calcDistance() {
    }

    protected void calcBallLocationPercentage() {
        if (this.bsi.ball.x >= 0.0) {
            this.ballLocation[0] = this.ballLocation[0] + 1;
        } else {
            this.ballLocation[1] = this.ballLocation[1] + 1;
        }
    }

    protected void init() {
        this.copy();
        this.time = this.bsi.time;
        this.init = true;
    }

    protected void copy() {
        this.dp.x = this.bsi.ball.x;
        this.dp.y = this.bsi.ball.y;
    }
}

