#ifndef PERFTIMER_H
#define PERFTIMER_H

//using namespace std;
#include <Windows.h>


class PerfTimer {

  public:
    __int64 m_Start;
    __int64 m_Freq;   
    __int64 m_Adjust; // Adjustment time it takes to Start and Stop

	PerfTimer () {
		QueryPerformanceFrequency((LARGE_INTEGER *)&m_Freq); 
	}
  
	~PerfTimer () { }

	void Start() {
		QueryPerformanceCounter((LARGE_INTEGER *)&m_Start);
	}

   
	double Resolution() {
		return 1000000.0/(double)m_Freq;
	}

	double Elapsed() {
		__int64 i;
		QueryPerformanceCounter((LARGE_INTEGER *)&i); 
		m_Start += -i;          // Stopped timer keeps elapsed timer ticks as a negative 
		return (-m_Start * 1000000.0)/(double)m_Freq;
	}

	double getElapsed_setStart() {
		double tmp = Elapsed();
		Start();
		return tmp;
	}

};

#endif