/*
 * Decompiled with CFR 0.152.
 */
package soccorob.si.ip;

import Interface.CoachInterface;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.Random;
import soccorob.ai.Team;
import soccorob.ai.wm.WorldModel;
import soccorob.rt.time.HighResTiming;
import soccorob.si.ip.ImageProcessingInterface;

public class RoboLabCoach
extends CoachInterface
implements ImageProcessingInterface {
    static final int IM_RES_X = 320;
    static final int IM_RES_Y = 240;
    static final double UPPER_LEFT_CORNER_X = 0.0;
    static final double UPPER_LEFT_CORNER_Y = 0.0;
    static final double LOWER_RIGHT_CORNER_X = 320.0;
    static final double LOWER_RIGHT_CORNER_Y = 240.0;
    static final double SIM_FIELD_LENGTH = 105.0;
    static final double SIM_FIELD_WIDTH = 68.0;
    static final double UNCERTAINTY_FACTOR = 1.0;
    HighResTiming timing = new HighResTiming();
    int myTeamIndex = 1;
    int theirTeamIndex = 0;
    Random random = new Random();
    boolean abort;

    public RoboLabCoach(String host, int port, String myTeamName, int version) {
        super(host, port, myTeamName, version);
        if (!this.isMyTeamLeft) {
            this.myTeamIndex = 0;
            this.theirTeamIndex = 1;
        }
        this.init();
    }

    public RoboLabCoach() {
        super("", 6002, "", 6);
        if (!this.isMyTeamLeft) {
            this.myTeamIndex = 0;
            this.theirTeamIndex = 1;
        }
        this.init();
    }

    private float xToImageCoords(double x) {
        return (float)((x + 52.5) * 3.0476190476190474);
    }

    private float yToImageCoords(double y) {
        return (float)((y + 34.0) * 3.5294117647058822);
    }

    @Override
    public void getCornerPositions(float[] corners) {
        corners[0] = 0.0f;
        corners[1] = 0.0f;
        corners[2] = 320.0f;
        corners[3] = 240.0f;
        WorldModel.getGoal(Team.WE).getLeftGoalPost().set(-1250L, -180L);
        WorldModel.getGoal(Team.WE).getRightGoalPost().set(-1250L, 180L);
    }

    @Override
    public void grabFrame() {
        this.timing.start();
        this.abort = false;
        try {
            String msg = null;
            do {
                msg = this.getMessageFromSoccerServer();
                if (this.timing.getElapsed() <= 120000) continue;
                this.abort = true;
            } while (this.cmp.parse(msg) != 1 && !this.abort);
        }
        catch (SocketException e) {
            System.out.println("Socket Exception!");
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.abort) {
            this.bsi.setChanged();
            this.bsi.notifyObservers(this);
        }
    }

    @Override
    public void convert() {
    }

    @Override
    public void getObjectPositions(float[] objects) {
        boolean ipTerminationBlock = false;
        boolean ipBallBlock = true;
        int ipRobotBlock = 2;
        int ipFlagBlock = 3;
        int ipTimeBlock = 4;
        boolean blockID = false;
        boolean blockSize = true;
        int nElements = 0;
        objects[nElements + 0] = 1.0f;
        objects[nElements + 1] = 5.0f;
        objects[nElements + 2] = this.xToImageCoords(this.bsi.ball.x);
        objects[nElements + 3] = this.yToImageCoords(this.bsi.ball.y);
        objects[nElements + 4] = 1.0f;
        nElements += (int)objects[nElements + 1];
        int i = 0;
        while (i < WorldModel.players) {
            objects[nElements + 0] = 2.0f;
            objects[nElements + 1] = 8.0f;
            objects[nElements + 2] = i;
            objects[nElements + 3] = this.xToImageCoords(this.bsi.team[this.myTeamIndex].player[i].x) + 2.0f * (float)Math.cos(Math.toRadians(this.bsi.team[this.myTeamIndex].player[i].angle));
            objects[nElements + 4] = this.yToImageCoords(this.bsi.team[this.myTeamIndex].player[i].y) + 2.0f * (float)Math.sin(Math.toRadians(this.bsi.team[this.myTeamIndex].player[i].angle));
            objects[nElements + 5] = this.xToImageCoords(this.bsi.team[this.myTeamIndex].player[i].x) - 2.0f * (float)Math.cos(Math.toRadians(this.bsi.team[this.myTeamIndex].player[i].angle));
            objects[nElements + 6] = this.yToImageCoords(this.bsi.team[this.myTeamIndex].player[i].y) - 2.0f * (float)Math.sin(Math.toRadians(this.bsi.team[this.myTeamIndex].player[i].angle));
            objects[nElements + 7] = 1.0f;
            nElements += (int)objects[nElements + 1];
            ++i;
        }
        i = 0;
        while (i < WorldModel.players) {
            objects[nElements + 0] = 2.0f;
            objects[nElements + 1] = 8.0f;
            objects[nElements + 2] = i + 3;
            objects[nElements + 3] = this.xToImageCoords(this.bsi.team[this.theirTeamIndex].player[i].x) + 2.0f * (float)Math.cos(Math.toRadians(this.bsi.team[this.theirTeamIndex].player[i].angle));
            objects[nElements + 4] = this.yToImageCoords(this.bsi.team[this.theirTeamIndex].player[i].y) + 2.0f * (float)Math.sin(Math.toRadians(this.bsi.team[this.theirTeamIndex].player[i].angle));
            objects[nElements + 5] = this.xToImageCoords(this.bsi.team[this.theirTeamIndex].player[i].x) - 2.0f * (float)Math.cos(Math.toRadians(this.bsi.team[this.theirTeamIndex].player[i].angle));
            objects[nElements + 6] = this.yToImageCoords(this.bsi.team[this.theirTeamIndex].player[i].y) - 2.0f * (float)Math.sin(Math.toRadians(this.bsi.team[this.theirTeamIndex].player[i].angle));
            objects[nElements + 7] = 1.0f;
            nElements += (int)objects[nElements + 1];
            ++i;
        }
        objects[nElements + 0] = 3.0f;
        objects[nElements + 1] = 7.0f;
        i = 0;
        while (i < 5) {
            objects[nElements + i + 2] = 0.0f;
            ++i;
        }
        nElements += (int)objects[nElements + 1];
        objects[nElements + 0] = 0.0f;
        objects[nElements + 1] = 2.0f;
        nElements += (int)objects[nElements + 1];
    }

    public static void main(String[] args) {
        String host = "mir29.ida.liu.se";
        int port = 6002;
        String myTeamName = "TeamStudent";
        int version = 6;
        RoboLabCoach cm = new RoboLabCoach(host, port, myTeamName, version);
        cm.init();
        float[] posns = new float[27];
        while (true) {
            cm.getObjectPositions(posns);
            int i = 0;
            while (i < 5) {
                System.out.print(String.valueOf(posns[i]) + " ");
                ++i;
            }
            System.out.println();
        }
    }
}

