/*
 * Decompiled with CFR 0.152.
 */
package soccorob.si.ip;

import Jama.Matrix;

public class KFRobot {
    private Matrix A = new Matrix(8, 8);
    private Matrix B;
    private Matrix K;
    private Matrix x;
    private Matrix H;
    private Matrix Q;
    private Matrix R;
    private Matrix P;
    private Matrix xMinus;
    private Matrix oldx;
    private Matrix BEffect;
    private Matrix xPredict;
    private Matrix error;
    private Matrix gain;
    private double angle1;
    private double angle2;
    private double diff;
    private double alpha = 0.99;
    private double dT = 0.04f;
    public static final double deltat = 0.06;

    public KFRobot() {
        this.A.set(0, 0, 1.0);
        this.A.set(0, 2, this.dT);
        this.A.set(1, 1, 1.0);
        this.A.set(1, 3, this.dT);
        this.A.set(2, 2, this.alpha);
        this.A.set(3, 3, this.alpha);
        this.A.set(4, 4, 1.0);
        this.A.set(4, 6, this.dT);
        this.A.set(5, 5, 1.0);
        this.A.set(5, 7, this.dT);
        this.A.set(6, 6, this.alpha);
        this.A.set(7, 7, this.alpha);
        this.H = new Matrix(4, 8);
        this.H.set(0, 0, 1.0);
        this.H.set(0, 4, 1.0);
        this.H.set(1, 1, 1.0);
        this.H.set(1, 5, 1.0);
        this.H.set(2, 0, 1.0);
        this.H.set(2, 4, -1.0);
        this.H.set(3, 1, 1.0);
        this.H.set(3, 5, -1.0);
        this.Q = Matrix.identity(8, 8);
        this.Q.set(0, 0, 1.0);
        this.Q.set(1, 1, 1.0);
        this.Q.set(2, 2, 10.0);
        this.Q.set(3, 3, 10.0);
        this.Q.set(4, 4, 1.0);
        this.Q.set(5, 5, 1.0);
        this.Q.set(6, 6, 10.0);
        this.Q.set(7, 7, 10.0);
        this.R = Matrix.identity(4, 4).times(4.0);
        this.P = Matrix.identity(8, 8).times(10000.0);
        this.x = new Matrix(8, 1);
    }

    public Matrix cycle(double _fx, double _fy, double _rx, double _ry) {
        Matrix z = new Matrix(4, 1);
        z.set(0, 0, _fx);
        z.set(1, 0, _fy);
        z.set(2, 0, _rx);
        z.set(3, 0, _ry);
        Matrix pred_x = this.A.times(this.x);
        Matrix pred_P = this.A.times(this.P.times(this.A.transpose())).plus(this.Q);
        Matrix Tmp1 = pred_P.times(this.H.transpose());
        Matrix Tmp2 = this.H.times(Tmp1);
        Tmp2 = Tmp2.plus(this.R);
        Tmp2 = Tmp2.inverse();
        this.K = Tmp1.times(Tmp2);
        Matrix e = z.minus(this.H.times(pred_x));
        this.x = pred_x.plus(this.K.times(e));
        this.P = Matrix.identity(8, 8).minus(this.K.times(this.H));
        this.P = this.P.times(pred_P);
        return this.x;
    }

    public static void main(String[] argv) {
        KFRobot kfr = new KFRobot();
        double[] data = new double[]{-578.124967672057, -439.8834907402426, -559.8595990973004, -508.7907839629609, -575.2520642038119, -436.7357189372434, -562.3618626998642, -508.62809359017064, -576.7562025684421, -437.51280186539987, -563.8278540918382, -508.0269554914054, -575.2118967347226, -435.911033113124, -568.8697200710491, -506.6861136484954, -573.4277175644696, -437.3885009248378, -568.3670205585026, -508.4745762711864, -577.3305084745763, -434.32203389830505, -569.4218813362768, -505.8625593023785, -576.0386838751324, -435.09717714988574, -574.8859502501407, -506.02997763682214, -571.3369886753923, -434.4614481521865, -571.7223377551062, -505.9820514614299, -570.5588550890906, -435.5288360078456, -577.6167724092128, -507.32935889292565, -571.2394391076039, -435.11649309578587, -576.639660334183, -505.5575855707718, -567.979731802213, -436.0221604169425, -578.7325713594081, -506.7609528363761, -563.276824304613, -435.4519763235318, -581.2250557592359, -504.73580926151595, -566.1487579345703, -434.58356695660086, -580.5405923875711, -507.5115672612594, -562.555749537581, -435.1583577818789, -584.058599956965, -503.1779661016949, -562.266091168937, -438.5868169493594, -582.6271186440678, -504.3014833482645, -562.6324475821801, -436.44064563815874, -586.6902561511023, -501.6542693315926, -558.4906723539708, -436.60155797408794, -588.3075423159842, -502.79415259927003, -556.2166440284858, -436.934050867113, -591.378050335383, -501.2588985895706, -553.6351769657458, -439.33989637989106, -594.5631609124652, -498.1797428454383, -554.6995744866839, -435.5601941124867, -590.3312715433411, -503.81999904826534, -552.61296741033, -440.29769250902075, -595.427286826958, -497.1457335908534, -548.9078618712344, -438.94727351301805, -596.3696463633391, -497.16561527575476, -546.286469798977, -442.5612142530538, -595.827910859706, -496.9035164784577, -548.6405097832113, -439.6186440677966, -597.2558360988811, -498.5539387848417, -545.6234236895027, -443.7543578067068, -599.0703227156299, -493.29624337665103, -542.0446395874023, -443.2740453946388, -601.271209070238, -490.96046868017163, -541.4649187508276, -445.5205949686341, -600.2305725873526, -489.46909985299834, -541.5970592175499, -448.4960588358216, -603.8135593220338, -486.83413004471083, -540.7216185230319, -446.16149643720206, -601.8875413021799, -489.69567832300214, -538.2869203211898, -448.5472178055068, -605.3269111503988, -484.41284793918413, -539.8188607167389, -448.10771942138666, -605.0517195362155, -484.2615127563476, -539.8360753463486, -451.4663502321405, -605.9042882111113, -481.2946157940363, -537.6059322033898, -452.86016949152537, -607.2408061916545, -478.25275841405835, -534.957627118644, -455.8294910495564, -605.8176493240614, -479.41478632264216, -537.2881485243975, -455.3672014656713, -606.819734735004, -476.4086513196007, -532.9324431338553, -460.3377035108663, -605.7262420654297, -481.84439287347305, -532.2290679155769, -460.3235600358349, -610.4519407627946, -475.42369971841066, -531.4817266949152, -461.1361228813559, -606.4618644067796, -478.60759799763304, -532.2336746474443, -462.0157662084547, -606.4618644067796, -473.62844822770455, -533.03160909879, -462.8916110022593, -607.576935978259, -470.42264776714774, -533.9277396767826, -463.6004819708355, -611.336271641618, -470.40042230638403, -529.5005087125099, -470.11423919160484, -609.0355727632167, -469.53330605717025, -530.4886122881355, -470.57070974576266, -608.5048287601794, -469.7336584834729, -528.6358978788732, -473.10691768840206, -609.5175823922884, -463.5212785106594, -531.2239113500563, -474.2636923062599, -607.702206757109, -463.95625098276946, -533.4679555084746, -479.0121822033898, -607.8766968290685, -465.23102259231825, -535.5629678499901, -483.95884239067465, -603.019100124553, -457.09747379109007, -532.7315249685513, -482.37533892615363, -607.0432016405008, -458.86726702673957};
        double lastRawAngle = 0.0;
        double lastKfAngle = 0.0;
        double fx = data[0];
        double fy = data[1];
        double rx = data[2];
        double ry = data[3];
        double rawAngle = Math.toDegrees(Math.atan2(fy - ry, fx - rx));
        fx = data[80];
        fy = data[81];
        rx = data[82];
        ry = data[83];
        double rawAngle2 = Math.toDegrees(Math.atan2(fy - ry, fx - rx));
        System.out.println("'True' delta: " + (rawAngle2 - rawAngle) / 20.0);
        int j = 0;
        while (j < 40) {
            int i = j < 20 ? j : 40 - j;
            fx = data[i * 4];
            fy = data[i * 4 + 1];
            rx = data[i * 4 + 2];
            ry = data[i * 4 + 3];
            Matrix x = kfr.cycle(data[i * 4], data[i * 4 + 1], data[i * 4 + 2], data[i * 4 + 3]);
            double d1 = x.get(4, 0);
            double d2 = x.get(5, 0);
            double s1 = x.get(6, 0) / 25.0;
            double s2 = x.get(7, 0) / 25.0;
            double dl = Math.sqrt(d1 * d1 + d2 * d2);
            double sl = Math.sqrt(s1 * s1 + s2 * s2);
            double spn = sl / (1.0E-8 + dl);
            if (s1 * d2 - s2 * d1 > 0.0) {
                spn = -spn;
            }
            spn = Math.toDegrees(spn);
            double rawAngle3 = Math.toDegrees(Math.atan2(fy - ry, fx - rx));
            double kfAngle = Math.toDegrees(Math.atan2(x.get(5, 0), x.get(4, 0)));
            System.out.println(i + ": " + "Raw delta: " + (rawAngle3 - lastRawAngle) + "\t KF delta: " + (kfAngle - lastKfAngle) + ", kfd2: " + spn);
            lastRawAngle = rawAngle3;
            lastKfAngle = kfAngle;
            ++j;
        }
    }
}

