/*
 * Decompiled with CFR 0.152.
 */
package soccorob.si.ip;

import Jama.Matrix;
import soccorob.ai.Interpreter;
import soccorob.ai.Team;
import soccorob.ai.wm.WorldModel;
import soccorob.comm.ActuatorInterface;
import soccorob.rt.AsyncEventHandler;
import soccorob.rt.RLThread;
import soccorob.rt.RunnableBlock;
import soccorob.rt.etst.ExecTimeStatistics;
import soccorob.rt.time.HighResTiming;
import soccorob.si.ip.CameraIP;
import soccorob.si.ip.ImageProcessingInterface;
import soccorob.si.ip.KF;
import soccorob.si.ip.KFBall;
import soccorob.si.ip.KFRobot;
import soccorob.si.ip.RoboLabCoach;

public class ImageProcessing
extends RLThread {
    private double SOCCERFIELD_LENGTH = 2500.0;
    private double UPPER_LEFT_CORNER_X;
    private double UPPER_LEFT_CORNER_Y;
    private double LOWER_RIGHT_CORNER_X;
    private double LOWER_RIGHT_CORNER_Y;
    private final double MAX_ROBOT_SPEED = 1500.0;
    private final double MAX_SPIN = 800.0;
    private final double MAX_BALL_SPEED = 2500.0;
    static final int POSX = 0;
    static final int POSY = 1;
    static final int ANGLE = 2;
    static final int SPEED = 3;
    static final int SPIN = 4;
    static final int LEFT_ENGINE = 0;
    static final int RIGHT_ENGINE = 1;
    private double CENTER_X;
    private double CENTER_Y;
    private double MM_PER_PIXEL_X;
    private double MM_PER_PIXEL_Y;
    private int MAX_NATIVE_DATA_ELEMENTS;
    private HighResTiming timing;
    private double deltaT;
    private ImageProcessingInterface ipWrapper;
    private float[] nativeObjectData;
    private float[] nativeCornerData;
    private Matrix[][] ourRobotData;
    private float[] ourRobotConfidence;
    private Matrix[][] oppRobotData;
    private float[] oppRobotConfidence;
    private Matrix[] ourRobotEngine;
    private Matrix nullEngine;
    private Matrix[] ballData;
    private int currentObjectData;
    private int oldObjectData;
    private KF[] ourRobotKF;
    private KFRobot kfr;
    private KF[] oppRobotKF;
    private KF ballKF;
    private KFBall kfb;
    private ActuatorInterface actuator;
    ExecTimeStatistics[] ipStat;
    private DeadlineMissHandler deadlineMissHandler = new DeadlineMissHandler();

    public ImageProcessing(boolean simFlag, ActuatorInterface act, boolean opponent, String serverHost, String teamName) {
        if (simFlag) {
            String teamname = teamName;
            this.ipWrapper = new RoboLabCoach(serverHost, 6002, teamname, 6);
        } else {
            this.ipWrapper = new CameraIP();
        }
        this.actuator = act;
        this.timing = new HighResTiming();
        this.MAX_NATIVE_DATA_ELEMENTS = 200;
        this.nativeObjectData = new float[this.MAX_NATIVE_DATA_ELEMENTS];
        this.nativeCornerData = new float[27];
        this.ourRobotData = new Matrix[2][3];
        this.ourRobotConfidence = new float[3];
        this.oppRobotData = new Matrix[2][3];
        this.oppRobotConfidence = new float[3];
        this.ourRobotEngine = new Matrix[3];
        this.nullEngine = new Matrix(1, 5);
        this.nullEngine.set(0, 0, 0.0);
        this.nullEngine.set(0, 1, 0.0);
        this.nullEngine.set(0, 2, 0.0);
        this.nullEngine.set(0, 3, 0.0);
        this.nullEngine.set(0, 4, 0.0);
        this.ourRobotKF = new KF[3];
        this.oppRobotKF = new KF[3];
        this.currentObjectData = 0;
        this.oldObjectData = 1;
        int i = 0;
        while (i < WorldModel.players) {
            this.ourRobotData[0][i] = new Matrix(1, 5);
            this.ourRobotData[1][i] = new Matrix(1, 5);
            this.ourRobotKF[i] = KF.getRobotFilter();
            this.ourRobotEngine[i] = new Matrix(1, 5);
            this.ourRobotEngine[i].set(0, 0, 0.0);
            this.ourRobotEngine[i].set(0, 1, 0.0);
            this.ourRobotEngine[i].set(0, 2, 0.0);
            this.ourRobotEngine[i].set(0, 3, 0.0);
            this.ourRobotEngine[i].set(0, 4, 0.0);
            this.oppRobotData[0][i] = new Matrix(1, 5);
            this.oppRobotData[1][i] = new Matrix(1, 5);
            this.oppRobotKF[i] = KF.getRobotFilter();
            ++i;
        }
        this.ballData = new Matrix[2];
        this.ballData[0] = new Matrix(1, 5);
        this.ballData[1] = new Matrix(1, 5);
        this.ballKF = KF.getBallFilter();
        this.kfb = new KFBall();
        this.kfr = new KFRobot();
        this.ipWrapper.getCornerPositions(this.nativeCornerData);
        this.UPPER_LEFT_CORNER_X = this.nativeCornerData[0];
        this.UPPER_LEFT_CORNER_Y = this.nativeCornerData[1];
        this.LOWER_RIGHT_CORNER_X = this.nativeCornerData[2];
        this.LOWER_RIGHT_CORNER_Y = this.nativeCornerData[3];
        System.out.println("\n\nImage Processing messages:");
        System.out.println("Corners detected: UpperLeftCorner = (" + this.UPPER_LEFT_CORNER_X + "," + this.UPPER_LEFT_CORNER_Y + ")\n" + "LowerRightCorner = (" + this.LOWER_RIGHT_CORNER_X + "," + this.LOWER_RIGHT_CORNER_Y + ")");
        this.CENTER_X = (this.UPPER_LEFT_CORNER_X + this.LOWER_RIGHT_CORNER_X) / 2.0;
        this.CENTER_Y = (this.UPPER_LEFT_CORNER_Y + this.LOWER_RIGHT_CORNER_Y) / 2.0;
        System.out.println("The center of the field(in pixels) is: (" + this.CENTER_X + "," + this.CENTER_Y + ")");
        this.MM_PER_PIXEL_X = 2500.0 / (this.LOWER_RIGHT_CORNER_X - this.UPPER_LEFT_CORNER_X);
        this.MM_PER_PIXEL_Y = 1500.0 / (this.LOWER_RIGHT_CORNER_Y - this.UPPER_LEFT_CORNER_Y);
        this.runnableBlocks = new RunnableBlock[4];
        this.runnableBlocks[0] = new Part1();
        this.runnableBlocks[1] = new Part2();
        this.runnableBlocks[2] = new Part3();
        this.runnableBlocks[3] = new Part4();
        this.ipStat = new ExecTimeStatistics[4];
        int noOfSamples = 1000;
        int fromSample = 300;
        this.ipStat[0] = new ExecTimeStatistics(noOfSamples, fromSample, "Image Processing Part1");
        this.ipStat[1] = new ExecTimeStatistics(noOfSamples, fromSample, "Image Processing Part2");
        this.ipStat[2] = new ExecTimeStatistics(noOfSamples, fromSample, "Image Processing Part3");
        this.ipStat[3] = new ExecTimeStatistics(noOfSamples, fromSample, "Image Processing Part4");
    }

    @Override
    public AsyncEventHandler getDeadlineMissHandler() {
        return this.deadlineMissHandler;
    }

    class DeadlineMissHandler
    extends AsyncEventHandler {
        DeadlineMissHandler() {
        }

        @Override
        public void handleAsyncEvent() {
            ImageProcessing.this.waitForNextPeriod();
        }
    }

    class Part1
    implements RunnableBlock {
        Part1() {
        }

        @Override
        public void run() {
            ImageProcessing.this.currentObjectData = (ImageProcessing.this.currentObjectData + 1) % 2;
            ImageProcessing.this.oldObjectData = 1 - ImageProcessing.this.currentObjectData;
            ImageProcessing.this.deltaT = (double)ImageProcessing.this.timing.getElapsed_setStart() / 1000000.0;
            ImageProcessing.this.ipWrapper.grabFrame();
        }
    }

    class Part2
    implements RunnableBlock {
        Part2() {
        }

        @Override
        public void run() {
            ImageProcessing.this.ipWrapper.convert();
        }
    }

    class Part3
    implements RunnableBlock {
        Part3() {
        }

        @Override
        public void run() {
            ImageProcessing.this.ipWrapper.getObjectPositions(ImageProcessing.this.nativeObjectData);
        }
    }

    class Part4
    implements RunnableBlock {
        Part4() {
        }

        @Override
        public void run() {
            double diffAngle;
            double oldAngle;
            double angle;
            double diffDirY;
            double diffDirX;
            double diffY;
            double diffX;
            double y;
            double x;
            double yFront;
            double xFront;
            double[] xf = new double[6];
            double[] yf = new double[6];
            double[] xb = new double[6];
            double[] yb = new double[6];
            double[] conf = new double[6];
            int[] nflags = new int[5];
            double ballx = 0.0;
            double bally = 0.0;
            double ballc = 0.0;
            boolean ipTerminationBlock = false;
            boolean ipBallBlock = true;
            int ipRobotBlock = 2;
            int ipFlagBlock = 3;
            int ipTimeBlock = 4;
            int ndx = 0;
            while (Math.round(ImageProcessing.this.nativeObjectData[ndx]) != 0) {
                int blockType = Math.round(ImageProcessing.this.nativeObjectData[ndx]);
                switch (blockType) {
                    case 1: {
                        ballx = ImageProcessing.this.nativeObjectData[ndx + 2];
                        bally = ImageProcessing.this.nativeObjectData[ndx + 3];
                        ballc = ImageProcessing.this.nativeObjectData[ndx + 4];
                        break;
                    }
                    case 2: {
                        int robotNdx = Math.round(ImageProcessing.this.nativeObjectData[ndx + 2]);
                        xf[robotNdx] = ImageProcessing.this.nativeObjectData[ndx + 3];
                        yf[robotNdx] = ImageProcessing.this.nativeObjectData[ndx + 4];
                        xb[robotNdx] = ImageProcessing.this.nativeObjectData[ndx + 5];
                        yb[robotNdx] = ImageProcessing.this.nativeObjectData[ndx + 6];
                        conf[robotNdx] = ImageProcessing.this.nativeObjectData[ndx + 7];
                        break;
                    }
                    case 3: {
                        int i = 0;
                        while (i < 5) {
                            nflags[i] = Math.round(ImageProcessing.this.nativeObjectData[ndx + 2 + i]);
                            ++i;
                        }
                        break;
                    }
                    case 4: {
                        double timediff = ImageProcessing.this.nativeObjectData[ndx + 2];
                        break;
                    }
                    default: {
                        System.out.println("Unkown block from IP. Block ID : " + blockType);
                    }
                }
                ndx += Math.round(ImageProcessing.this.nativeObjectData[ndx + 1]);
            }
            if (nflags[0] != 0) {
                System.out.println("Orange flag");
            }
            if (nflags[1] != 0) {
                System.out.println("Green flag");
            }
            if (nflags[2] != 0) {
                System.out.println("Yellow flag");
            }
            if (nflags[3] != 0) {
                System.out.println("Light blue flag");
            }
            if (nflags[4] != 0) {
                System.out.println("Dark blue flag");
            }
            if (nflags[1] != 0) {
                Interpreter.stopGame();
            }
            int i = 0;
            while (i < WorldModel.players) {
                xFront = xf[i];
                yFront = yf[i];
                double xBack = xb[i];
                double yBack = yb[i];
                x = (xFront + xBack) / 2.0;
                y = (yFront + yBack) / 2.0;
                ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].set(0, 0, (x -= ImageProcessing.this.CENTER_X) * ImageProcessing.this.MM_PER_PIXEL_X);
                ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].set(0, 1, (y -= ImageProcessing.this.CENTER_Y) * ImageProcessing.this.MM_PER_PIXEL_Y);
                ((ImageProcessing)ImageProcessing.this).ourRobotConfidence[i] = (float)conf[i];
                double lastAngle = ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].get(0, 2);
                diffX = ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].get(0, 0) - ImageProcessing.this.ourRobotData[ImageProcessing.this.oldObjectData][i].get(0, 0);
                diffY = ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].get(0, 1) - ImageProcessing.this.ourRobotData[ImageProcessing.this.oldObjectData][i].get(0, 1);
                ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].set(0, 3, Math.sqrt(diffX * diffX + diffY * diffY) / ImageProcessing.this.deltaT);
                diffDirX = xFront - xBack;
                diffDirY = yFront - yBack;
                angle = (Math.toDegrees(Math.atan2(diffDirY, diffDirX)) + 360.0) % 360.0;
                ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].set(0, 2, angle);
                oldAngle = ImageProcessing.this.ourRobotData[ImageProcessing.this.oldObjectData][i].get(0, 2);
                diffAngle = angle - oldAngle;
                if (diffAngle > 180.0) {
                    diffAngle -= 360.0;
                }
                if (diffAngle < -180.0) {
                    diffAngle += 360.0;
                }
                ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].set(0, 4, diffAngle / ImageProcessing.this.deltaT);
                ++i;
            }
            i = 0;
            while (i < WorldModel.players) {
                xFront = xf[i + 3];
                yFront = yf[i + 3];
                double xBack = xb[i + 3];
                double yBack = yb[i + 3];
                x = (xFront + xBack) / 2.0;
                y = (yFront + yBack) / 2.0;
                ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].set(0, 0, (x -= ImageProcessing.this.CENTER_X) * ImageProcessing.this.MM_PER_PIXEL_X);
                ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].set(0, 1, (y -= ImageProcessing.this.CENTER_Y) * ImageProcessing.this.MM_PER_PIXEL_Y);
                ((ImageProcessing)ImageProcessing.this).oppRobotConfidence[i] = (float)conf[i + 3];
                diffX = ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].get(0, 0) - ImageProcessing.this.oppRobotData[ImageProcessing.this.oldObjectData][i].get(0, 0);
                diffY = ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].get(0, 1) - ImageProcessing.this.oppRobotData[ImageProcessing.this.oldObjectData][i].get(0, 1);
                ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].set(0, 3, Math.sqrt(diffX * diffX + diffY * diffY) / ImageProcessing.this.deltaT);
                diffDirX = xFront - xBack;
                diffDirY = yFront - yBack;
                angle = (Math.toDegrees(Math.atan2(diffDirY, diffDirX)) + 360.0) % 360.0;
                ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].set(0, 2, angle);
                oldAngle = ImageProcessing.this.oppRobotData[ImageProcessing.this.oldObjectData][i].get(0, 2);
                diffAngle = angle - oldAngle;
                if (diffAngle > 180.0) {
                    diffAngle -= 360.0;
                }
                if (diffAngle < -180.0) {
                    diffAngle += 360.0;
                }
                ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].set(0, 4, diffAngle / ImageProcessing.this.deltaT);
                ++i;
            }
            x = ballx;
            y = bally;
            ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].set(0, 0, (x -= ImageProcessing.this.CENTER_X) * ImageProcessing.this.MM_PER_PIXEL_X);
            ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].set(0, 1, (y -= ImageProcessing.this.CENTER_Y) * ImageProcessing.this.MM_PER_PIXEL_Y);
            diffX = ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].get(0, 0) - ImageProcessing.this.ballData[ImageProcessing.this.oldObjectData].get(0, 0);
            diffY = ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].get(0, 1) - ImageProcessing.this.ballData[ImageProcessing.this.oldObjectData].get(0, 1);
            ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].set(0, 3, Math.sqrt(diffX * diffX + diffY * diffY) / ImageProcessing.this.deltaT);
            angle = Math.toDegrees(Math.atan2(diffY, diffX));
            ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].set(0, 2, angle);
            i = 0;
            while (i < WorldModel.players) {
                angle = ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].get(0, 2);
                if (angle > 180.0) {
                    angle -= 360.0;
                }
                WorldModel.seePlayer(0L, Team.WE, i + 1, (long)ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].get(0, 0), (long)ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].get(0, 1), (long)ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].get(0, 3), (float)angle, (int)ImageProcessing.this.ourRobotData[ImageProcessing.this.currentObjectData][i].get(0, 4), ImageProcessing.this.ourRobotConfidence[i]);
                angle = ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].get(0, 2);
                if (angle > 180.0) {
                    angle -= 360.0;
                }
                WorldModel.seePlayer(0L, Team.THEM, i + 1, (long)ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].get(0, 0), (long)ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].get(0, 1), (long)ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].get(0, 3), (float)angle, (int)ImageProcessing.this.oppRobotData[ImageProcessing.this.currentObjectData][i].get(0, 4), ImageProcessing.this.oppRobotConfidence[i]);
                ++i;
            }
            WorldModel.seeBall(0L, (long)ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].get(0, 0), (long)ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].get(0, 1), (long)ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].get(0, 3), (float)ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].get(0, 2), (float)ballc);
            angle = ImageProcessing.this.ballData[ImageProcessing.this.currentObjectData].get(0, 2);
            if (angle > 180.0) {
                angle -= 360.0;
            }
            ImageProcessing.this.waitForNextPeriod();
        }
    }
}

