/*
 * Decompiled with CFR 0.152.
 */
package soccorob.rt;

import soccorob.rt.RLThread;
import soccorob.rt.Scheduler;
import soccorob.rt.time.AbsoluteTime;
import soccorob.rt.time.HighResolutionClock;
import soccorob.rt.time.RelativeTime;

public abstract class BaseCyclicScheduler
extends Scheduler {
    private boolean scheduleExpansion = true;
    private AbsoluteTime scheduledCySt = null;
    private AbsoluteTime schedulerSt = null;
    private RelativeTime majP = null;
    private RelativeTime minP = null;
    private int minCyCount = 1;
    private int majMinRatio = 0;
    private boolean isMaj = false;
    private RelativeTime frameMissedBy = new RelativeTime();

    public AbsoluteTime getScheduledCycleStart() {
        return this.scheduledCySt;
    }

    public void setSchedulerStart(AbsoluteTime startt) {
        this.schedulerSt = startt;
        if (this.scheduledCySt == null && this.minP != null) {
            this.scheduledCySt = new AbsoluteTime();
            this.schedulerSt.add(this.minP, this.scheduledCySt);
        }
    }

    public void setMajorCycle(RelativeTime majorPeriod) {
        if (this.majP == null) {
            this.majP = majorPeriod;
        }
        if (this.minP != null) {
            this.majMinRatio = (int)(this.majP.toMicroSeconds() / this.minP.toMicroSeconds());
        }
    }

    public void setMinorCycle(RelativeTime minorPeriod) {
        if (this.minP == null) {
            this.minP = minorPeriod;
        }
        if (this.majP != null) {
            this.majMinRatio = (int)(this.majP.toMicroSeconds() / this.minP.toMicroSeconds());
        }
        if (this.scheduledCySt == null && this.schedulerSt != null) {
            this.scheduledCySt = new AbsoluteTime();
            this.schedulerSt.add(this.minP, this.scheduledCySt);
        }
    }

    public boolean isMajorCycle() {
        return this.isMaj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCycleInterrupt() {
        AbsoluteTime now = new AbsoluteTime();
        HighResolutionClock.getTime(now);
        ++this.minCyCount;
        this.isMaj = (this.minCyCount - 1) % this.majMinRatio == 0;
        if (this.scheduledCySt.isGreater(now)) {
            this.frameMissedBy.setTime(0, 0, 0);
            do {
                HighResolutionClock.getTime(now);
                try {
                    AbsoluteTime absoluteTime = now;
                    synchronized (absoluteTime) {
                        now.wait(1L);
                    }
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            } while (this.scheduledCySt.isGreater(now));
        } else {
            now.subtract(this.scheduledCySt, this.frameMissedBy);
        }
        if (this.scheduleExpansion) {
            now.add(this.minP, this.scheduledCySt);
        } else {
            long relNextL = this.minP.toMicroSeconds() * (long)this.minCyCount;
            RelativeTime relNextR = new RelativeTime();
            relNextR.fromMicroSeconds(relNextL);
            this.schedulerSt.add(relNextR, this.scheduledCySt);
        }
    }

    public void fireUntilFinished(RLThread s) {
        this.fireThread(s);
        while (!s.isFinished()) {
            this.fireThread(s);
        }
    }

    public BaseCyclicScheduler() {
        super(true);
    }

    public BaseCyclicScheduler(boolean optimize) {
        super(optimize);
    }
}

