/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import soccorob.ai.Eval;
import soccorob.ai.Point;
import soccorob.ai.Team;
import soccorob.ai.agent.Agent;
import soccorob.ai.agent.Behavior;
import soccorob.ai.wm.WorldModel;

public class Gui
extends JFrame
implements ChangeListener {
    JButton gamebutton = new GameButton("Start game");
    JButton steeringButton = new GameButton("Automatic");
    JButton updatePlanOnButton = new GameButton("UpdatePlanOn");
    JTextArea textarea = new JTextArea("", 6, 20);
    JTextField leftText = new JTextField(3);
    JTextField rightText = new JTextField(3);
    JTextField behaveField = new JTextField(20);
    CmdLine textfield = new CmdLine(this.textarea);
    JPanel cmdContainer = new JPanel();
    JPanel upperContainer = new JPanel();
    JPanel westPanel = new JPanel();
    TurnSlider turnSlider = new TurnSlider();
    SpeedSlider speedSlider = new SpeedSlider();
    Behavior behave;
    Agent agent;
    boolean isAutomatic = false;

    public Gui(Agent agent) {
        this.agent = agent;
        this.setTitle("Gui for agent " + Integer.toString(agent.no));
        this.getContentPane().setLayout(new BorderLayout());
        this.textarea.setEditable(false);
        this.upperContainer.setLayout(new FlowLayout());
        this.upperContainer.add(new JLabel("Output:"));
        this.upperContainer.add(this.leftText);
        this.upperContainer.add(this.rightText);
        this.upperContainer.add(new JLabel("Behavior:"));
        this.behave = agent.getReactor().createPlan("stop");
        this.behaveField.setText(this.behave.toString());
        this.upperContainer.add(this.behaveField);
        this.westPanel.setLayout(new GridLayout(6, 2));
        this.westPanel.add(this.gamebutton);
        this.westPanel.add(this.steeringButton);
        this.westPanel.add(new BehaveButton(agent.getReactor().createPlan("stop")));
        this.westPanel.add(new BehaveButton(agent.getReactor().createPlan("turnTo", new Float(0.0f))));
        this.westPanel.add(new BehaveButton(agent.getReactor().createPlan("default")));
        this.westPanel.add(new BehaveButton(agent.getReactor().createPlan("gotoPos", new Point(1000L, 300L), new Point(1000L, 300L))));
        this.westPanel.add(new BehaveButton(agent.getReactor().createPlan("runOver", WorldModel.getBall().getPos())));
        this.westPanel.add(new BehaveButton(agent.getReactor().createPlan("kickBall", WorldModel.getGoal(Team.THEM).getPos())));
        this.westPanel.add(new BehaveButton(agent.getReactor().createPlan("runAround")));
        this.westPanel.add(new BehaveButton(agent.getReactor().createPlan("gotoPosCA", new Point())));
        agent.updatePlanOn = false;
        this.westPanel.add(this.updatePlanOnButton);
        this.cmdContainer.setLayout(new GridLayout(2, 1));
        this.cmdContainer.add(new JScrollPane(this.textarea));
        this.cmdContainer.add(this.textfield);
        this.getContentPane().add((Component)this.upperContainer, "North");
        this.getContentPane().add((Component)this.westPanel, "West");
        this.getContentPane().add((Component)this.cmdContainer, "Center");
        this.getContentPane().add((Component)this.turnSlider, "South");
        this.getContentPane().add((Component)this.speedSlider, "East");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WorldModel.setGameStatus(false);
                Gui.this.dispose();
                System.exit(0);
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.steeringButton.getText().equals("Automatic")) {
            int left = (int)((double)(this.speedSlider.getValue() + this.turnSlider.getValue()) * 0.7);
            int right = (int)((double)(this.speedSlider.getValue() - this.turnSlider.getValue()) * 0.7);
            this.leftText.setText(Integer.toString(left));
            this.rightText.setText(Integer.toString(right));
            this.agent.setPlan(this.agent.getReactor().createPlan("raw", new Integer(left), new Integer(right)));
        } else {
            this.leftText.setText("-");
            this.rightText.setText("-");
        }
    }

    class BehaveButton
    extends JButton
    implements ActionListener {
        public Behavior beh;

        public BehaveButton(Behavior beh) {
            this.beh = beh;
            this.setText(beh.toString());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gui.this.behave = this.beh;
            Gui.this.behaveField.setText(this.beh.toString());
            if (Gui.this.isAutomatic) {
                System.out.println("Setting plan via GUI:" + this.beh.toString());
                this.beh.usedAgain();
                Gui.this.agent.setPlan(this.beh);
            }
        }
    }

    class CmdLine
    extends JTextField
    implements ActionListener {
        JTextArea resultArea;

        public CmdLine(JTextArea res) {
            super(20);
            this.resultArea = res;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String result = Eval.evalLine(this.getText());
            this.resultArea.append("\n> " + this.getText() + "\n" + result);
        }
    }

    class GameButton
    extends JButton
    implements ActionListener {
        public GameButton(String text) {
            this.setText(text);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.getText().equals("Stop game")) {
                WorldModel.setGameStatus(false);
                this.setText("Start game");
            } else if (this.getText().equals("Start game")) {
                WorldModel.setGameStatus(true);
                this.setText("Stop game");
            } else if (this.getText().equals("Automatic")) {
                Gui.this.isAutomatic = true;
                Gui.this.agent.setPlan("stop");
                this.setText("Manual");
            } else if (this.getText().equals("Manual")) {
                Gui.this.isAutomatic = false;
                Gui.this.stateChanged(null);
                Gui.this.behave.usedAgain();
                Gui.this.agent.setPlan(Gui.this.behave);
                this.setText("Automatic");
            } else if (this.getText().equals("UpdatePlanOn")) {
                Gui.this.agent.updatePlanOn = true;
                this.setText("UpdatePlanOff");
            } else if (this.getText().equals("UpdatePlanOff")) {
                Gui.this.agent.updatePlanOn = false;
                this.setText("UpdatePlanOn");
            } else {
                System.out.println("Error in Gui: Could not find Button text");
            }
        }
    }

    class SpeedSlider
    extends JSlider {
        public SpeedSlider() {
            super(1, -10, 10, 0);
            this.addChangeListener(Gui.this);
            this.setMajorTickSpacing(10);
            this.setMinorTickSpacing(5);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        }
    }

    class TurnSlider
    extends JSlider {
        public TurnSlider() {
            super(0, -10, 10, 0);
            this.addChangeListener(Gui.this);
            this.setMajorTickSpacing(10);
            this.setMinorTickSpacing(5);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        }
    }
}

