/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent.planners;

import soccorob.ai.Point;
import soccorob.ai.Team;
import soccorob.ai.agent.Agent;
import soccorob.ai.agent.Planner;
import soccorob.ai.wm.PlayerObject;
import soccorob.ai.wm.WorldModel;
import soccorob.rt.RunnableBlock;

public class Planner1
extends Planner {
    private int state;
    private int nextState;
    private final int START = 0;
    private final int DEFENSE = 1;
    private final int COVER = 2;
    private final int PRESSURE = 3;
    private final int OFFENSE = 11;
    private final int AGGRESSIVE = 12;
    private final int EASY = 13;
    private final long KEEP_GOAL_DIST = 700L;
    private final long PRESSURE_DIST = 800L;
    private final String[] stateNames = new String[]{"START", "DEFENSE", "COVER", "PRESSURE", "", "", "", "", "", "", "", "OFFENSE", "AGGRESIVE", "EASY", ""};
    private int planStep = 0;
    private boolean restartOnNextStep = false;

    public Planner1(Agent agent) {
        super(agent);
        this.runnableBlocks = new RunnableBlock[1];
        this.runnableBlocks[0] = new Part1();
        this.state = 0;
    }

    @Override
    public void restart() {
        this.state = 0;
        this.planStep = 0;
    }

    @Override
    public void updatePlan() {
        switch (this.state) {
            case 0: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                this.agent.setPlan("moveUpKick");
                break;
            }
            case 13: {
                this.agent.setPlan("easy");
            }
            case 1: {
                if (WorldModel.getClosestOpponent(WorldModel.getGoal(Team.WE).getPos()).getPos().distanceTo(WorldModel.getGoal(Team.WE).getPos()) < 800L && WorldModel.getBall().getPos().distanceTo(WorldModel.getGoal(Team.WE).getPos()) < 700L && WorldModel.getClosestTeammate((Point)WorldModel.getGoal((Team)Team.WE).getPos()).no == this.agent.no) {
                    this.agent.goalKeeper = true;
                    this.agent.setPlan("keepGoal");
                    break;
                }
                this.agent.goalKeeper = false;
                break;
            }
            case 2: {
                if (WorldModel.getBall().getPos().distanceTo(WorldModel.getGoal(Team.WE).getPos()) < 700L && WorldModel.getClosestTeammate((Point)WorldModel.getGoal((Team)Team.WE).getPos()).no == this.agent.no) {
                    this.agent.goalKeeper = true;
                    this.agent.setPlan("keepGoal");
                    break;
                }
                this.agent.goalKeeper = false;
                this.agent.setPlan("gotoCoverPoint");
                break;
            }
            case 3: {
                if (WorldModel.getClosestTeammate((Point)WorldModel.getBall().getPos()).no == this.agent.no) {
                    this.agent.setPlan("kickBall", WorldModel.getGoal(Team.THEM).getPos());
                    break;
                }
                this.agent.setPlan("gotoCoverPoint");
            }
        }
    }

    @Override
    public String getInfo() {
        return "Planner1";
    }

    class Part1
    implements RunnableBlock {
        Part1() {
        }

        @Override
        public void run() {
            if (Planner1.this.isFinished()) {
                Planner1.this.finished = false;
            }
            if (Planner1.this.restartOnNextStep) {
                Planner1.this.state = 0;
                Planner1.this.planStep = 0;
                Planner1.this.restartOnNextStep = false;
            }
            int i = 0;
            while (i < 450000) {
                ++i;
            }
            Planner1 planner1 = Planner1.this;
            planner1.planStep = planner1.planStep + 1;
            Planner1 planner12 = Planner1.this;
            planner12.planStep = planner12.planStep % 2;
            if (Planner1.this.planStep != 0) {
                return;
            }
            switch (Planner1.this.state) {
                case 0: {
                    if (WorldModel.getClosestPlayer((Point)WorldModel.getBall().getPos()).team == Team.WE) {
                        Planner1.this.nextState = 11;
                        break;
                    }
                    Planner1.this.nextState = 1;
                    break;
                }
                case 11: {
                    PlayerObject closestToBallOpponent = WorldModel.getClosestOpponent(WorldModel.getBall().getPos());
                    PlayerObject ballKeeper = WorldModel.getClosestTeammate(WorldModel.getBall().getPos());
                    float angleDiff = (float)closestToBallOpponent.getPos().angleTo(ballKeeper.getPos()) - closestToBallOpponent.getVel().getAngle();
                    if (angleDiff > 180.0f) {
                        angleDiff -= 360.0f;
                    }
                    if (angleDiff <= -180.0f) {
                        angleDiff += 360.0f;
                    }
                    if (closestToBallOpponent.getPos().distanceTo(ballKeeper.getPos()) < 300L || closestToBallOpponent.getVel().getLength() > 0L && Math.abs(angleDiff) < 20.0f) {
                        Planner1.this.nextState = 13;
                        break;
                    }
                    Planner1.this.nextState = 12;
                    break;
                }
                case 13: {
                    Planner1.this.endOfPlanReached();
                    break;
                }
                case 12: {
                    Planner1.this.endOfPlanReached();
                    break;
                }
                case 1: {
                    if (WorldModel.getClosestOpponent(WorldModel.getGoal(Team.THEM).getPos()).getPos().distanceTo(WorldModel.getClosestOpponent(WorldModel.getGoal(Team.WE).getPos()).getPos()) > 800L) {
                        Planner1.this.nextState = 3;
                        break;
                    }
                    Planner1.this.nextState = 2;
                    break;
                }
                case 2: {
                    Planner1.this.endOfPlanReached();
                    break;
                }
                case 3: {
                    Planner1.this.endOfPlanReached();
                }
            }
            if (Planner1.this.isFinished()) {
                Planner1.this.restartOnNextStep = true;
            }
            Planner1.this.state = Planner1.this.nextState;
        }
    }
}

