/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent.behaviors;

import soccorob.ai.Debug;
import soccorob.ai.Point;
import soccorob.ai.Team;
import soccorob.ai.Vector;
import soccorob.ai.agent.Behavior;
import soccorob.ai.wm.PlayerObject;
import soccorob.ai.wm.WorldModel;

public class GotoPosSafe3
extends Behavior {
    private Point abspos = new Point();
    private Vector travel = new Vector();
    private boolean stopAtPos;
    private final int min_distance = (int)Math.sqrt(9125.0);

    @Override
    public void init(Object arg1) {
        this.stopAtPos = true;
        this.abspos.set((Point)arg1);
    }

    @Override
    public void init(Object arg1, Object arg2) {
        this.stopAtPos = false;
        this.abspos.set((Point)arg1);
    }

    @Override
    public boolean exec() {
        double timeToCollision;
        double speedRate;
        this.agent.body().getPos().vectorTo(this.abspos, this.travel);
        if (this.travel.getLength() < (long)(this.min_distance / 2)) {
            this.power(0, 0);
            return true;
        }
        int spin = this.agent.body().getSpin();
        int angleDiff = (int)(this.travel.getAngle() - this.agent.body().getVel().getAngle());
        if (angleDiff <= -180) {
            angleDiff += 360;
        }
        if (angleDiff > 180) {
            angleDiff -= 360;
        }
        if (angleDiff < -90 && angleDiff > -180) {
            angleDiff = -90;
        }
        if (angleDiff > 90 && angleDiff < 180) {
            angleDiff = 90;
        }
        if ((speedRate = Math.cos(Math.toRadians(angleDiff))) < 0.0) {
            speedRate = 0.0;
        }
        if (this.stopAtPos) {
            long closedist = (long)this.getValue("closedist");
            long fardist = (long)this.getValue("fardist");
            speedRate = this.travel.getLength() < closedist ? 0.0 : (speedRate *= speedRate * speedRate * Math.sin(Math.toRadians((double)(((float)Math.min(this.travel.getLength(), fardist) - (float)closedist) / (float)(fardist - closedist)) * 90.0)));
        } else {
            speedRate *= speedRate * speedRate;
        }
        angleDiff = (int)((float)angleDiff - (float)spin * this.getValue("spincompensation"));
        if (angleDiff <= -180) {
            angleDiff += 360;
        }
        if (angleDiff > 180) {
            angleDiff -= 360;
        }
        if (angleDiff < -90 && angleDiff > -180) {
            angleDiff = -90;
        }
        if (angleDiff > 90 && angleDiff < 180) {
            angleDiff = 90;
        }
        double turnRate = Math.sin(Math.toRadians(angleDiff));
        float turndist = this.getValue("turndist");
        float distfactor = this.getValue("distfactor");
        turnRate = Math.abs(angleDiff) > 5 ? (turnRate += Math.cos(Math.PI * (double)Math.min((float)this.travel.getLength(), turndist) / (double)turndist) / (double)distfactor) : 0.0;
        speedRate *= (double)this.getValue("speedfactor");
        turnRate *= (double)this.getValue("turnfactor");
        if (this.getValue("showdebug") == 1.0f) {
            Debug.Note("dist " + this.travel.getLength() + ", angle " + angleDiff + ", spin " + spin + " => speed " + Double.toString((double)((int)(speedRate * 100.0)) / 100.0) + ", turn " + Double.toString((double)((int)(turnRate * 100.0)) / 100.0));
        }
        double scale = this.getValue("scale");
        long dist = Math.min(this.obstacleDistance(), this.distanceToCollision());
        long speed = this.agent.body().getVel().getLength();
        if (speed != 0L && (timeToCollision = (double)(dist / speed)) < (double)this.getValue("braketime")) {
            speedRate = Math.min(speedRate, timeToCollision / (double)this.getValue("brakecoeff"));
        }
        double left = scale * (speedRate + turnRate);
        double right = scale * (speedRate - turnRate);
        this.power((int)left, (int)right);
        return false;
    }

    @Override
    public String toString() {
        if (this.stopAtPos) {
            return "gotoPos" + this.abspos.toString();
        }
        return "runOver" + this.abspos.toString();
    }

    private long distanceToCollision() {
        long coll_y;
        long distance = 100000L;
        double radangle = this.agent.body().getVel().getRadAngle();
        float angle = this.agent.body().getVel().getAngle();
        if (angle < 0.0f) {
            distance = (long)Math.min((double)distance, Math.abs((double)(750L + this.agent.body().getPos().y - (long)this.min_distance) / Math.cos(radangle + 1.5707963267948966)));
        }
        if (angle > -90.0f && angle < 90.0f && ((coll_y = (long)((double)(1250L - this.agent.body().getPos().x) * Math.tan(radangle)) + this.agent.body().getPos().y) + (long)this.min_distance <= WorldModel.getGoal((Team)Team.THEM).getLeftGoalPost().y || coll_y - (long)this.min_distance >= WorldModel.getGoal((Team)Team.THEM).getRightGoalPost().y)) {
            distance = (long)Math.min((double)distance, Math.abs((double)(1250L - this.agent.body().getPos().x - (long)this.min_distance) / Math.cos(radangle)));
        }
        if (angle > 0.0f) {
            distance = (long)Math.min((double)distance, Math.abs((double)(750L - this.agent.body().getPos().y - (long)this.min_distance) / Math.cos(radangle - 1.5707963267948966)));
        }
        if ((angle > 90.0f || angle < -90.0f) && ((coll_y = (long)((double)(this.agent.body().getPos().x + 1250L) * Math.tan(Math.PI - radangle)) + this.agent.body().getPos().y) + (long)this.min_distance <= WorldModel.getGoal((Team)Team.WE).getLeftGoalPost().y || coll_y - (long)this.min_distance >= WorldModel.getGoal((Team)Team.WE).getRightGoalPost().y)) {
            distance = (long)Math.min((double)distance, Math.abs((double)(1250L + this.agent.body().getPos().x - (long)this.min_distance) / Math.cos(radangle)));
        }
        return distance;
    }

    private long obstacleDistance() {
        long distance = 100000L;
        int i = 1;
        while (i <= WorldModel.players) {
            if (this.agent.no != i) {
                double v;
                int x;
                PlayerObject obstacle = WorldModel.getPlayerObject(Team.WE, i);
                int angle = this.agent.body().getPos().angleTo(obstacle.getPos());
                long dist = this.agent.body().getPos().distanceTo(obstacle.getPos());
                if (dist < 400L && (x = (int)((double)dist * Math.sin(v = Math.toRadians(this.agent.body().getVel().getAngle() - (float)angle)))) <= 2 * this.min_distance) {
                    long y = (long)((double)dist * Math.cos(v));
                    long d = y - (long)Math.sqrt(4 * this.min_distance * this.min_distance - x * x);
                    if (y > (long)(-this.min_distance) && d < distance) {
                        distance = d;
                    }
                }
            }
            ++i;
        }
        return distance;
    }
}

