/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai.agent.behaviors;

import soccorob.ai.Debug;
import soccorob.ai.agent.Behavior;
import soccorob.ai.agent.BehaviorClass;

public class AbstractBehavior
extends Behavior {
    private static BehaviorClass nullBehavior = BehaviorClass.load("soccorob.ai.agent.behaviors.NullBehavior");
    private Behavior parsedPlan = null;
    private String cmd;
    private Object[] args;

    @Override
    public void init(Object arg1, Object arg2) {
        this.cmd = (String)arg1;
        this.args = (Object[])arg2;
    }

    @Override
    public boolean exec() {
        if (this.parsedPlan == null) {
            if (this.args == null || this.args.length == 0) {
                if (this.agent.getReactor().hasBehaviorBinding(this.cmd)) {
                    this.parsedPlan = this.agent.getReactor().createPlan(this.cmd);
                } else {
                    Debug.Note("No behavior binding exists for " + this.cmd + ", not even at exec-time.");
                    this.cmd = String.valueOf(this.cmd) + "[not_found]";
                    this.parsedPlan = nullBehavior.New();
                }
            } else {
                switch (this.args.length) {
                    case 1: {
                        this.parsedPlan = this.agent.getReactor().createPlan(this.cmd, this.args[0]);
                        break;
                    }
                    case 2: {
                        this.parsedPlan = this.agent.getReactor().createPlan(this.cmd, this.args[0], this.args[1]);
                        break;
                    }
                    case 3: {
                        this.parsedPlan = this.agent.getReactor().createPlan(this.cmd, this.args[0], this.args[1], this.args[2]);
                        break;
                    }
                    case 4: {
                        this.parsedPlan = this.agent.getReactor().createPlan(this.cmd, this.args[0], this.args[1], this.args[2], this.args[3]);
                        break;
                    }
                    default: {
                        Debug.Error("AbstractBehavior.exec(): strange number of arguments to behavior");
                        return true;
                    }
                }
            }
        }
        return this.parsedPlan.exec();
    }

    @Override
    public String toString() {
        if (this.parsedPlan != null) {
            return this.parsedPlan.toString();
        }
        if (this.args == null || this.args.length == 0) {
            return "'" + this.cmd + "'";
        }
        String result = "'" + this.cmd + "'(" + this.args[0].toString();
        int i = 1;
        while (i < this.args.length) {
            result = String.valueOf(result) + ", " + this.args[i];
            ++i;
        }
        return String.valueOf(result) + ")";
    }
}

