/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai;

import soccorob.ai.Vector;

public class Point {
    public long x;
    public long y;

    public Point() {
        this.x = 0L;
        this.y = 0L;
    }

    public Point(long x, long y) {
        this.x = x;
        this.y = y;
    }

    public Point(Point pt) {
        this.x = pt.x;
        this.y = pt.y;
    }

    public void set(Point pt) {
        this.x = pt.x;
        this.y = pt.y;
    }

    public void set(long x, long y) {
        this.x = x;
        this.y = y;
    }

    public boolean equal(Point pos) {
        return pos.x == this.x && pos.y == this.y;
    }

    public String toString() {
        return "(" + Long.toString(this.x) + ", " + Long.toString(this.y) + ")";
    }

    public long distanceTo(Point pos) {
        return (long)Math.sqrt((this.x - pos.x) * (this.x - pos.x) + (this.y - pos.y) * (this.y - pos.y));
    }

    public int angleTo(Point pos) {
        long dx = pos.x - this.x;
        long dy = pos.y - this.y;
        int ang = 90 - (int)Math.toDegrees(Math.atan2(dx, dy));
        if (ang <= -180) {
            return ang + 360;
        }
        if (ang > 180) {
            return ang - 360;
        }
        return ang;
    }

    public void vectorTo(Point pos, Vector result) {
        result.set(this.distanceTo(pos), this.angleTo(pos));
    }

    public Point pointAt(Vector vector) {
        Point pt = new Point(this);
        pt.moveAlong(vector);
        return pt;
    }

    public void moveAlong(Vector vector) {
        this.x = (long)((double)this.x + (double)vector.getLength() * Math.cos(vector.getRadAngle()));
        this.y = (long)((double)this.y + (double)vector.getLength() * Math.sin(vector.getRadAngle()));
    }
}

