/*
 * Decompiled with CFR 0.152.
 */
package soccorob.ai;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.LinkedList;
import java.util.StringTokenizer;
import soccorob.ai.Debug;
import soccorob.ai.Interpreter;
import soccorob.ai.wm.WorldModel;

public class Eval {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String evalFile(String filename) {
        StreamTokenizer st;
        try {
            FileInputStream fileStream = new FileInputStream(filename);
            BufferedReader r = new BufferedReader(new InputStreamReader(fileStream));
            st = new StreamTokenizer(r);
            st.commentChar(35);
            st.eolIsSignificant(true);
            st.lowerCaseMode(false);
            st.wordChars(47, 47);
            st.wordChars(92, 92);
            st.wordChars(58, 58);
            st.wordChars(48, 57);
        }
        catch (FileNotFoundException ex) {
            Debug.Error("File not found: " + filename);
            return "FileNotFoundException: " + filename;
        }
        catch (SecurityException ex) {
            return "Reactor SecurityException: " + filename;
        }
        LinkedList<String> cmd = new LinkedList<String>();
        try {
            int val = st.nextToken();
            block5: while (true) {
                if (st.ttype != 10) {
                    if (st.ttype == -1) {
                        return "File loaded.";
                    }
                } else {
                    val = st.nextToken();
                    continue;
                }
                cmd.clear();
                while (true) {
                    if (st.ttype != -3 && st.ttype != -2) {
                        if (cmd.size() != 0) break;
                        return "Warning: Eval.evalFile read empty line";
                    }
                    if (st.ttype == -2) {
                        cmd.addLast(Integer.toString((int)st.nval));
                    } else {
                        cmd.addLast(st.sval);
                    }
                    val = st.nextToken();
                }
                String[] arr = new String[cmd.size()];
                int i = 0;
                while (true) {
                    if (i >= cmd.size()) {
                        Eval.evalLine(arr);
                        continue block5;
                    }
                    arr[i] = (String)cmd.get(i);
                    ++i;
                }
                break;
            }
        }
        catch (IOException ex) {
            return "Eval.evalFile IOException";
        }
    }

    public static String evalLine(String line) {
        LinkedList<String> cmd = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(line);
        while (st.hasMoreTokens()) {
            cmd.addLast(st.nextToken());
        }
        String[] arr = new String[cmd.size()];
        int i = 0;
        while (i < cmd.size()) {
            arr[i] = (String)cmd.get(i);
            ++i;
        }
        if (arr.length > 0 && arr[0].charAt(0) == '#') {
            return "";
        }
        return Eval.evalLine(arr);
    }

    private static String evalLine(String[] cmd) {
        if (cmd.length == 0) {
            return "ok (empty line)";
        }
        String first = cmd[0];
        if (first.equals("set")) {
            return Eval.evalSet(cmd);
        }
        if (first.equals("print")) {
            return Eval.evalPrint(cmd);
        }
        if (first.equals("game")) {
            return Eval.evalGame(cmd);
        }
        if (first.equals("reload")) {
            return Eval.evalReload(cmd);
        }
        if (first.equals("behave")) {
            return Eval.evalBehave(cmd);
        }
        if (first.equals("behavefile")) {
            return Eval.evalBehavefile(cmd);
        }
        if (first.equals("exec")) {
            return Eval.evalExec(cmd);
        }
        if (first.equals("var")) {
            return Eval.evalVar(cmd);
        }
        return "Eval.evalLine: Unknown command";
    }

    private static String evalGame(String[] cmd) {
        if (cmd.length > 2) {
            return "Eval.evalGame: Argument syntax error";
        }
        if (cmd[1].equals("start")) {
            return Interpreter.startGame();
        }
        if (cmd[1].equals("stop")) {
            return Interpreter.stopGame();
        }
        if (cmd[1].equals("status")) {
            return Interpreter.gameStatus();
        }
        return "Eval.evalGame: Argument syntax error";
    }

    private static String evalReload(String[] cmd) {
        return "Eval.evalReload: Not implemented yet";
    }

    private static String evalPrint(String[] cmd) {
        if (cmd.length == 1) {
            return "Eval.evalPrint: Must supply argument to 'print'";
        }
        if (cmd[1].equals("agent")) {
            if (cmd.length != 3) {
                return "Eval.evalPrint: Wrong number of argument";
            }
            int nr = Integer.parseInt(cmd[2]);
            if (nr < 1 || nr > WorldModel.players) {
                return "Eval.evalPrint: Player number outside range";
            }
            return Interpreter.printAgent(nr);
        }
        if (cmd[1].equals("ball")) {
            if (cmd.length != 2) {
                return "Eval.evalPrint: Wrong number of argument";
            }
            return Interpreter.printBall();
        }
        if (cmd[1].equals("opponent")) {
            if (cmd.length != 3) {
                return "Eval.evalPrint: Wrong number of argument";
            }
            int nr = Integer.parseInt(cmd[2]);
            if (nr < 1 || nr > WorldModel.players) {
                return "Eval.evalPrint: Player number outside range";
            }
            return Interpreter.printOpponent(nr);
        }
        return "Eval.evalPrint: Unknown argument";
    }

    private static String evalSet(String[] cmd) {
        if (cmd.length != 4 && cmd.length != 5) {
            return "Eval.evalSet: Wrong number of arguments to command 'set'";
        }
        if (cmd[1].equals("all")) {
            if (cmd[2].equals("var")) {
                if (cmd.length != 5) {
                    return "Eval.evalSet: Wrong number of arguments to command 'set'";
                }
                return Interpreter.setAllVar(cmd[3], Float.parseFloat(cmd[4]));
            }
            if (cmd.length != 4) {
                return "Eval.evalSet: Wrong number of arguments to command 'set'";
            }
            if (cmd[2].equals("spec")) {
                return Interpreter.setAllAgentSpec(cmd[3]);
            }
            if (cmd[2].equals("planner")) {
                return Interpreter.setAllAgentPlanner(cmd[3]);
            }
            return "Eval.evalSet: Can't set that";
        }
        int nr = Integer.parseInt(cmd[1]);
        if (nr < 1 || nr > WorldModel.players) {
            return "Eval.evalSet: Player number outside range";
        }
        if (cmd[2].equals("var")) {
            if (cmd.length != 5) {
                return "Eval.evalSet: Wrong number of arguments to command 'set'";
            }
            return Interpreter.setVar(nr, cmd[3], Float.parseFloat(cmd[4]));
        }
        if (cmd.length != 4) {
            return "Eval.evalSet: Wrong number of arguments to command 'set'";
        }
        if (cmd[2].equals("spec")) {
            return Interpreter.setAgentSpec(nr, cmd[3]);
        }
        if (cmd[2].equals("planner")) {
            return Interpreter.setAgentPlanner(nr, cmd[3]);
        }
        return "Eval.evalSet: Can't set that";
    }

    private static String evalBehave(String[] cmd) {
        if (cmd.length != 4) {
            return "Eval.evalBehave: Wrong number of arguments to cmd 'behave'";
        }
        if (cmd[1].equals("all")) {
            return Interpreter.behaveAll(cmd[2], cmd[3]);
        }
        int nr = Integer.parseInt(cmd[1]);
        if (nr < 1 || nr > WorldModel.players) {
            return "Eval.evalBehave: Player number outside range";
        }
        return Interpreter.behave(nr, cmd[2], cmd[3]);
    }

    private static String evalBehavefile(String[] cmd) {
        if (cmd.length != 3) {
            return "Eval.evalBehavefile: Wrong number of arguments to command 'behavefile'";
        }
        if (cmd[1].equals("all")) {
            return Interpreter.behaveFileAll(cmd[2]);
        }
        int nr = Integer.parseInt(cmd[1]);
        if (nr < 1 || nr > WorldModel.players) {
            return "Eval.evalBehavefile: Player number outside range";
        }
        return Interpreter.behaveFile(nr, cmd[2]);
    }

    private static String evalExec(String[] cmd) {
        if (cmd.length != 2) {
            return "Eval.evalExec: Wrong number of arguments to command 'exec'";
        }
        return Eval.evalFile(cmd[1]);
    }

    private static String evalVar(String[] cmd) {
        if (cmd.length != 3) {
            return "Eval.evalVar: Wrong number of arguments to command 'var'";
        }
        int nr = Integer.parseInt(cmd[1]);
        if (nr < 1 || nr > WorldModel.players) {
            return "Eval.evalVar: Player number outside range";
        }
        return Interpreter.getAgentVar(nr, cmd[2]);
    }

    private Eval() {
    }
}

