/*
 * Decompiled with CFR 0.152.
 */
package parserP;

import objectP.BallInfo;
import objectP.FlagInfo;
import objectP.GoalInfo;
import objectP.LineInfo;
import objectP.PlayerInfo;
import stokenizerP.STokenizer;

public class SeeInfoParser {
    String seeInfo;
    String side;
    int time;
    int playerCount;
    int goalCount;
    int flagCount;
    int lineCount;
    PlayerInfo[] players = new PlayerInfo[21];
    BallInfo ball = new BallInfo();
    GoalInfo[] goals = new GoalInfo[2];
    FlagInfo[] flags = new FlagInfo[3];
    LineInfo[] lines = new LineInfo[4];
    double[] flagdist = new double[3];

    public SeeInfoParser() {
    }

    public SeeInfoParser(String si, String s) {
        this.setInfo(si);
        this.setSide(s);
        this.parseInfo();
    }

    public void setInfo(String si) {
        this.seeInfo = si;
    }

    public void setSide(String s) {
        this.side = s;
    }

    public void parseInfo() {
        this.ball = null;
        this.playerCount = 0;
        this.goalCount = 0;
        this.flagCount = 0;
        this.lineCount = 0;
        STokenizer tokenizer = new STokenizer(this.seeInfo);
        String token = tokenizer.nextSToken();
        this.flagdist[0] = 160.0;
        this.flagdist[1] = 160.0;
        this.flagdist[2] = 160.0;
        this.flags[0] = null;
        this.flags[1] = null;
        this.flags[2] = null;
        int i = 0;
        while (i < 3) {
            this.flags[i] = new FlagInfo(1000.0, 0.0);
            ++i;
        }
        token = tokenizer.nextSToken();
        this.time = Integer.valueOf(token);
        while (tokenizer.hasMoreSTokens()) {
            token = tokenizer.nextSToken();
            if (token.startsWith("((p") || token.startsWith("((P")) {
                this.players[this.playerCount] = this.parsePlayerInfo(token);
                ++this.playerCount;
                continue;
            }
            if (token.startsWith("((f") || token.startsWith("((F")) {
                this.parseFlagInfo(token, this.side);
                continue;
            }
            if (token.startsWith("((g") || token.startsWith("((G")) {
                this.goals[this.goalCount] = this.parseGoalInfo(token, this.side);
                ++this.goalCount;
                continue;
            }
            if (token.startsWith("((l") || token.startsWith("((L")) {
                this.lines[this.lineCount] = this.parseLineInfo(token);
                ++this.lineCount;
                continue;
            }
            if (!token.startsWith("((b") && !token.startsWith("((B")) continue;
            this.ball = this.parseBallInfo(token);
            this.ball.setTime(this.time);
        }
    }

    PlayerInfo parsePlayerInfo(String info) {
        PlayerInfo playerInfo;
        int uniformNum = 0;
        String teamname = "";
        STokenizer tokenizer = new STokenizer(info);
        String token = tokenizer.nextSToken();
        STokenizer typeTokenizer = new STokenizer(token);
        token = typeTokenizer.nextSToken();
        if (typeTokenizer.hasMoreSTokens()) {
            teamname = typeTokenizer.nextSToken();
            if (teamname.startsWith("\"")) {
                teamname = teamname.substring(1, teamname.length() - 1);
            }
            if (typeTokenizer.hasMoreSTokens()) {
                uniformNum = Integer.valueOf(typeTokenizer.nextSToken());
            }
        }
        double dist = Double.valueOf(tokenizer.nextSToken());
        double dir = Double.valueOf(tokenizer.nextSToken());
        if (tokenizer.hasMoreSTokens()) {
            double distChange = Double.valueOf(tokenizer.nextSToken());
            double dirChange = Double.valueOf(tokenizer.nextSToken());
            if (tokenizer.hasMoreSTokens()) {
                double bodyFaceDir = Double.valueOf(tokenizer.nextSToken());
                double headFaceDir = Double.valueOf(tokenizer.nextSToken());
                playerInfo = new PlayerInfo(dist, dir, distChange, dirChange, bodyFaceDir, headFaceDir);
            } else {
                playerInfo = new PlayerInfo(dist, dir, distChange, dirChange);
            }
        } else {
            playerInfo = new PlayerInfo(dist, dir);
        }
        playerInfo.setTeamname(teamname);
        playerInfo.setUniformNum(uniformNum);
        return playerInfo;
    }

    void parseFlagInfo(String info, String side) {
        STokenizer tokenizer = new STokenizer(info);
        String token = tokenizer.nextSToken();
        STokenizer typeTokenizer = new STokenizer(token);
        token = typeTokenizer.nextSToken();
        int count = 2;
        double dist = Double.valueOf(tokenizer.nextSToken());
        if (dist > this.flags[count].getDist()) {
            return;
        }
        if (dist < this.flags[count - 1].getDist()) {
            this.flags[count--] = this.flags[count];
            if (dist < this.flags[count - 1].getDist()) {
                this.flags[count--] = this.flags[count];
            }
        }
        if (this.flagCount < 3) {
            ++this.flagCount;
        }
        double dir = Double.valueOf(tokenizer.nextSToken());
        token = typeTokenizer.nextSToken();
        this.flags[count] = null;
        if (token.equals("c")) {
            if (typeTokenizer.hasMoreSTokens()) {
                token = typeTokenizer.nextSToken();
                this.flags[count] = new FlagInfo(dist, dir, "c", token, side);
            } else {
                this.flags[count] = new FlagInfo(dist, dir);
            }
        } else if (token.equals("p") || token.equals("g")) {
            String loc1 = typeTokenizer.nextSToken();
            String loc2 = typeTokenizer.nextSToken();
            this.flags[count] = new FlagInfo(dist, dir, token, loc1, loc2, side);
        } else if (token.equals("l") || token.equals("r")) {
            String loc1 = token;
            String loc2 = typeTokenizer.nextSToken();
            if (loc2.equals("0")) {
                this.flags[count] = new FlagInfo(dist, dir, loc1, loc2, side);
            } else if (typeTokenizer.hasMoreSTokens()) {
                int pitch = Integer.valueOf(typeTokenizer.nextSToken());
                this.flags[count] = new FlagInfo(dist, dir, loc1, loc2, pitch, side);
            } else {
                this.flags[count] = new FlagInfo(dist, dir, loc1, loc2, side);
            }
        } else if (token.equals("t") || token.equals("b")) {
            String loc1 = token;
            String loc2 = typeTokenizer.nextSToken();
            if (loc2.equals("0")) {
                this.flags[count] = new FlagInfo(dist, dir, loc1, side);
            } else {
                int pitch = Integer.valueOf(typeTokenizer.nextSToken());
                this.flags[count] = new FlagInfo(dist, dir, loc1, loc2, pitch, side);
            }
        } else {
            this.flags[count] = new FlagInfo(dist, dir);
        }
    }

    GoalInfo parseGoalInfo(String info, String side) {
        STokenizer tokenizer = new STokenizer(info);
        String token = tokenizer.nextSToken();
        STokenizer typeTokenizer = new STokenizer(token);
        token = typeTokenizer.nextSToken();
        double dist = Double.valueOf(tokenizer.nextSToken());
        double dir = Double.valueOf(tokenizer.nextSToken());
        token = typeTokenizer.nextSToken();
        GoalInfo goalInfo = new GoalInfo(dist, dir, token, side);
        return goalInfo;
    }

    LineInfo parseLineInfo(String info) {
        STokenizer tokenizer = new STokenizer(info);
        String token = tokenizer.nextSToken();
        STokenizer typeTokenizer = new STokenizer(token);
        token = typeTokenizer.nextSToken();
        double dist = Double.valueOf(tokenizer.nextSToken());
        double dir = Double.valueOf(tokenizer.nextSToken());
        token = typeTokenizer.nextSToken();
        LineInfo lineInfo = new LineInfo(dist, dir, token);
        return lineInfo;
    }

    BallInfo parseBallInfo(String info) {
        BallInfo ballInfo;
        STokenizer tokenizer = new STokenizer(info);
        String token = tokenizer.nextSToken();
        STokenizer typeTokenizer = new STokenizer(token);
        token = typeTokenizer.nextSToken();
        double dist = Double.valueOf(tokenizer.nextSToken());
        double dir = Double.valueOf(tokenizer.nextSToken());
        if (tokenizer.hasMoreSTokens()) {
            double distChange = Double.valueOf(tokenizer.nextSToken());
            double dirChange = Double.valueOf(tokenizer.nextSToken());
            ballInfo = new BallInfo(dist, dir, distChange, dirChange);
        } else {
            ballInfo = new BallInfo(dist, dir);
        }
        return ballInfo;
    }

    public int getTime() {
        return this.time;
    }

    public int getPlayerNum() {
        return this.playerCount;
    }

    public int getGoalNum() {
        return this.goalCount;
    }

    public int getFlagNum() {
        return this.flagCount;
    }

    public int getLineNum() {
        return this.lineCount;
    }

    public boolean hasBallInfo() {
        return this.ball != null;
    }

    public PlayerInfo getPlayerInfo(int n) {
        return this.players[n];
    }

    public GoalInfo getGoalInfo(int n) {
        return this.goals[n];
    }

    FlagInfo getFlagInfo(int n) {
        return this.flags[n];
    }

    public LineInfo getLineInfo(int n) {
        return this.lines[n];
    }

    public BallInfo getBallInfo() {
        return this.ball;
    }

    public PlayerInfo[] getPlayers() {
        return this.players;
    }

    public FlagInfo[] getFlags() {
        return this.flags;
    }
}

