/*
 * Decompiled with CFR 0.152.
 */
package objectP;

import java.awt.geom.Point2D;
import objectP.ObjectInfo;

public class PlayerInfo
extends ObjectInfo {
    String teamname;
    int uniformNum;
    double bodyAbsDir;
    double headAbsDir;
    double headRelDir;

    public PlayerInfo() {
        super(0.0, 0.0);
        this.teamname = "";
        this.uniformNum = 0;
        this.setCertainty(0.0);
        this.setRand(0.1);
    }

    public PlayerInfo(String team, int uNum) {
        super(0.0, 0.0);
        this.teamname = team;
        this.uniformNum = uNum;
        this.setCertainty(0.0);
        this.setRand(0.1);
    }

    public PlayerInfo(double distance, double direction) {
        super(distance, direction);
        this.teamname = "";
        this.uniformNum = 0;
    }

    public PlayerInfo(double distance, double direction, double distanceChange, double directionChange) {
        super(distance, direction, distanceChange, directionChange);
        this.teamname = "";
        this.uniformNum = 0;
    }

    public PlayerInfo(double distance, double direction, double distanceChange, double directionChange, double bodyFaceDirection, double headFaceDirection) {
        super(distance, direction, distanceChange, directionChange);
        this.bodyAbsDir = bodyFaceDirection;
        this.headAbsDir = headFaceDirection;
        this.teamname = "";
        this.uniformNum = 0;
    }

    public void setTeamname(String tname) {
        this.teamname = tname;
    }

    public String getTeamname() {
        return this.teamname;
    }

    public void setUniformNum(int uNum) {
        this.uniformNum = uNum;
    }

    public int getUniformNum() {
        return this.uniformNum;
    }

    public void setPlayerInfo(int Time, double Dist, double Dir) {
        this.controlTime = Time;
        this.seenTime = Time;
        this.dist = Dist;
        this.dir = Dir;
        this.setRand(0.1);
        this.setCertainty(1.0);
    }

    public void setPlayerInfo(int Time, double Dist, double Dir, double DistChng, double DirChng) {
        this.controlTime = Time;
        this.seenTime = Time;
        this.dist = Dist;
        this.dir = Dir;
        this.distChange = DistChng;
        this.dirChange = DirChng;
        this.setRand(0.1);
        this.setCertainty(1.0);
    }

    public void setPlayerInfo(int Time, double Dist, double Dir, double DistChng, double DirChng, double bodyDir, double headDir) {
        this.controlTime = Time;
        this.seenTime = Time;
        this.dist = Dist;
        this.dir = Dir;
        this.distChange = DistChng;
        this.dirChange = DirChng;
        this.bodyAbsDir = bodyDir;
        this.headAbsDir = headDir;
        this.setRand(0.1);
        this.setCertainty(1.0);
    }

    public void advancePlayerInfo(int filedTime) {
        double uy;
        double ux;
        if (filedTime == this.controlTime) {
            return;
        }
        if (this.getCertainty2()) {
            ux = this.vel.getX() + this.acc.getX();
            uy = this.vel.getY() + this.acc.getY();
            this.pos.setLocation(this.pos.getX() + ux, this.pos.getY() + uy);
            this.vel.setLocation(ux * this.decay, uy * this.decay);
            this.acc.setLocation(0.0, 0.0);
            this.certainty *= this.conf_decay;
            ++this.controlTime;
        }
        while (filedTime - this.controlTime != 0) {
            if (this.getCertainty2()) {
                ux = this.vel.getX();
                uy = this.vel.getY();
                this.pos.setLocation(this.pos.getX() + ux, this.pos.getY() + uy);
                this.vel.setLocation(ux * this.decay, uy * this.decay);
                this.certainty *= this.conf_decay;
            }
            ++this.controlTime;
        }
    }

    @Override
    public double getPredX(int t) {
        double predX = this.pos.getX();
        double predVX = this.vel.getX();
        int i = 0;
        while (i < t) {
            predX += predVX;
            predVX *= this.decay;
            ++i;
        }
        return predX;
    }

    @Override
    public double getPredY(int t) {
        double predY = this.pos.getY();
        double predVY = this.vel.getY();
        int i = 0;
        while (i < t) {
            predY += predVY;
            predVY *= this.decay;
            ++i;
        }
        return predY;
    }

    public Point2D getPredPos(int t) {
        return new Point2D.Double(this.getPredX(t), this.getPredY(t));
    }

    public void setHeadAbsDir(double had) {
        this.headAbsDir = had;
    }

    public void setHeadRelDir(double hrd) {
        this.headRelDir = hrd;
    }

    public void setBodyAbsDir(double bad) {
        this.bodyAbsDir = bad;
    }

    public double getHeadAbsDir() {
        return this.headAbsDir;
    }

    public double getBodyAbsDir() {
        return this.bodyAbsDir;
    }

    public double getHeadRelDir() {
        return this.headRelDir;
    }
}

