/*
 * Decompiled with CFR 0.152.
 */
package Strategy;

import Analyzer.Goal;
import Analyzer.GoalAnalyzer;
import Analyzer.InterceptAnalyzer;
import Analyzer.PlayModeAnalyzer;
import Analyzer.Shoot;
import Analyzer.ShootAnalyzer;
import Analyzer.StrategyRelayEvaluater;
import Strategy.BaseStrategy;
import java.util.Observable;

public class BallClearStrategy
extends BaseStrategy {
    boolean sideClear = false;
    boolean forwordClear = false;
    boolean outOfBounds = false;
    boolean continueCounter = false;
    boolean intercepted = false;
    boolean shooted = false;
    boolean goaled = false;

    public BallClearStrategy(int time, int unum, StrategyRelayEvaluater sre, String type) {
        super(time, unum, sre, type);
    }

    @Override
    public int update(Observable o, Object arg) {
        if (o instanceof PlayModeAnalyzer) {
            PlayModeAnalyzer pma = (PlayModeAnalyzer)o;
            int mode = pma.getCurrentPlayMode();
            if (pma.getInformation() == 1 && mode != 14 && mode != 15) {
                if (mode == 6 || mode == 7) {
                    this.outOfBounds = true;
                }
                this.evaluate();
                return 0;
            }
        } else if (o instanceof GoalAnalyzer) {
            Goal goal = (Goal)arg;
            System.out.println("goal side = " + goal.getSide());
            if (goal.getSide() == 1) {
                this.goaled = true;
                this.evaluate();
                return 0;
            }
        } else if (o instanceof ShootAnalyzer) {
            Shoot shoot = (Shoot)arg;
            if (shoot.getSide() == 1) {
                this.shooted = true;
                return 1;
            }
        } else if (o instanceof InterceptAnalyzer) {
            this.intercepted = true;
            return 1;
        }
        return 1;
    }

    @Override
    public void evaluate(String str) {
        if (str.equals("counter")) {
            this.continueCounter = true;
        }
        this.evaluate();
    }

    @Override
    public void evaluate() {
        double ballx = this.sre.bsi.ball.x;
        double bally = this.sre.bsi.ball.y;
        if (ballx >= -25.0) {
            this.forwordClear = true;
        }
        if (bally >= 18.0 || bally <= -18.0) {
            this.sideClear = true;
        }
        this.print();
    }

    @Override
    public String getResult() {
        String str = new String();
        str = this.sideClear ? String.valueOf(str) + "Y" : String.valueOf(str) + "N";
        str = this.forwordClear ? String.valueOf(str) + "Y" : String.valueOf(str) + "N";
        str = this.outOfBounds ? String.valueOf(str) + "Y" : String.valueOf(str) + "N";
        str = this.continueCounter ? String.valueOf(str) + "Y" : String.valueOf(str) + "N";
        str = this.intercepted ? String.valueOf(str) + "Y" : String.valueOf(str) + "N";
        str = this.shooted ? String.valueOf(str) + "Y" : String.valueOf(str) + "N";
        str = this.goaled ? String.valueOf(str) + "Y" : String.valueOf(str) + "N";
        return str;
    }

    public void print() {
        System.out.println("sideClear" + this.sideClear);
        System.out.println("forwardClear" + this.forwordClear);
        System.out.println("outOfBounds" + this.outOfBounds);
        System.out.println("continueCounter" + this.continueCounter);
        System.out.println("intercepted" + this.intercepted);
        System.out.println("shooted" + this.shooted);
        System.out.println("goaled" + this.goaled);
    }
}

