/*
 * Decompiled with CFR 0.152.
 */
package Interface;

import Information.BallInformation;
import Information.CParam;
import Information.PlayerInformation;
import Information.Team;
import Interface.CoachInterface;
import java.io.EOFException;
import java.io.IOException;
import java.util.StringTokenizer;

public class CoachMessageParser {
    CoachInterface parent;
    static int reverse = 1;
    String message;
    public static final int SEE = 1;
    public static final int HEAR_REFEREE = 2;
    public static final int HEAR_MY_TEAM = 3;
    public static final int HEAR_OPP_TEAM = 4;
    public static final int ACK = 5;

    public CoachMessageParser(CoachInterface parent) {
        this.parent = parent;
    }

    public int parse(String message) throws IOException, EOFException {
        StringTokenizer strtk = new StringTokenizer(message = message.trim(), " ()");
        String firstWord = strtk.nextToken();
        if (firstWord.equals("hear")) {
            this.message = message;
            return this.parseHearInformation(strtk);
        }
        if (firstWord.equals("see")) {
            this.parseVisualInformation(strtk);
            return 1;
        }
        if (firstWord.equals("ok")) {
            String secondWord = strtk.nextToken();
            if (secondWord.equals("say")) {
                System.out.println(message);
                this.parent.retAck = true;
                return 5;
            }
            if (secondWord.equals("ear")) {
                return 5;
            }
        }
        return -1;
    }

    protected void parseVisualInformation(StringTokenizer strtk) {
        int currentTime;
        this.parent.bsi.time = currentTime = new Integer(strtk.nextToken()).intValue();
        int i = 1;
        while (i <= 8) {
            strtk.nextToken();
            ++i;
        }
        strtk.nextToken();
        BallInformation ball = this.parent.bsi.ball;
        ball.x = new Float(strtk.nextToken()).floatValue() * (float)reverse;
        ball.y = new Float(strtk.nextToken()).floatValue() * (float)reverse;
        int i2 = 1;
        while (i2 <= 2) {
            strtk.nextToken();
            ++i2;
        }
        if (!strtk.hasMoreTokens()) {
            return;
        }
        boolean first = true;
        while (strtk.hasMoreTokens()) {
            int side;
            strtk.nextToken();
            String teamName = strtk.nextToken();
            int unum = new Integer(strtk.nextToken());
            if (CoachInterface.myTeamName.equals(teamName)) {
                if (first) {
                    reverse = 1;
                    first = false;
                    this.parent.isMyTeamLeft = true;
                }
                side = 0;
            } else {
                if (first) {
                    this.parent.eneTeamName = teamName;
                    Team cfr_ignored_0 = this.parent.bsi.team[1];
                    Team.name = teamName;
                    reverse = -1;
                    first = false;
                    this.parent.isMyTeamLeft = false;
                }
                side = 1;
            }
            Team cfr_ignored_1 = this.parent.bsi.team[0];
            Team.name = CoachInterface.myTeamName;
            Team cfr_ignored_2 = this.parent.bsi.team[1];
            Team.name = this.parent.eneTeamName;
            PlayerInformation p = this.parent.bsi.team[side].player[unum - 1];
            p.x = new Float(strtk.nextToken()).floatValue() * (float)reverse;
            p.y = new Float(strtk.nextToken()).floatValue() * (float)reverse;
            p.enable = 1;
            p.unum = unum;
            p.angle = new Integer(strtk.nextToken()).intValue();
            int i3 = 1;
            while (i3 <= 3) {
                strtk.nextToken();
                ++i3;
            }
        }
    }

    protected int parseHearInformation(StringTokenizer strtk) throws IOException {
        this.parent.bhi.time = new Integer(strtk.nextToken());
        String direction = strtk.nextToken();
        if (!direction.equals("referee")) {
            if (direction.equals("player")) {
                String team = strtk.nextToken();
                if (team.equals(CoachInterface.myTeamName)) {
                    this.parent.bhi.message = this.message;
                    return 3;
                }
                this.parent.bhi.message = this.message;
                return 4;
            }
        } else {
            String pmode = strtk.nextToken();
            System.out.println(pmode);
            this.parsePlayMode(pmode);
            return 2;
        }
        return 0;
    }

    protected void parsePlayMode(String pmode) {
        StringTokenizer stk = new StringTokenizer(pmode, "_");
        String firstToken = stk.nextToken();
        String secondToken = "";
        if (stk.hasMoreTokens()) {
            secondToken = stk.nextToken();
        }
        if (firstToken.equals("goal") && !secondToken.equals("kick")) {
            stk = new StringTokenizer(pmode, "_");
            stk.nextToken();
            this.parseGoal(stk);
        } else if (pmode.equals("before_kick_off")) {
            this.parent.bsi.play_mode = 1;
            this.waitForKickOff();
        } else if (pmode.equals("half_time")) {
            this.parent.bsi.play_mode = 1;
            this.endHalfGame();
        } else if (pmode.equals("time_up")) {
            this.parent.bsi.play_mode = 2;
            this.endGame();
        } else if (!pmode.equals("foul_r") && !pmode.equals("foul_l")) {
            if (pmode.equals("free_kick_r") || pmode.equals("free_kick_l")) {
                stk = new StringTokenizer(pmode, "_");
                stk.nextToken();
                stk.nextToken();
                this.parseFreekick(stk);
            } else {
                int i = 3;
                while (i < CParam.PLAYMODE_STRINGS.length) {
                    if (CParam.PLAYMODE_STRINGS[i].equals(pmode)) {
                        this.parent.bsi.play_mode = i;
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    protected void waitForKickOff() {
        System.out.println("wait kick off");
    }

    protected void endHalfGame() {
    }

    protected void endGame() {
        this.close();
    }

    protected void parseGoal(StringTokenizer stk) {
        String sideChar = stk.nextToken();
        System.out.println(sideChar);
        if (!this.parent.isMyTeamLeft) {
            sideChar = sideChar.equals("l") ? "r" : "l";
        }
        System.out.println(sideChar);
        if (sideChar.equals("l")) {
            this.parent.bsi.team[0].score = new Integer(stk.nextToken());
            this.parent.bsi.play_mode = 14;
        } else if (sideChar.equals("r")) {
            this.parent.bsi.team[1].score = new Integer(stk.nextToken());
            this.parent.bsi.play_mode = 15;
            System.out.println("enegoal");
        } else {
            new IllegalArgumentException("Illegal Argument:" + sideChar);
        }
    }

    protected void parseFreekick(StringTokenizer stk) {
        String sideChar = stk.nextToken();
        if (!this.parent.isMyTeamLeft) {
            sideChar = sideChar.equals("l") ? "r" : "l";
        }
        if (sideChar.equals("l")) {
            this.parent.bsi.play_mode = 8;
        } else if (sideChar.equals("r")) {
            this.parent.bsi.play_mode = 9;
        } else {
            new IllegalArgumentException("Illegal Argument:" + sideChar);
        }
    }

    public void close() {
    }
}

