/*
 * Decompiled with CFR 0.152.
 */
package Interface;

import Information.Team;
import Interface.BaseInterface;
import Interface.CoachMessageParser;
import Interface.CoachMessageParserForVer6x;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CoachInterface
extends BaseInterface {
    public static String host;
    public static String myTeamName;
    String eneTeamName = "Unknown";
    int port;
    int version;
    protected boolean isMyTeamLeft;
    public InetAddress iAddress;
    public DatagramSocket socket;
    public CoachMessageParser cmp;
    public Vector sendMessages;
    public boolean retAck;
    public static final int PACKET_SIZE = 4096;

    public CoachInterface(String host, int port, String myTeamName, int version) {
        CoachInterface.host = host;
        this.port = port;
        CoachInterface.myTeamName = myTeamName;
        this.version = version;
        this.sendMessages = new Vector();
    }

    public void init() {
        this.init_socket();
        try {
            if (this.version == 6) {
                this.cmp = new CoachMessageParserForVer6x(this);
                this.connectSoccerServerOverVer6();
                this.getEneTeamName();
            } else {
                this.cmp = new CoachMessageParser(this);
                this.connectSoccerServerUnderVer5();
            }
            this.send_eye_on();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void init_socket() {
        try {
            this.iAddress = InetAddress.getByName(host);
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(0);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.socket.close();
        this.socket = null;
    }

    private void connectSoccerServerUnderVer5() throws IOException {
        this.send_info("(init " + myTeamName + ")");
        byte[] buffer = new byte[4096];
        DatagramPacket packet = new DatagramPacket(buffer, 4096);
        this.socket.receive(packet);
        String s = new String(buffer).trim();
        if (!s.equals("(init ok)")) {
            System.err.println("connection failed");
            new IOException(s);
        }
        this.port = packet.getPort();
    }

    private void connectSoccerServerOverVer6() throws IOException {
        this.send_info("(init " + myTeamName + " (version 6.00))");
        byte[] buffer = new byte[4096];
        DatagramPacket packet = new DatagramPacket(buffer, 4096);
        this.socket.receive(packet);
        String s = new String(buffer).trim();
        StringTokenizer strtk = new StringTokenizer(s, " ()");
        String[] strs = new String[]{strtk.nextToken(), strtk.nextToken(), strtk.nextToken()};
        if (strs[0].equals("init") && strs[2].equals("ok")) {
            if (strs[1].equals("l")) {
                this.isMyTeamLeft = true;
                CoachMessageParser.reverse = 1;
                System.out.println("My Team is left");
            } else {
                this.isMyTeamLeft = false;
                CoachMessageParser.reverse = -1;
                System.out.println("My Team is right");
            }
        }
        this.port = packet.getPort();
    }

    protected void getEneTeamName() throws IOException {
        String message = new String();
        while (true) {
            this.send_teamname_command();
            message = this.getMessageFromSoccerServer();
            StringTokenizer strtk = new StringTokenizer(message, " ()");
            String s1 = strtk.nextToken();
            if (s1.equals("hear")) {
                strtk.nextToken();
                if (strtk.nextToken().equals("referee")) {
                    this.getMessageFromSoccerServer();
                    break;
                }
            } else if (s1.equals("ok") && strtk.nextToken().equals("team_names")) {
                int i = 1;
                while (i <= 2) {
                    strtk.nextToken();
                    ++i;
                }
                String team1 = strtk.nextToken();
                if (!team1.equals(myTeamName)) {
                    Team cfr_ignored_0 = this.bsi.team[1];
                    Team.name = team1;
                    this.eneTeamName = team1;
                    System.out.println("opp team is " + this.eneTeamName);
                    break;
                }
                if (strtk.hasMoreTokens()) {
                    int i2 = 1;
                    while (i2 <= 2) {
                        strtk.nextToken();
                        ++i2;
                    }
                    Team cfr_ignored_1 = this.bsi.team[1];
                    Team.name = this.eneTeamName = strtk.nextToken();
                    System.out.println("opp team is " + this.eneTeamName);
                    break;
                }
            }
            try {
                CoachInterface.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void send_teamname_command() {
        this.send_info("(team_names)");
    }

    protected void send_eye_on() throws IOException {
        this.send_info("(eye on)");
        String s = this.getMessageFromSoccerServer();
        if (!s.equals("(ok eye on)")) {
            System.err.println("send eye on failed");
            new IOException(s);
        }
    }

    protected boolean send_info(String msg) {
        if (this.socket == null) {
            return false;
        }
        int msglen = msg.length();
        byte[] message = new byte[msglen];
        message = msg.getBytes();
        DatagramPacket packet = new DatagramPacket(message, msglen, this.iAddress, this.port);
        try {
            this.socket.send(packet);
            this.retAck = false;
            return true;
        }
        catch (IOException e) {
            System.err.println("Coach send error " + msg);
            e.printStackTrace();
            return false;
        }
    }

    public String getMessageFromSoccerServer() throws IOException, SocketException {
        byte[] buffer = new byte[4096];
        DatagramPacket packet = new DatagramPacket(buffer, 4096);
        this.socket.setSoTimeout(120);
        this.socket.receive(packet);
        return new String(buffer).trim();
    }

    @Override
    public void run() {
        while (true) {
            try {
                String message = this.getMessageFromSoccerServer();
                int ret = this.cmp.parse(message);
            }
            catch (EOFException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                CoachInterface.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] argv) {
        CoachInterface ci = new CoachInterface("kiyosu", 6002, "Saboten-Ice", 5);
        ci.init();
        ci.start();
    }

    public Vector getSendMessages() {
        return this.sendMessages;
    }
}

