/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import Analyzer.FormationAnalyzer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Observable;
import java.util.Observer;

public class KeiseiGraph
extends Canvas
implements Observer {
    Image buff = null;
    Image backField = null;
    Graphics gbuff;
    Graphics gbf;
    int width = 650;
    int height = 200;
    int gwidth = 300;
    int gheight = 200;
    int score;
    int time = 0;
    double SCALE_X = (double)this.gwidth / 6000.0;

    public KeiseiGraph() {
        this.setSize(this.width, this.height);
        this.setBackground(Color.white);
    }

    public KeiseiGraph(FormationAnalyzer fa) {
        this();
        fa.addObserver(this);
    }

    public KeiseiGraph(int width, int height) {
        this.width = width;
        this.height = height;
        this.setSize(width, height);
        this.setBackground(Color.white);
    }

    @Override
    public void paint(Graphics g) {
        if (this.buff == null) {
            this.buff = this.createImage(this.width, this.height);
            this.gbuff = this.buff.getGraphics();
        }
        if (this.backField == null) {
            this.backField = this.createImage(this.width, this.height);
            this.gbf = this.backField.getGraphics();
            this.setBackField(this.gbf);
            this.gbuff.drawImage(this.backField, 0, 0, this);
        }
        g.drawImage(this.buff, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void update(Observable o, Object arg) {
        System.out.println("called 1");
        if (o instanceof FormationAnalyzer) {
            System.out.println("called 2");
            this.draw((FormationAnalyzer)o);
            this.repaint();
        }
    }

    public void drawBackField() {
        this.gbuff.drawImage(this.backField, 0, 0, this);
    }

    public void clearGraphicsBuffer() {
        this.buff = null;
        this.backField = null;
    }

    public void createGraphicsBuffer() {
        this.buff = this.createImage(this.width, this.height);
        this.gbuff = this.buff.getGraphics();
        this.backField = this.createImage(this.width, this.height);
        this.gbf = this.backField.getGraphics();
        this.setBackField(this.gbf);
        this.gbuff.drawImage(this.backField, 0, 0, this);
    }

    private void setBackField(Graphics gb) {
        Font defFont = gb.getFont();
        gb.setFont(new Font("b", 1, 16));
        gb.setColor(Color.black);
        gb.drawRect(0, 0, this.gwidth - 1, this.gheight - 1);
        gb.drawLine(0, this.gheight / 2, this.gwidth, this.gheight / 2);
        gb.drawString("+", this.gwidth - 20, 20);
        gb.drawString("-", this.gwidth - 20, this.gheight - 20);
        int fontSize = 12;
        int lineLength = 20;
        gb.setFont(new Font("a", 1, fontSize));
        gb.setColor(Color.blue);
        gb.drawLine(this.gwidth + 10, 40 - fontSize - 5, this.gwidth + 10 + lineLength, 40 - fontSize - 5);
        gb.drawString("POSSESSION PERCENTAGE", this.gwidth, 40);
        gb.setColor(Color.red);
        gb.drawLine(this.gwidth + 10, 70 - fontSize - 5, this.gwidth + 10 + lineLength, 70 - fontSize - 5);
        gb.drawString("RATE OF BALL IN OUR FIELD", this.gwidth, 70);
        gb.setFont(defFont);
    }

    public Dimension getPreffererdSize() {
        return this.getSize();
    }

    public void draw(FormationAnalyzer fa) {
        double ball_pos = fa.getMyTeamPos();
        double ball_pos0 = fa.getBeforeMyTeamPos();
        double pos_percent = fa.getPosPercentage();
        double pos_percent0 = fa.getBeforePosPercentage();
        int time = fa.getTime();
        int time0 = fa.getBeforeTime();
        this.gbuff.setColor(Color.blue);
        this.gbuff.drawLine(this.fitScaleX(time0), this.fitScaleY(pos_percent0 * 100.0, 100, 0), this.fitScaleX(time), this.fitScaleY(pos_percent * 100.0, 100, 0));
        this.gbuff.setColor(Color.red);
        this.gbuff.drawLine(this.fitScaleX(time0), this.fitScaleY(ball_pos0 * 100.0, 100, 0), this.fitScaleX(time), this.fitScaleY(ball_pos * 100.0, 100, 0));
    }

    private int fitScaleX(int x) {
        System.out.println("x=" + (double)x * this.SCALE_X);
        return (int)((double)x * this.SCALE_X);
    }

    private int fitScaleY(double val, int max, int min) {
        System.out.println("val = " + val);
        int y = (int)((double)this.gheight - (val - (double)min) * (double)this.gheight / (double)(max - min));
        if (y < 1) {
            y = 1;
        } else if (y >= this.gheight) {
            y = this.gheight - 1;
        }
        return y;
    }

    public static void main(String[] arg) {
        Frame f = new Frame();
        KeiseiGraph kg = new KeiseiGraph();
        f.add(kg);
        f.setVisible(true);
    }
}

