/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.PlayerLocationAnalyzer;
import Information.BaseSeeInformation;
import java.util.Observable;

public class StaminaAnalyzer
extends Analyzer {
    BaseSeeInformation bsi;
    PlayerLocationAnalyzer pla;
    boolean[] staminaLack = new boolean[11];
    int[] counter = new int[11];
    public static boolean VERBOSE = false;
    public static final int SIKIICHI = 5;

    public StaminaAnalyzer(BaseSeeInformation bsi, PlayerLocationAnalyzer pla) {
        this.bsi = bsi;
        this.pla = pla;
        pla.addObserver(this);
        int i = 0;
        while (i <= 10) {
            this.staminaLack[i] = false;
            this.counter[i] = 0;
            ++i;
        }
    }

    public void analyze() {
        int i = 1;
        while (i <= 11) {
            double speed = this.pla.getSpeed(0, i);
            double angle = this.bsi.team[0].player[i - 1].angle;
            double angleToBall = this.pla.getDegAngleToBall(0, i);
            double toBallDist = this.pla.getToBallDistance(0, i);
            double diff = angleToBall - angle;
            if (diff > 180.0) {
                diff = 360.0 - diff;
            } else if (diff < -180.0) {
                diff += 360.0;
            }
            if (Math.abs(diff) < 30.0 && speed <= 0.24 && speed != 0.0 && toBallDist <= 13.0) {
                int n = i - 1;
                this.counter[n] = this.counter[n] + 1;
            } else if (speed >= 0.5) {
                this.counter[i - 1] = 0;
            }
            if (this.counter[i - 1] >= 5 && VERBOSE) {
                System.out.println(String.valueOf(i) + "stamina lacked!!!");
            }
            ++i;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.bsi.play_mode == 3) {
            this.analyze();
        }
    }

    public boolean isStaminaLack(int unum) {
        return this.counter[unum - 1] >= 5;
    }
}

