/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.MessageSender;
import Analyzer.PlayModeAnalyzer;
import Analyzer.StaminaAnalyzer;
import Information.BaseSeeInformation;
import Information.PlayerInformation;
import Utility.DPoint;
import Utility.Triangle;
import Utility.Utility;
import java.util.Observable;

public class OurGoalKickAnalyzer
extends Analyzer {
    BaseSeeInformation bsi;
    PlayModeAnalyzer pma;
    MessageSender ms;
    static DPoint[] preset = new DPoint[]{new DPoint(-40.0, -16.0), new DPoint(-40.0, -12.0), new DPoint(-40.0, -8.0), new DPoint(-40.0, 8.0), new DPoint(-40.0, 12.0), new DPoint(-40.0, -16.0)};
    static DPoint[] preset2 = new DPoint[]{new DPoint(-42.0, -12.0), new DPoint(-42.0, 12.0)};
    static DPoint[] kpreset2 = new DPoint[]{new DPoint(-30.0, -30.0), new DPoint(-30.0, 30.0)};
    static final int NO_VAL = -100;
    public static final boolean VERBOSE = false;
    public static final double MAX_DIST = 25.0;
    StaminaAnalyzer sa;

    public OurGoalKickAnalyzer(BaseSeeInformation bsi, PlayModeAnalyzer pma, MessageSender ms, StaminaAnalyzer sa) {
        this.bsi = bsi;
        this.pma = pma;
        this.ms = ms;
        this.sa = sa;
        pma.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        PlayModeAnalyzer pma;
        if (o instanceof PlayModeAnalyzer && (pma = (PlayModeAnalyzer)o).getCurrentPlayMode() == 8 && this.checkFreeKickAfterCatch()) {
            this.analyzeGKFreeKick();
        }
    }

    protected boolean checkFreeKickAfterCatch() {
        double gkx = this.bsi.team[0].player[0].x;
        double gky = this.bsi.team[0].player[0].y;
        double bx = this.bsi.ball.x;
        double by = this.bsi.ball.y;
        boolean flag = false;
        if (Utility.getDistance(gkx, gky, bx, by) <= 3.885) {
            flag = true;
        }
        return flag;
    }

    protected void analyzeGKFreeKick() {
        int j;
        PlayerInformation player;
        double[] val = new double[10 * preset.length];
        double[] adist = new double[10 * preset.length];
        int i = 0;
        while (i <= 9) {
            player = this.bsi.team[0].player[i + 1];
            val[i] = this.getMinDistToOppPlayer(player);
            if (val[i] <= 3.0) {
                val[i] = -100.0;
            }
            if (this.sa.isStaminaLack(i + 1)) {
                val[i] = -100.0;
            }
            ++i;
        }
        i = 0;
        while (i <= 9) {
            j = 0;
            while (j <= preset.length - 1) {
                val[i + j * 10] = val[i];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= 9) {
            player = this.bsi.team[0].player[i + 1];
            j = 0;
            while (j <= preset.length - 1) {
                double kx = OurGoalKickAnalyzer.preset[j].x;
                double ky = OurGoalKickAnalyzer.preset[j].y;
                double dist = Utility.getDistance(player.x, player.y, kx, ky);
                if (dist > 25.0 || player.x < -34.0) {
                    val[i + j * 10] = -100.0;
                }
                adist[i + j * 10] = dist;
                if (val[i + j * 10] != -100.0) {
                    if (this.checkPassCource(player.x, player.y, kx, ky, Math.toRadians(20.0))) {
                        val[i + j * 10] = val[i + j * 10] + 10.0;
                    } else if (this.checkPassCource(player.x, player.y, kx, ky, Math.toRadians(15.0))) {
                        val[i + j * 10] = val[i + j * 10] + 6.0;
                    } else if (this.checkPassCource(player.x, player.y, kx, ky, Math.toRadians(13.0))) {
                        val[i + j * 10] = val[i + j * 10] + 2.0;
                    } else if (this.checkPassCource(player.x, player.y, kx, ky, Math.toRadians(9.0))) {
                        val[i + j * 10] = val[i + j * 10] - 2.0;
                    } else {
                        val[i + j * 10] = -100.0;
                        System.out.println("iti" + j + "  player" + i + "no pass cource");
                    }
                    double katamuki = Math.abs((ky - player.y) / (kx - player.x));
                    System.out.println(katamuki);
                    if (katamuki > 0.3 && (ky > 0.0 && player.y < ky || ky < 0.0 && player.y > ky)) {
                        val[i + j * 10] = -100.0;
                    }
                    int n = i + j * 10;
                    val[n] = val[n] + Math.abs(ky / 8.0);
                }
                ++j;
            }
            ++i;
        }
        int maxIndex = -1;
        double maxVal = -100.0;
        double minDist = 10000.0;
        int i2 = 0;
        while (i2 <= 10 * preset.length - 1) {
            if (val[i2] > maxVal) {
                maxIndex = i2;
                maxVal = val[i2];
                minDist = adist[i2];
            } else if (val[i2] == maxVal && adist[i2] < minDist) {
                maxIndex = i2;
                maxVal = val[i2];
                minDist = adist[i2];
            }
            ++i2;
        }
        System.out.println("maxVal=" + maxVal + "maxIndex" + maxIndex);
        if (maxVal == -100.0) {
            int index1 = 0;
            double val2 = 0.0;
            double maxVal2 = -100.0;
            int i3 = 0;
            while (i3 <= 1) {
                double kx = OurGoalKickAnalyzer.kpreset2[i3].x;
                double ky = OurGoalKickAnalyzer.kpreset2[i3].y;
                val2 = this.getMinDistToOppPlayer(OurGoalKickAnalyzer.preset2[i3].x, OurGoalKickAnalyzer.preset2[i3].y);
                val2 = this.checkPassCource(OurGoalKickAnalyzer.preset2[i3].x, OurGoalKickAnalyzer.preset2[i3].y, kx, ky, Math.toRadians(8.0)) ? (val2 += 10.0) : (this.checkPassCource(OurGoalKickAnalyzer.preset2[i3].x, OurGoalKickAnalyzer.preset2[i3].y, kx, ky, Math.toRadians(6.0)) ? (val2 += 6.0) : (this.checkPassCource(OurGoalKickAnalyzer.preset2[i3].x, OurGoalKickAnalyzer.preset2[i3].y, kx, ky, Math.toRadians(4.0)) ? (val2 += 2.0) : (val2 -= 2.0)));
                if (maxVal2 < val2) {
                    index1 = i3;
                    maxVal2 = val2;
                }
                ++i3;
            }
            this.ms.addMessage("(GK " + OurGoalKickAnalyzer.preset2[index1].x + " " + OurGoalKickAnalyzer.preset2[index1].y + " " + OurGoalKickAnalyzer.kpreset2[index1].x + " " + OurGoalKickAnalyzer.kpreset2[index1].y + ")");
        } else {
            double x = (double)((int)(this.bsi.team[0].player[maxIndex % 10 + 1].x * 10.0)) / 10.0;
            double y = (double)((int)(this.bsi.team[0].player[maxIndex % 10 + 1].y * 10.0)) / 10.0;
            this.ms.addMessage("(GK " + OurGoalKickAnalyzer.preset[maxIndex / 10].x + " " + OurGoalKickAnalyzer.preset[maxIndex / 10].y + " " + x + " " + y + ")");
        }
    }

    protected boolean checkPassCource(double px, double py, double kx, double ky, double rad) {
        double distKtoP = Utility.getDistance(px, py, kx, ky);
        boolean flag = true;
        double theta = Math.atan2(-py + ky, px - kx);
        double dist = (distKtoP *= 1.25) / Math.cos(rad);
        double y1 = dist * Math.sin(theta + rad);
        double y2 = dist * Math.sin(theta - rad);
        double x1 = dist * Math.cos(theta + rad);
        double x2 = dist * Math.cos(theta - rad);
        Triangle tri = new Triangle(x1, y1, x2, y2, kx, ky);
        int i = 0;
        while (i <= 10) {
            PlayerInformation oppPlayer = this.bsi.team[1].player[i];
            if (tri.isInner(oppPlayer.x, oppPlayer.y)) {
                flag = false;
                i = 10;
            }
            ++i;
        }
        return flag;
    }

    protected double getMinDistToOppPlayer(PlayerInformation p) {
        double px = p.x;
        double py = p.y;
        double min = 10000.0;
        int i = 0;
        while (i <= 10) {
            double oppX = this.bsi.team[1].player[i].x;
            double oppY = this.bsi.team[1].player[i].y;
            double dist = Utility.getDistance(px, py, oppX, oppY);
            if (dist < min) {
                min = dist;
            }
            ++i;
        }
        return min;
    }

    protected double getMinDistToOppPlayer(double x, double y) {
        double px = x;
        double py = y;
        double min = 10000.0;
        int i = 0;
        while (i <= 10) {
            double oppX = this.bsi.team[1].player[i].x;
            double oppY = this.bsi.team[1].player[i].y;
            double dist = Utility.getDistance(px, py, oppX, oppY);
            if (dist < min) {
                min = dist;
            }
            ++i;
        }
        return min;
    }

    protected boolean checkFreePlayer(PlayerInformation p, double dist) {
        double px = p.x;
        double py = p.y;
        boolean flag = false;
        int i = 0;
        do {
            double oppY;
            double oppX;
            double dist0;
            if (!((dist0 = Utility.getDistance(px, py, oppX = this.bsi.team[1].player[i].x, oppY = this.bsi.team[1].player[i].y)) > dist)) continue;
            flag = true;
            break;
        } while (++i <= 10);
        return flag;
    }

    public static void main(String[] arg) {
        double px = 10.0;
        double py = -10.0;
        double kx = 0.0;
        double ky = 0.0;
        double rad = Math.toRadians(20.0);
        double distKtoP = Utility.getDistance(px, py, kx, ky);
        boolean flag = true;
        double theta = Math.atan2(-py + ky, px - kx);
        System.out.println(Math.toDegrees(theta));
        double dist = distKtoP / Math.cos(rad);
        double y1 = dist * Math.sin(theta + rad);
        double y2 = dist * Math.sin(theta - rad);
        double x1 = dist * Math.cos(theta + rad);
        double x2 = dist * Math.cos(theta - rad);
        System.out.println(String.valueOf(x1) + "\t" + y1 + "\t" + x2 + "\t" + y2);
    }
}

