/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.Dribble;
import Analyzer.DribbleAnalyzer;
import Analyzer.KickAnalyzer;
import Analyzer.Pass;
import Analyzer.PassAnalyzer;
import Information.BaseSeeInformation;
import Information.Team;
import java.util.Observable;

public class OppAttackPatternAnalyzer
extends Analyzer {
    boolean makeLineForDribble = false;
    int[] split = new int[FIELD_SPLIT_NUM];
    int attackedByDribble = 0;
    int attackedByPass = 0;
    double minLineXForDribble;
    double maxLineXForDribble;
    double averageLineXForDribble;
    int kickIndex = 0;
    int[] kickTime = new int[2];
    boolean[] boolMakedDefLine = new boolean[2];
    double[] minLineX = new double[2];
    double[] maxLineX = new double[2];
    double[] averageLineX = new double[2];
    BaseSeeInformation bsi;
    int numOfSideAttack = 0;
    int numOfIntermediateAttack = 0;
    int numOfCenterAttack = 0;
    public static int SIDE_ATTACK = 0;
    public static int INTERMEDIATE_ATTACK = 1;
    public static int CENTER_ATTACK = 2;
    public static int[] MY_DEFENDERS = new int[]{2, 3, 4, 5};
    public static int FIELD_SPLIT_NUM = 10;
    public static double FIELD_SPLIT_DIST = 68.0 / (double)FIELD_SPLIT_NUM;

    public OppAttackPatternAnalyzer(BaseSeeInformation bsi, KickAnalyzer ka, DribbleAnalyzer da, PassAnalyzer pa) {
        this.bsi = bsi;
        ka.addObserver(this);
        da.addObserver(this);
        pa.addObserver(this);
        int i = 0;
        while (i <= 1) {
            this.kickTime[i] = 0;
            this.boolMakedDefLine[i] = false;
            this.minLineX[i] = 0.0;
            this.maxLineX[i] = 0.0;
            this.averageLineX[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < FIELD_SPLIT_NUM) {
            this.split[i] = 0;
            ++i;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof DribbleAnalyzer) {
            int type = (Integer)arg;
            this.checkDribble((DribbleAnalyzer)o, type);
        } else if (o instanceof PassAnalyzer) {
            this.checkPass((Pass)arg);
        } else if (o instanceof KickAnalyzer) {
            this.checkKick();
        }
    }

    public int[] getOppAttackPattern() {
        return this.split;
    }

    public int getAttackedNumber(int i) {
        return this.split[i];
    }

    public int getOppPassAttackNumber() {
        return this.attackedByPass;
    }

    public int getOppDribbleAttackNumber() {
        return this.attackedByDribble;
    }

    public int getTotalAttacked() {
        int num = 0;
        int i = 0;
        while (i < this.split.length) {
            num += this.split[i];
            ++i;
        }
        return num;
    }

    protected void checkDribble(DribbleAnalyzer da, int type) {
        Dribble d = da.getCurrentDribble();
        if (d.getSide() == 0) {
            return;
        }
        if (type == 0) {
            this.makeLineForDribble = this.checkMyDefenseLineForDribble();
        } else if (type == 1 && this.makeLineForDribble && this.bsi.ball.x < this.minLineXForDribble) {
            ++this.attackedByDribble;
            System.out.println("dribble attack:" + this.attackedByDribble);
            this.whereAttacked();
        }
    }

    protected void checkPass(Pass p) {
        int time = p.getPassTime();
        int index = 0;
        boolean adaptKick = false;
        int i = 0;
        while (i <= 1) {
            if (time == this.kickTime[i] && this.boolMakedDefLine[i]) {
                adaptKick = true;
                index = i;
                break;
            }
            ++i;
        }
        if (adaptKick && this.bsi.ball.x < this.minLineX[index]) {
            this.whereAttacked();
            ++this.attackedByPass;
            System.out.println("pass attack:" + this.attackedByPass);
        }
    }

    protected void whereAttacked() {
        this.makeLineForDribble = false;
        int index = (int)((this.bsi.ball.y + 34.0) / FIELD_SPLIT_DIST);
        if (index < 0) {
            System.out.println("something wrong????? index = 0");
            index = 0;
        } else if (index >= FIELD_SPLIT_NUM) {
            System.out.println("something wrong????? index = " + (FIELD_SPLIT_NUM - 1));
            index = FIELD_SPLIT_NUM - 1;
        }
        int n = index;
        this.split[n] = this.split[n] + 1;
        int i = 0;
        while (i <= 4) {
            System.out.println(String.valueOf(this.split[index]) + "attaked!!!!! " + index);
            ++i;
        }
    }

    protected void checkKick() {
        this.kickTime[this.kickIndex] = this.bsi.time;
        this.boolMakedDefLine[this.kickIndex] = this.checkMyDefenseLine();
        ++this.kickIndex;
        if (this.kickIndex >= 2) {
            this.kickIndex = 0;
        }
    }

    protected boolean checkMyDefenseLine() {
        boolean line;
        double sumX;
        double minPosX = sumX = this.bsi.team[0].player[OppAttackPatternAnalyzer.MY_DEFENDERS[0] - 1].x;
        double maxPosX = sumX;
        Team myTeam = this.bsi.team[0];
        int i = 1;
        while (i < MY_DEFENDERS.length) {
            sumX += myTeam.player[OppAttackPatternAnalyzer.MY_DEFENDERS[i] - 1].x;
            if (maxPosX < myTeam.player[OppAttackPatternAnalyzer.MY_DEFENDERS[i] - 1].x) {
                maxPosX = myTeam.player[OppAttackPatternAnalyzer.MY_DEFENDERS[i] - 1].x;
            } else if (minPosX > myTeam.player[OppAttackPatternAnalyzer.MY_DEFENDERS[i] - 1].x) {
                minPosX = myTeam.player[OppAttackPatternAnalyzer.MY_DEFENDERS[i] - 1].x;
            }
            ++i;
        }
        if (this.bsi.ball.x > minPosX) {
            line = true;
            this.averageLineX[this.kickIndex] = sumX / (double)MY_DEFENDERS.length;
            this.minLineX[this.kickIndex] = minPosX;
            this.maxLineX[this.kickIndex] = maxPosX;
        } else {
            line = false;
        }
        return line;
    }

    protected boolean checkMyDefenseLineForDribble() {
        boolean line;
        double sumX;
        double minPosX = sumX = this.bsi.team[0].player[OppAttackPatternAnalyzer.MY_DEFENDERS[0] - 1].x;
        double maxPosX = sumX;
        Team myTeam = this.bsi.team[0];
        int i = 1;
        while (i < MY_DEFENDERS.length) {
            sumX += myTeam.player[OppAttackPatternAnalyzer.MY_DEFENDERS[i] - 1].x;
            if (maxPosX < myTeam.player[OppAttackPatternAnalyzer.MY_DEFENDERS[i] - 1].x) {
                maxPosX = myTeam.player[OppAttackPatternAnalyzer.MY_DEFENDERS[i] - 1].x;
            } else if (minPosX > myTeam.player[OppAttackPatternAnalyzer.MY_DEFENDERS[i] - 1].x) {
                minPosX = myTeam.player[OppAttackPatternAnalyzer.MY_DEFENDERS[i] - 1].x;
            }
            ++i;
        }
        if (this.bsi.ball.x > minPosX) {
            line = true;
            this.averageLineXForDribble = sumX / (double)MY_DEFENDERS.length;
            this.minLineXForDribble = minPosX;
            this.maxLineXForDribble = maxPosX;
        } else {
            line = false;
        }
        System.out.println("check line" + line);
        return line;
    }
}

