/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.KickAnalyzer;
import Information.BallInformation;
import Information.BaseSeeInformation;
import Information.PlayerInformation;
import Utility.Utility;

public class KickAnalyzerDontUseFlag
extends KickAnalyzer {
    double[][] playerX0 = new double[2][11];
    double[][] playerY0 = new double[2][11];
    double ballX0;
    double ballY0;
    double ballDist0 = 0.0;
    double ballDist = 0.0;
    double angle0 = 0.0;
    double angle = 0.0;
    boolean init = false;

    public KickAnalyzerDontUseFlag(BaseSeeInformation bsi) {
        super(bsi);
    }

    @Override
    public void analyze() {
        if (this.init) {
            this.kickAnalyze();
        } else {
            this.initKickAnalyze();
        }
    }

    protected void kickAnalyze() {
        if (this.bsi.play_mode != 3) {
            BallInformation ball = this.bsi.ball;
            this.ballX0 = ball.x;
            this.ballY0 = ball.y;
            int side = 0;
            while (side <= 1) {
                int unum = 0;
                while (unum <= 10) {
                    PlayerInformation player = this.bsi.team[side].player[unum];
                    this.playerX0[side][unum] = player.x;
                    this.playerY0[side][unum] = player.y;
                    ++unum;
                }
                ++side;
            }
            return;
        }
        int minBallDist = 10000;
        int kickMember = -1;
        int kickMemberSide = -1;
        BallInformation ball = this.bsi.ball;
        boolean ballKicked = this.isBallKicked(ball.x, this.ballX0, ball.y, this.ballY0);
        this.ball_vx = ball.x - this.ballX0;
        this.ball_vy = ball.y - this.ballY0;
        int side = 0;
        while (side <= 1) {
            int unum = 0;
            while (unum <= 10) {
                PlayerInformation player = this.bsi.team[side].player[unum];
                if (player.enable != 0) {
                    double toBallDist0 = Utility.getDistance(this.playerX0[side][unum], this.playerY0[side][unum], this.ballX0, this.ballY0);
                    double toBallDist = Utility.getDistance(player.x, player.y, ball.x, ball.y);
                    this.playerX0[side][unum] = player.x;
                    this.playerY0[side][unum] = player.y;
                    if (toBallDist0 <= 1.885 && ballKicked && toBallDist < (double)minBallDist) {
                        kickMember = unum + 1;
                        kickMemberSide = side;
                    }
                }
                ++unum;
            }
            ++side;
        }
        if (this.bsi.play_mode != 3) {
            return;
        }
        if (kickMember != -1) {
            this.setKickMember(this.bsi.time, kickMember, kickMemberSide);
        }
        this.ballX0 = ball.x;
        this.ballY0 = ball.y;
    }

    protected void initKickAnalyze() {
        BallInformation ball = this.bsi.ball;
        this.ballX0 = ball.x;
        this.ballY0 = ball.y;
        int side = 0;
        while (side <= 1) {
            int unum = 0;
            while (unum <= 10) {
                PlayerInformation player = this.bsi.team[side].player[unum];
                this.playerX0[side][unum] = player.x;
                this.playerY0[side][unum] = player.y;
                ++unum;
            }
            ++side;
        }
        this.init = true;
    }

    protected boolean isBallKicked(double x1, double x2, double y1, double y2) {
        int MIN_KAKUDO = 15;
        boolean kicked = false;
        this.ballDist0 = this.ballDist;
        this.ballDist = Utility.getDistance(x1, y1, x2, y2);
        double xx = x2 - x1;
        double yy = y2 - y1;
        this.angle0 = this.angle;
        this.bsi.ball.angle = this.angle = Math.atan2(xx, yy);
        if (Math.abs(this.angle0 - this.angle) > Math.PI / 180 * (double)MIN_KAKUDO || this.ballDist > this.ballDist0) {
            kicked = true;
        }
        return kicked;
    }
}

