/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.Intercept;
import Analyzer.Kick;
import Analyzer.KickAnalyzer;
import Analyzer.PlayModeAnalyzer;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;

public class InterceptAnalyzer
extends Analyzer {
    Vector interceptVector;
    Vector kickVector;
    boolean continuousPlay = false;

    public InterceptAnalyzer(KickAnalyzer ka, PlayModeAnalyzer pma) {
        ka.addObserver(this);
        pma.addObserver(this);
        this.kickVector = ka.getKickVector();
        this.interceptVector = new Vector();
    }

    public Vector getInterceptVector() {
        return this.interceptVector;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof PlayModeAnalyzer) {
            PlayModeAnalyzer pma = (PlayModeAnalyzer)o;
            if (pma.getInformation() == 1) {
                this.continuousPlay = false;
            }
        } else if (arg instanceof KickAnalyzer) {
            if (this.continuousPlay) {
                this.analyze();
            } else {
                this.continuousPlay = true;
            }
        }
    }

    public void analyze() {
        int kickSize = this.kickVector.size();
        if (kickSize == 1) {
            return;
        }
        Kick beforeKick = (Kick)this.kickVector.elementAt(kickSize - 2);
        Kick thisKick = (Kick)this.kickVector.elementAt(kickSize - 1);
        if (thisKick.side != beforeKick.side) {
            Intercept inter = new Intercept(beforeKick.member, thisKick.member, beforeKick.posX, beforeKick.posY, thisKick.posX, thisKick.posY, beforeKick.time, thisKick.time, thisKick.side);
            this.interceptVector.addElement(inter);
            this.setChanged();
            this.notifyObservers(this);
            System.out.println("Intercept " + thisKick.member + "  " + beforeKick.member + "kara");
        }
    }

    public int getPlayerIntercept(int unum, int side) {
        int inter = 0;
        Enumeration enu = this.interceptVector.elements();
        while (enu.hasMoreElements()) {
            Intercept i = (Intercept)enu.nextElement();
            if (i.getIntercepterUnum() != unum || i.getIntercepterSide() != side) continue;
            ++inter;
        }
        return inter;
    }

    public int getTotalIntercept(int side) {
        int inter = 0;
        Enumeration enu = this.interceptVector.elements();
        while (enu.hasMoreElements()) {
            Intercept i = (Intercept)enu.nextElement();
            if (i.getIntercepterSide() != side) continue;
            ++inter;
        }
        return inter;
    }
}

