/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.Goal;
import Analyzer.Kick;
import Analyzer.KickAnalyzer;
import Analyzer.PlayModeAnalyzer;
import Information.BaseSeeInformation;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;

public class GoalAnalyzer
extends Analyzer {
    private static final boolean VERBOSE = true;
    KickAnalyzer ka;
    BaseSeeInformation bsi;
    Vector goalVector;
    public int play_mode;

    public GoalAnalyzer(BaseSeeInformation bsi, PlayModeAnalyzer pma, KickAnalyzer ka) {
        this.bsi = bsi;
        this.ka = ka;
        pma.addObserver(this);
        this.goalVector = new Vector();
    }

    public Vector getGoalVector() {
        return this.goalVector;
    }

    @Override
    public void update(Observable o, Object arg) {
        PlayModeAnalyzer p;
        int mode;
        if (o instanceof PlayModeAnalyzer && ((mode = (p = (PlayModeAnalyzer)o).getCurrentPlayMode()) == 14 || mode == 15)) {
            this.play_mode = mode;
            this.analyze();
        }
    }

    public void analyze() {
        Goal goal;
        Kick kick = (Kick)this.ka.getKickVector().lastElement();
        int side = kick.getSide();
        if (this.play_mode == 14) {
            side = 0;
        } else if (this.play_mode == 15) {
            side = 1;
        } else {
            new IllegalArgumentException();
        }
        if (this.play_mode == 14 && side == 0 || this.play_mode == 15 && side == 1) {
            goal = new Goal(kick.getMember(), side, this.bsi.time, true);
            this.goalVector.addElement(goal);
        } else {
            goal = new Goal(kick.getMember(), side, this.bsi.time, true);
            this.goalVector.addElement(goal);
        }
        this.setChanged();
        this.notifyObservers(goal);
        System.out.println("goal " + goal.getMember() + "no_own " + goal.isNoOwnGoal());
    }

    public int getPlayerGoal(int unum, int side) {
        int goal = 0;
        Enumeration enu = this.goalVector.elements();
        while (enu.hasMoreElements()) {
            Goal g = (Goal)enu.nextElement();
            if (g.getMember() != unum || g.getSide() != side) continue;
            ++goal;
        }
        return goal;
    }
}

