/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.MessageSender;
import Analyzer.OppAttackPatternAnalyzer;
import Analyzer.PlayModeAnalyzer;
import Analyzer.PositionTable;
import Analyzer.StaminaAnalyzer;
import Information.BaseSeeInformation;
import java.util.Observable;

public class FormationAnalyzer
extends Analyzer {
    double ball_pos_percentage;
    double ball_pos_percentage0;
    double my_team_pos;
    double my_team_pos0;
    int time0 = 0;
    int time = 0;
    OppAttackPatternAnalyzer oapa;
    BaseSeeInformation bsi;
    StaminaAnalyzer sa;
    MessageSender ms;
    int width_form;
    int width_form0;
    int length_form;
    int length_form0;
    int formation_type;
    int formation_type0;
    PositionTable posTable = new PositionTable();
    boolean useSweeper = false;
    public static final int NORMAL = 1;
    public static final int NARROW = 2;
    public static final int WIDE = 3;
    public static final int DEFENSIVE = 4;
    public static final int OFFENSIVE = 5;
    public static final double DEFENSIVE_DIST = 5.0;
    public static double[][] presentStartPos;
    public static double[][] presentStdPos;
    public static double[][] prevStartPos;
    public static double[][] prevStdPos;

    public FormationAnalyzer(OppAttackPatternAnalyzer oapa, MessageSender ms, BaseSeeInformation bsi, PlayModeAnalyzer pa, StaminaAnalyzer sa, int formation_type) {
        this.oapa = oapa;
        this.ms = ms;
        this.bsi = bsi;
        this.sa = sa;
        this.formation_type0 = this.formation_type = formation_type;
        presentStartPos = this.posTable.startPos[formation_type];
        presentStdPos = this.posTable.stdPos[formation_type];
        prevStartPos = this.posTable.startPos[formation_type];
        prevStdPos = this.posTable.stdPos[formation_type];
        this.width_form0 = 1;
        this.width_form = 1;
        this.length_form0 = 1;
        this.length_form = 1;
        pa.addObserver(this);
    }

    public void setSweeper(boolean sweeper) {
        this.useSweeper = sweeper;
    }

    public double[][] getPosition() {
        return presentStdPos;
    }

    public double[][] getStartPosition() {
        return presentStartPos;
    }

    public double[][] getPrevPosition() {
        return prevStdPos;
    }

    public double[][] getPrevStartPosition() {
        return prevStartPos;
    }

    @Override
    public void update(Observable o, Object arg) {
        PlayModeAnalyzer pma;
        if (o instanceof PlayModeAnalyzer && (pma = (PlayModeAnalyzer)o).getInformation() == 1 && (this.bsi.play_mode == 15 || this.bsi.play_mode == 14)) {
            this.analyze();
        }
    }

    public double getPosPercentage() {
        return this.ball_pos_percentage;
    }

    public double getMyTeamPos() {
        return this.my_team_pos;
    }

    public double getBeforePosPercentage() {
        return this.ball_pos_percentage0;
    }

    public double getBeforeMyTeamPos() {
        return this.my_team_pos0;
    }

    public int getTime() {
        return this.time;
    }

    public int getBeforeTime() {
        return this.time0;
    }

    public void analyze() {
        this.analyzeDefenseWideness();
        this.checkPlayersStamina();
        this.checkUseSweeper();
        if (this.setPosition()) {
            System.out.println("send");
            this.send();
        }
        this.setChanged();
        this.notifyObservers(this);
    }

    public void analyzeDefenseWideness() {
        int sideAttack = this.oapa.getAttackedNumber(0) + this.oapa.getAttackedNumber(1) + this.oapa.getAttackedNumber(8) + this.oapa.getAttackedNumber(9);
        int centerAttack = this.oapa.getAttackedNumber(4) + this.oapa.getAttackedNumber(5);
        int totalAttack = this.oapa.getTotalAttacked();
        if (totalAttack >= 5) {
            if ((double)sideAttack / (double)totalAttack > 0.4) {
                System.out.println("wide formation");
                this.width_form0 = this.width_form;
                this.width_form = 3;
            } else if ((double)centerAttack / (double)totalAttack > 0.4) {
                this.width_form0 = this.width_form;
                this.width_form = 2;
                System.out.println("narrow formation");
            } else {
                this.width_form0 = this.width_form;
                this.width_form = 1;
                System.out.println("normal formation");
            }
        }
    }

    public void checkPlayersStamina() {
        int num = 0;
        int i = 1;
        while (i <= this.getDefenderNumber()) {
            if (this.sa.isStaminaLack(i + 1)) {
                ++num;
            }
            ++i;
        }
        if (num >= 2 && this.bsi.team[0].score - this.bsi.team[1].score <= -2) {
            this.length_form0 = this.length_form;
            this.length_form = 4;
            System.out.println("DEFENSIVE formation");
        } else {
            this.length_form0 = this.length_form;
            this.length_form = 1;
            System.out.println("normal formation");
        }
    }

    protected int getDefenderNumber() {
        int num = 0;
        int i = 0;
        while (i <= 10) {
            if (this.posTable.role[this.formation_type][i].equals("DF")) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public void checkUseSweeper() {
        if (!this.useSweeper) {
            int driAttack = this.oapa.getOppDribbleAttackNumber();
            int passAttack = this.oapa.getOppPassAttackNumber();
            int totalAttack = this.oapa.getTotalAttacked();
            int myScore = this.bsi.team[0].score;
            int eneScore = this.bsi.team[1].score;
            if (driAttack >= 1) {
                int i = 0;
                while (i <= 10) {
                    System.out.println("use sweeper");
                    ++i;
                }
                this.useSweeper = true;
                this.ms.addMessage("(set Sweeper)");
            }
        }
    }

    protected boolean setPosition() {
        double maxY;
        double minY;
        int maxYindex;
        int minYindex;
        if (this.width_form0 == this.width_form && this.length_form0 == this.length_form && this.formation_type0 == this.formation_type) {
            return false;
        }
        prevStartPos = presentStartPos;
        prevStdPos = presentStdPos;
        presentStartPos = new PositionTable().startPos[this.formation_type];
        presentStdPos = new PositionTable().stdPos[this.formation_type];
        if (this.width_form == 3) {
            minYindex = 1;
            maxYindex = 1;
            minY = presentStdPos[1][1];
            maxY = presentStdPos[1][1];
            int i = 2;
            while (i <= this.getDefenderNumber()) {
                if (minY > presentStdPos[i][1]) {
                    minY = presentStdPos[i][1];
                    minYindex = i;
                } else if (maxY < presentStdPos[i][1]) {
                    maxY = presentStdPos[i][1];
                    maxYindex = i;
                }
                ++i;
            }
            double[] dArray = presentStdPos[minYindex];
            dArray[1] = dArray[1] - 5.0;
            double[] dArray2 = presentStartPos[minYindex];
            dArray2[1] = dArray2[1] - 5.0;
            double[] dArray3 = presentStdPos[maxYindex];
            dArray3[1] = dArray3[1] + 5.0;
            double[] dArray4 = presentStartPos[maxYindex];
            dArray4[1] = dArray4[1] + 5.0;
        } else if (this.width_form == 2) {
            minYindex = 1;
            maxYindex = 1;
            minY = presentStdPos[1][1];
            maxY = presentStdPos[1][1];
            int i = 2;
            while (i <= this.getDefenderNumber()) {
                if (minY > presentStdPos[i][1]) {
                    minY = presentStdPos[i][1];
                    minYindex = i;
                } else if (maxY < presentStdPos[i][1]) {
                    maxY = presentStdPos[i][1];
                    maxYindex = i;
                }
                ++i;
            }
            if (this.getDefenderNumber() == 3) {
                System.out.println("test2");
                double[] dArray = presentStdPos[minYindex];
                dArray[1] = dArray[1] + 5.0;
                double[] dArray5 = presentStartPos[minYindex];
                dArray5[1] = dArray5[1] + 5.0;
                double[] dArray6 = presentStdPos[maxYindex];
                dArray6[1] = dArray6[1] - 5.0;
                double[] dArray7 = presentStartPos[maxYindex];
                dArray7[1] = dArray7[1] - 5.0;
            } else if (this.getDefenderNumber() == 4) {
                int[] index = new int[2];
                int count = 0;
                int i2 = 1;
                while (i2 <= 4) {
                    if (i2 != maxYindex && i2 != minYindex) {
                        index[count] = i2;
                        ++count;
                    }
                    ++i2;
                }
                System.out.println("test1");
                double diff = Math.abs(presentStdPos[index[0]][1]) / 2.0;
                System.out.println("diff" + diff);
                if (presentStdPos[index[0]][1] > presentStdPos[index[1]][1]) {
                    double[] dArray = presentStdPos[index[0]];
                    dArray[1] = dArray[1] - diff;
                    double[] dArray8 = presentStartPos[index[0]];
                    dArray8[1] = dArray8[1] - diff;
                    double[] dArray9 = presentStdPos[index[1]];
                    dArray9[1] = dArray9[1] + diff;
                    double[] dArray10 = presentStartPos[index[1]];
                    dArray10[1] = dArray10[1] + diff;
                } else {
                    double[] dArray = presentStdPos[index[0]];
                    dArray[1] = dArray[1] + diff;
                    double[] dArray11 = presentStartPos[index[0]];
                    dArray11[1] = dArray11[1] + diff;
                    double[] dArray12 = presentStdPos[index[1]];
                    dArray12[1] = dArray12[1] - diff;
                    double[] dArray13 = presentStartPos[index[1]];
                    dArray13[1] = dArray13[1] - diff;
                }
            }
        }
        if (this.length_form == 4) {
            int i = 0;
            while (i <= 10) {
                if (this.posTable.role[this.formation_type][i].equals("DF") || this.posTable.role[this.formation_type][i].equals("MF")) {
                    double[] dArray = presentStdPos[i];
                    dArray[0] = dArray[0] - 5.0;
                    double[] dArray14 = presentStartPos[i];
                    dArray14[0] = dArray14[0] - 5.0;
                    System.out.print("bakced" + i + "\t");
                }
                ++i;
            }
        }
        return true;
    }

    protected void send() {
        String str0 = new String();
        String str = new String();
        double[][] pos = this.getPosition();
        double[][] pos0 = this.getPrevPosition();
        double[][] startPos = this.getStartPosition();
        double[][] startPos0 = this.getPrevStartPosition();
        int i = 0;
        while (i < 11) {
            double x = pos[i][0];
            double y = pos[i][1];
            double x0 = pos0[i][0];
            double y0 = pos0[i][1];
            double sx = startPos[i][0];
            double sy = startPos[i][1];
            double sx0 = startPos0[i][0];
            double sy0 = startPos0[i][1];
            if (x != x0 || y != y0 || sx != sx0 || sy != sy0) {
                str = "(Pos " + (i + 1) + " " + startPos[i][0] + " " + startPos[i][1] + " " + pos[i][0] + " " + pos[i][1] + ")";
                this.ms.addMessage(str);
            }
            ++i;
        }
    }
}

