/*
 * Decompiled with CFR 0.152.
 */
package Analyzer;

import Analyzer.Analyzer;
import Analyzer.Dribble;
import Analyzer.DribblePoint;
import Analyzer.Kick;
import Analyzer.KickAnalyzer;
import Analyzer.PlayModeAnalyzer;
import java.util.Observable;
import java.util.Vector;

public class DribbleAnalyzer
extends Analyzer {
    Vector dribbleVector;
    Vector kickVector;
    boolean continuousPlay = false;
    boolean isDribbling;
    Dribble d;
    public static final double MIN_DRIBBLE_DISTANCE = 1.0;
    public static final int NEW_DRIBBLE = 0;
    public static final int CONTINUAL_DRIBBLE = 1;

    public DribbleAnalyzer(KickAnalyzer ka, PlayModeAnalyzer pma) {
        ka.addObserver(this);
        pma.addObserver(this);
        this.kickVector = ka.getKickVector();
        this.dribbleVector = new Vector();
    }

    public Vector getDribbleVector() {
        return this.dribbleVector;
    }

    public double getCurrentDribbleDistance() {
        return this.d.getTotalDistance();
    }

    public Dribble getCurrentDribble() {
        return this.d;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof PlayModeAnalyzer) {
            PlayModeAnalyzer pma = (PlayModeAnalyzer)o;
            if (pma.getInformation() == 1) {
                this.continuousPlay = false;
                this.isDribbling = false;
            }
        } else if (arg instanceof KickAnalyzer) {
            if (this.continuousPlay) {
                this.analyze();
            } else {
                this.continuousPlay = true;
                this.isDribbling = false;
            }
        }
    }

    public void analyze() {
        int kickSize = this.kickVector.size();
        if (kickSize == 1) {
            return;
        }
        Kick beforeKick = (Kick)this.kickVector.elementAt(kickSize - 2);
        Kick thisKick = (Kick)this.kickVector.elementAt(kickSize - 1);
        if (thisKick.getSide() == beforeKick.getSide() && thisKick.getMember() == beforeKick.getMember()) {
            if (!this.isDribbling) {
                this.d = new Dribble(thisKick.member, thisKick.getSide(), new DribblePoint(beforeKick.posX, beforeKick.posY, beforeKick.time), new DribblePoint(thisKick.posX, thisKick.posY, thisKick.time));
                this.dribbleVector.addElement(this.d);
                this.isDribbling = true;
                this.setChanged();
                this.notifyObservers(new Integer(0));
            } else {
                this.d.addPoint(new DribblePoint(thisKick.posX, thisKick.posY, thisKick.time));
                this.setChanged();
                this.notifyObservers(new Integer(1));
                System.out.println("dribbling:" + thisKick.member);
            }
        } else {
            this.isDribbling = false;
        }
    }
}

